/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.world.gen.placement;

import baguchi.tofucraft.TofuCraftReload;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.world.gen.features.ModVegetationFeatures;
import baguchi.tofucraft.world.gen.features.TofuWorldFeatures;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public class TofuWorldPlacements {
    public static final PlacementModifier TREE_THRESHOLD = SurfaceWaterDepthFilter.forMaxDepth((int)0);
    public static final ResourceKey<PlacedFeature> ORE_KINU_TOFU = TofuWorldPlacements.registerKey("ore_kinu_tofu");
    public static final ResourceKey<PlacedFeature> ORE_MINCED_TOFU = TofuWorldPlacements.registerKey("ore_minced_tofu");
    public static final ResourceKey<PlacedFeature> ORE_TOFU_DIAMOND = TofuWorldPlacements.registerKey("ore_tofu_diamond");
    public static final ResourceKey<PlacedFeature> ORE_TOFU_DIAMOND_MEDIUM = TofuWorldPlacements.registerKey("ore_tofu_diamond_medium");
    public static final ResourceKey<PlacedFeature> ORE_TOFU_DIAMOND_LARGE = TofuWorldPlacements.registerKey("ore_tofu_diamond_large");
    public static final ResourceKey<PlacedFeature> ORE_TOFU_DIAMOND_BURIED = TofuWorldPlacements.registerKey("ore_tofu_diamond_buried");
    public static final ResourceKey<PlacedFeature> ORE_SOY_FORCE = TofuWorldPlacements.registerKey("ore_soy_force");
    public static final ResourceKey<PlacedFeature> ORE_TOFUGEM = TofuWorldPlacements.registerKey("ore_tofugem");
    public static final ResourceKey<PlacedFeature> ORE_TOFUGEM_LARGE = TofuWorldPlacements.registerKey("ore_tofugem_large");
    public static final ResourceKey<PlacedFeature> TOFU_DELTA = TofuWorldPlacements.registerKey("tofu_delta");
    public static final ResourceKey<PlacedFeature> PATCH_LEEK = TofuWorldPlacements.registerKey("patch_leek");
    public static final ResourceKey<PlacedFeature> PATCH_LEEK_WASTE = TofuWorldPlacements.registerKey("patch_leek_waste");
    public static final ResourceKey<PlacedFeature> PATCH_TOFU_FLOWER = TofuWorldPlacements.registerKey("patch_tofu_flower");
    public static final ResourceKey<PlacedFeature> LEEK_BONEMEAL = TofuWorldPlacements.registerKey("leek_bonemeal");
    public static final ResourceKey<PlacedFeature> BIG_LEEK = TofuWorldPlacements.registerKey("big_leek");
    public static final ResourceKey<PlacedFeature> TOFU_BUILDING = TofuWorldPlacements.registerKey("tofu_building");
    public static final ResourceKey<PlacedFeature> PATCH_ZUNDA_TOFU_MUSHROOM = TofuWorldPlacements.registerKey("patch_zunda_tofu_mushroom");
    public static final ResourceKey<PlacedFeature> BIG_ZUNDA_TOFU_MUSHROOM = TofuWorldPlacements.registerKey("big_zunda_tofu_mushroom");
    public static final ResourceKey<PlacedFeature> TOFU_TREES_FOREST = TofuWorldPlacements.registerKey("tofu_trees_forest");
    public static final ResourceKey<PlacedFeature> TOFU_TREES_PLAINS = TofuWorldPlacements.registerKey("tofu_trees_plains");

    public static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)TofuCraftReload.prefix(name));
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeature = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, ORE_KINU_TOFU, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.ORE_KINU_TOFU), TofuWorldPlacements.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.top())));
        PlacementUtils.register(context, ORE_MINCED_TOFU, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.ORE_MINCED_TOFU), TofuWorldPlacements.commonOrePlacement(16, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.top())));
        PlacementUtils.register(context, ORE_TOFU_DIAMOND, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.ORE_DIAMOND_SMALL), TofuWorldPlacements.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-80), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        PlacementUtils.register(context, ORE_TOFU_DIAMOND_MEDIUM, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.ORE_DIAMOND_MEDIUM), TofuWorldPlacements.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)-4))));
        PlacementUtils.register(context, ORE_TOFU_DIAMOND_LARGE, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.ORE_DIAMOND_LARGE), TofuWorldPlacements.rareOrePlacement(6, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-80), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        PlacementUtils.register(context, ORE_TOFU_DIAMOND_BURIED, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.ORE_DIAMOND_BURIED), TofuWorldPlacements.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-80), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        PlacementUtils.register(context, ORE_SOY_FORCE, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.ORE_SOY_FORCE), TofuWorldPlacements.commonOrePlacement(18, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)64))));
        PlacementUtils.register(context, ORE_TOFUGEM, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.ORE_TOFUGEM_SMALL), TofuWorldPlacements.commonOrePlacement(15, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)136), (VerticalAnchor)VerticalAnchor.top())));
        PlacementUtils.register(context, ORE_TOFUGEM_LARGE, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.ORE_TOFUGEM_LARGE), TofuWorldPlacements.commonOrePlacement(22, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)60))));
        PlacementUtils.register(context, TOFU_DELTA, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.TOFU_DELTA), (PlacementModifier[])new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)30), BiomeFilter.biome()});
        PlacementUtils.register(context, PATCH_TOFU_FLOWER, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.TOFU_FLOWER), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, PATCH_LEEK, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.LEEK), (PlacementModifier[])new PlacementModifier[]{NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, PATCH_LEEK_WASTE, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.LEEK), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, LEEK_BONEMEAL, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.LEEK), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.isEmpty()});
        PlacementUtils.register(context, BIG_LEEK, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.BIG_LEEK), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.countExtra((int)3, (float)0.1f, (int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, TOFU_BUILDING, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.TOFU_BUILDING), (PlacementModifier[])new PlacementModifier[]{PlacementUtils.countExtra((int)2, (float)0.1f, (int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, PATCH_ZUNDA_TOFU_MUSHROOM, (Holder)configuredFeature.getOrThrow(TofuWorldFeatures.ZUNDA_TOFU_MUSHROOM), (PlacementModifier[])new PlacementModifier[]{InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, BIG_ZUNDA_TOFU_MUSHROOM, (Holder)configuredFeature.getOrThrow(ModVegetationFeatures.BIG_ZUNDA_TOFU_MUSHROOM), TofuWorldPlacements.treePlacement(PlacementUtils.countExtra((int)1, (float)0.1f, (int)1), (Block)TofuBlocks.ZUNDATOFU_MUSHROOM.get()));
        PlacementUtils.register(context, TOFU_TREES_FOREST, (Holder)configuredFeature.getOrThrow(ModVegetationFeatures.TOFU_TREES), TofuWorldPlacements.treePlacement(PlacementUtils.countExtra((int)10, (float)0.1f, (int)1), (Block)TofuBlocks.SAPLING_TOFU.get()));
        PlacementUtils.register(context, TOFU_TREES_PLAINS, (Holder)configuredFeature.getOrThrow(ModVegetationFeatures.TOFU_TREES), TofuWorldPlacements.treePlacement(PlacementUtils.countExtra((int)0, (float)0.01f, (int)1), (Block)TofuBlocks.SAPLING_TOFU.get()));
    }

    private static ImmutableList.Builder<PlacementModifier> treePlacementBase(PlacementModifier p_195485_) {
        return ImmutableList.builder().add((Object)p_195485_).add((Object)InSquarePlacement.spread()).add((Object)TREE_THRESHOLD).add((Object)PlacementUtils.HEIGHTMAP_OCEAN_FLOOR).add((Object)BiomeFilter.biome());
    }

    public static List<PlacementModifier> treePlacement(PlacementModifier p_195480_) {
        return TofuWorldPlacements.treePlacementBase(p_195480_).build();
    }

    public static List<PlacementModifier> treePlacement(PlacementModifier p_195482_, Block p_195483_) {
        return TofuWorldPlacements.treePlacementBase(p_195482_).add((Object)BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.wouldSurvive((BlockState)p_195483_.defaultBlockState(), (Vec3i)BlockPos.ZERO))).build();
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.spread(), p_195348_, BiomeFilter.biome());
    }

    private static List<PlacementModifier> commonOrePlacement(int p_195344_, PlacementModifier p_195345_) {
        return TofuWorldPlacements.orePlacement((PlacementModifier)CountPlacement.of((int)p_195344_), p_195345_);
    }

    private static List<PlacementModifier> rareOrePlacement(int p_195350_, PlacementModifier p_195351_) {
        return TofuWorldPlacements.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)p_195350_), p_195351_);
    }
}

