/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft;

import baguchan.tofucraft.TofuCraftReload;
import baguchan.tofucraft.api.tfenergy.IEnergyContained;
import baguchan.tofucraft.block.utils.SoymilkCauldronBlock;
import baguchan.tofucraft.blockentity.SuspiciousTofuBlockEntity;
import baguchan.tofucraft.capability.SoyHealthCapability;
import baguchan.tofucraft.capability.TofuLivingCapability;
import baguchan.tofucraft.item.TofuPickaxeItem;
import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuDimensions;
import baguchan.tofucraft.registry.TofuEnchantments;
import baguchan.tofucraft.registry.TofuItems;
import baguchan.tofucraft.registry.TofuPoiTypes;
import baguchan.tofucraft.registry.TofuStructures;
import baguchan.tofucraft.registry.TofuTags;
import baguchan.tofucraft.utils.ContainerUtils;
import baguchan.tofucraft.utils.JigsawHelper;
import baguchan.tofucraft.utils.RecipeHelper;
import baguchan.tofucraft.world.TofuData;
import baguchan.tofucraft.world.TofuLevelData;
import baguchan.tofucraft.world.TravelerTofunianSpawner;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.village.VillageSiegeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tofucraft")
public class CommonEvents {
    private static final Map<ServerLevel, TravelerTofunianSpawner> TRAVELER_TOFUNIAN_SPAWNER_MAP = new HashMap<ServerLevel, TravelerTofunianSpawner>();

    @SubscribeEvent
    public static void onRegisterEntityCapabilities(RegisterCapabilitiesEvent event) {
        event.register(SoyHealthCapability.class);
        event.register(TofuLivingCapability.class);
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("tofucraft", "soy_health"), (ICapabilityProvider)new SoyHealthCapability());
            event.addCapability(new ResourceLocation("tofucraft", "tofu_living"), (ICapabilityProvider)new TofuLivingCapability());
        }
    }

    @SubscribeEvent
    public static void onUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!livingEntity.m_9236_().m_5776_()) {
            livingEntity.getCapability(TofuCraftReload.SOY_HEALTH_CAPABILITY).ifPresent(cap -> cap.tick(livingEntity));
        }
        livingEntity.getCapability(TofuCraftReload.TOFU_LIVING_CAPABILITY).ifPresent(tofuLivingCapability -> tofuLivingCapability.tick((Entity)livingEntity));
    }

    protected static BlockHitResult getPlayerPOVHitResult(Level p_41436_, Player p_41437_, ClipContext.Fluid p_41438_) {
        float f = p_41437_.m_146909_();
        float f1 = p_41437_.m_146908_();
        Vec3 vec3 = p_41437_.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = p_41437_.getBlockReach();
        Vec3 vec31 = vec3.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return p_41436_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, p_41438_, (Entity)p_41437_));
    }

    @SubscribeEvent
    public static void onUsingItem(LivingEntityUseItemEvent event) {
        LivingEntity livingEntity;
        ItemStack stack = event.getItem();
        Level level = event.getEntity().m_9236_();
        if (stack.m_150930_(Items.f_271356_) && (livingEntity = event.getEntity()) instanceof Player) {
            SuspiciousTofuBlockEntity suspicioussandblockentity;
            boolean flag;
            BlockEntity $$11;
            Player player = (Player)livingEntity;
            BlockHitResult blockhitresult = CommonEvents.getPlayerPOVHitResult(level, player, ClipContext.Fluid.NONE);
            BlockPos $$7 = blockhitresult.m_82425_();
            BlockState blockstate = level.m_8055_($$7);
            if (!level.m_5776_() && blockstate.m_60713_((Block)TofuBlocks.SUSPICIOUS_TOFU_TERRAIN.get()) && ($$11 = level.m_7702_($$7)) instanceof SuspiciousTofuBlockEntity && (flag = (suspicioussandblockentity = (SuspiciousTofuBlockEntity)$$11).m_276923_(level.m_46467_(), player, blockhitresult.m_82434_()))) {
                stack.m_41622_(1, event.getEntity(), p_272600_ -> p_272600_.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
    }

    @SubscribeEvent
    public static void onUsedEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        Entity entity = event.getTarget();
        if (entity instanceof AbstractHorse) {
            TofuLivingCapability capability;
            AbstractHorse horse = (AbstractHorse)entity;
            if (stack.m_150930_((Item)TofuItems.SALT.get()) && (capability = (TofuLivingCapability)horse.getCapability(TofuCraftReload.TOFU_LIVING_CAPABILITY).orElse(null)) != null && capability.getSaltBoostCooldown() <= 0) {
                capability.setSaltBoost(3600, 4200, (LivingEntity)horse);
                if (!event.getEntity().m_7500_()) {
                    stack.m_41774_(1);
                }
                horse.m_146850_(GameEvent.f_157806_);
                horse.m_216990_(SoundEvents.f_11976_);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onUsed(PlayerInteractEvent.RightClickItem event) {
        InteractionHand handIn;
        Level level = event.getLevel();
        Player playerIn = event.getEntity();
        ItemStack itemstack = playerIn.m_21120_(handIn = event.getHand());
        if (itemstack.m_204117_(TofuTags.Items.BITTERN)) {
            BlockHitResult blockraytraceresult = CommonEvents.getPlayerPOVHitResult(level, playerIn, ClipContext.Fluid.SOURCE_ONLY);
            BlockHitResult blockraytraceresult1 = blockraytraceresult.m_82430_(blockraytraceresult.m_82425_());
            if (level instanceof ServerLevel) {
                FluidState fluidState;
                ItemStack result;
                ServerLevel serverLevel = (ServerLevel)level;
                if (blockraytraceresult.m_6662_() == HitResult.Type.BLOCK && (result = RecipeHelper.getBitternResult(serverLevel, (fluidState = level.m_6425_(blockraytraceresult1.m_82425_())).m_76152_(), itemstack.m_255036_(1))) != null) {
                    if (playerIn instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                        CriteriaTriggers.f_10562_.m_285767_(serverPlayer, blockraytraceresult1.m_82425_(), itemstack);
                    }
                    level.m_7731_(blockraytraceresult1.m_82425_(), Block.m_49814_((Item)result.m_41720_()).m_49966_(), 11);
                    level.m_46796_(2001, blockraytraceresult1.m_82425_(), Block.m_49956_((BlockState)level.m_8055_(blockraytraceresult1.m_82425_())));
                    level.m_5594_(null, blockraytraceresult1.m_82425_(), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    ContainerUtils.addWithContainer(playerIn, handIn, itemstack, new ItemStack((ItemLike)Items.f_42590_), false);
                    playerIn.m_6674_(handIn);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockUsed(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemstack2;
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        if (stack.m_150930_((Item)TofuItems.BUCKET_SOYMILK.get()) && stack.m_150930_((Item)TofuItems.BUCKET_SOYMILK.get()) && level.m_8055_(event.getPos()).m_60713_(Blocks.f_50256_)) {
            level.m_7731_(event.getPos(), ((SoymilkCauldronBlock)((Object)TofuBlocks.SOYMILK_CAULDRON.get())).m_49966_(), 2);
            event.getEntity().m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
            itemstack2 = new ItemStack((ItemLike)Items.f_42446_);
            if (!event.getEntity().m_7500_()) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                event.getEntity().m_21008_(event.getHand(), itemstack2);
            } else if (!event.getEntity().m_7500_() && !event.getEntity().m_150109_().m_36054_(itemstack2)) {
                event.getEntity().m_36176_(itemstack2, false);
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        if (stack.m_150930_((Item)TofuItems.BUCKET_SOYMILK_NETHER.get()) && level.m_8055_(event.getPos()).m_60713_(Blocks.f_50256_)) {
            level.m_7731_(event.getPos(), ((SoymilkCauldronBlock)((Object)TofuBlocks.SOYMILK_NETHER_CAULDRON.get())).m_49966_(), 2);
            event.getEntity().m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
            itemstack2 = new ItemStack((ItemLike)Items.f_42446_);
            if (!event.getEntity().m_7500_()) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                event.getEntity().m_21008_(event.getHand(), itemstack2);
            } else if (!event.getEntity().m_7500_() && !event.getEntity().m_150109_().m_36054_(itemstack2)) {
                event.getEntity().m_36176_(itemstack2, false);
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        if (stack.m_150930_((Item)TofuItems.BUCKET_SOYMILK_SOUL.get()) && level.m_8055_(event.getPos()).m_60713_(Blocks.f_50256_)) {
            level.m_7731_(event.getPos(), ((SoymilkCauldronBlock)((Object)TofuBlocks.SOYMILK_SOUL_CAULDRON.get())).m_49966_(), 2);
            event.getEntity().m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
            itemstack2 = new ItemStack((ItemLike)Items.f_42446_);
            if (!event.getEntity().m_7500_()) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                event.getEntity().m_21008_(event.getHand(), itemstack2);
            } else if (!event.getEntity().m_7500_() && !event.getEntity().m_150109_().m_36054_(itemstack2)) {
                event.getEntity().m_36176_(itemstack2, false);
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockGriefing(EntityMobGriefingEvent event) {
        ServerLevel serverLevel;
        Structure structure;
        Entity entity = event.getEntity();
        Level world = event.getEntity().m_9236_();
        if (world instanceof ServerLevel && (structure = (Structure)(serverLevel = (ServerLevel)world).m_9598_().m_175515_(Registries.f_256944_).m_6246_(TofuStructures.TOFU_CASTLE)) != null) {
            TofuData data = TofuData.get((Level)serverLevel);
            Vec3 center = event.getEntity().m_20182_();
            StructureStart structureStart = serverLevel.m_215010_().m_220494_(new BlockPos((int)center.f_82479_, (int)center.f_82480_, (int)center.f_82481_), structure);
            if (structureStart.m_73603_() && !data.getBeatenDungeons().contains(structureStart.m_73601_())) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onBreakingSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack stack = event.getEntity().m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof TofuPickaxeItem) {
            TofuPickaxeItem pickaxeItem = (TofuPickaxeItem)item;
            int level = EnchantmentHelper.m_44836_((Enchantment)TofuEnchantments.BATCH.get(), (LivingEntity)event.getEntity());
            if (level > 0) {
                event.setNewSpeed(event.getOriginalSpeed() / ((float)level + 1.25f));
            }
        }
    }

    @SubscribeEvent
    public static void onBlockDestroyByEntity(LivingDestroyBlockEvent event) {
        ServerLevel serverLevel;
        Structure structure;
        Level world = event.getEntity().m_9236_();
        if (world instanceof ServerLevel && (structure = (Structure)(serverLevel = (ServerLevel)world).m_9598_().m_175515_(Registries.f_256944_).m_6246_(TofuStructures.TOFU_CASTLE)) != null) {
            TofuData data = TofuData.get((Level)serverLevel);
            Vec3 center = event.getEntity().m_20182_();
            StructureStart structureStart = serverLevel.m_215010_().m_220494_(new BlockPos((int)center.f_82479_, (int)center.f_82480_, (int)center.f_82481_), structure);
            if (structureStart.m_73603_() && !data.getBeatenDungeons().contains(structureStart.m_73601_())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockExplosion(ExplosionEvent.Detonate event) {
        ServerLevel serverLevel;
        Structure structure;
        Level world = event.getLevel();
        if (world instanceof ServerLevel && (structure = (Structure)(serverLevel = (ServerLevel)world).m_9598_().m_175515_(Registries.f_256944_).m_6246_(TofuStructures.TOFU_CASTLE)) != null) {
            TofuData data = TofuData.get((Level)serverLevel);
            Vec3 center = event.getExplosion().getPosition();
            StructureStart structureStart = serverLevel.m_215010_().m_220494_(new BlockPos((int)center.f_82479_, (int)center.f_82480_, (int)center.f_82481_), structure);
            if (structureStart.m_73603_() && !data.getBeatenDungeons().contains(structureStart.m_73601_())) {
                event.getAffectedBlocks().clear();
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreaked(BlockEvent.BreakEvent event) {
        ServerLevel serverLevel;
        Structure structure;
        Level world;
        if (event.getPlayer() instanceof ServerPlayer && (world = event.getPlayer().m_9236_()) instanceof ServerLevel && (structure = (Structure)(serverLevel = (ServerLevel)world).m_9598_().m_175515_(Registries.f_256944_).m_6246_(TofuStructures.TOFU_CASTLE)) != null) {
            ServerPlayer player;
            TofuData data = TofuData.get((Level)serverLevel);
            StructureStart structureStart = serverLevel.m_215010_().m_220494_(event.getPos(), structure);
            if (structureStart.m_73603_() && !data.getBeatenDungeons().contains(structureStart.m_73601_()) && !(player = (ServerPlayer)event.getPlayer()).m_7500_() && !(event.getState().m_60734_() instanceof TorchBlock)) {
                player.m_5661_((Component)Component.m_237115_((String)"tofucraft.need_defeat_boss"), true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        ServerLevel serverLevel;
        Structure structure;
        Level world;
        if (event.getEntity() instanceof ServerPlayer && (world = event.getEntity().m_9236_()) instanceof ServerLevel && (structure = (Structure)(serverLevel = (ServerLevel)world).m_9598_().m_175515_(Registries.f_256944_).m_6246_(TofuStructures.TOFU_CASTLE)) != null) {
            ServerPlayer player;
            TofuData data = TofuData.get((Level)serverLevel);
            StructureStart structureStart = serverLevel.m_215010_().m_220494_(event.getPos(), structure);
            if (structureStart.m_73603_() && !data.getBeatenDungeons().contains(structureStart.m_73601_()) && !(player = (ServerPlayer)event.getEntity()).m_7500_() && !(event.getState().m_60734_() instanceof TorchBlock)) {
                player.m_5661_((Component)Component.m_237115_((String)"tofucraft.need_defeat_boss"), true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onCheckSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Optional optional;
        Mob livingEntity = event.getEntity();
        ServerLevelAccessor level = event.getLevel();
        if (livingEntity instanceof Enemy && event.getSpawnType() != MobSpawnType.SPAWNER && event.getSpawnType() != MobSpawnType.EVENT && event.getSpawnType() != MobSpawnType.BREEDING && event.getSpawnType() != MobSpawnType.PATROL && level instanceof ServerLevel && (optional = ((ServerLevel)level).m_8904_().m_148658_(p_184069_ -> p_184069_.m_203565_(TofuPoiTypes.MORIJIO), p_184055_ -> true, livingEntity.m_20183_(), 32, PoiManager.Occupancy.ANY)).isPresent()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onCheckZombieSiege(VillageSiegeEvent event) {
        Optional optional;
        Vec3 vec3 = event.getAttemptedSpawnPos();
        Level level = event.getLevel();
        if (level instanceof ServerLevel && (optional = ((ServerLevel)level).m_8904_().m_148658_(p_184069_ -> p_184069_.m_203565_(TofuPoiTypes.MORIJIO), p_184055_ -> true, BlockPos.m_274446_((Position)vec3), 48, PoiManager.Occupancy.ANY)).isPresent()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).m_220362_().m_135782_().equals((Object)TofuDimensions.tofu_world.m_135782_())) {
            TofuLevelData levelData = new TofuLevelData(level.m_7654_().m_129910_(), level.m_7654_().m_129910_().m_5996_());
            level.f_8549_ = levelData;
            level.f_46442_ = levelData;
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.LevelTickEvent tick) {
        Level level;
        if (!tick.level.f_46443_ && (level = tick.level) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            TRAVELER_TOFUNIAN_SPAWNER_MAP.computeIfAbsent(serverWorld, k -> new TravelerTofunianSpawner(serverWorld));
            TravelerTofunianSpawner spawner = TRAVELER_TOFUNIAN_SPAWNER_MAP.get(serverWorld);
            spawner.tick();
        }
    }

    @SubscribeEvent
    public static void onServerAboutToStartEvent(ServerStartedEvent event) {
        JigsawHelper.registerJigsaw(event.getServer(), new ResourceLocation("minecraft:village/plains/houses"), new ResourceLocation("tofucraft:village/tofu_craftsman_house_plains_1"), 10);
        JigsawHelper.registerJigsaw(event.getServer(), new ResourceLocation("minecraft:village/taiga/houses"), new ResourceLocation("tofucraft:village/tofu_craftsman_house_taiga_1"), 10);
        JigsawHelper.registerJigsaw(event.getServer(), new ResourceLocation("minecraft:village/savanna/houses"), new ResourceLocation("tofucraft:village/tofu_craftsman_house_savanna_1"), 10);
        JigsawHelper.registerJigsaw(event.getServer(), new ResourceLocation("minecraft:village/snowy/houses"), new ResourceLocation("tofucraft:village/tofu_craftsman_house_snowy_1"), 10);
        JigsawHelper.registerJigsaw(event.getServer(), new ResourceLocation("minecraft:village/desert/houses"), new ResourceLocation("tofucraft:village/tofu_craftsman_house_desert_1"), 10);
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        if (!event.isWasDeath()) {
            oldPlayer.getCapability(TofuCraftReload.SOY_HEALTH_CAPABILITY).ifPresent(oldcap -> newPlayer.getCapability(TofuCraftReload.SOY_HEALTH_CAPABILITY).ifPresent(cap -> cap.deserializeNBT(oldcap.serializeNBT())));
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21275_(event.getSource()) && entity.m_21211_().m_150930_((Item)TofuItems.REFLECT_TOFU_SHIELD.get())) {
            IEnergyContained energyContained;
            Entity attacker = event.getSource().m_7640_();
            Item item = entity.m_21211_().m_41720_();
            if (item instanceof IEnergyContained && (energyContained = (IEnergyContained)item).getEnergy(entity.m_21211_()) >= 50) {
                energyContained.setEnergy(entity.m_21211_(), energyContained.getEnergy(entity.m_21211_()) - 50);
                if (attacker != null) {
                    attacker.m_6469_(entity.m_269291_().m_269374_((Entity)entity), 3.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onShieldEvent(ShieldBlockEvent event) {
        IEnergyContained energyContained;
        Item item;
        if (event.getEntity().m_21211_().m_150930_((Item)TofuItems.REFLECT_TOFU_SHIELD.get()) && (item = event.getEntity().m_21211_().m_41720_()) instanceof IEnergyContained && (energyContained = (IEnergyContained)item).getEnergy(event.getEntity().m_21211_()) >= 50) {
            event.setShieldTakesDamage(false);
        }
    }

    @SubscribeEvent
    public static void onBlockModificationEvent(PlayerInteractEvent.RightClickBlock event) {
        boolean shroomlight;
        InteractionHand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (player != null && stack.m_150930_(Items.f_42590_) && (shroomlight = level.m_8055_(pos).m_60713_(Blocks.f_50701_))) {
            if (!level.f_46443_) {
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)Blocks.f_50701_.m_49966_()));
            }
            player.m_216990_(SoundEvents.f_11770_);
            ContainerUtils.addWithContainer(player, hand, stack, ((Item)TofuItems.SHROOM_BOTTLE.get()).m_7968_(), true);
            level.m_7471_(pos, false);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onPotionEffectApplied(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance() != null && event.getEffectInstance().m_19544_().m_19483_() == MobEffectCategory.HARMFUL && EnchantmentHelper.m_44836_((Enchantment)TofuEnchantments.EFFECT_PROTECTION.get(), (LivingEntity)event.getEntity()) > 0) {
            event.setResult(Event.Result.DENY);
        }
    }
}

