/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block;

import baguchan.tofucraft.block.TofuBlock;
import baguchan.tofucraft.registry.TofuEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class KinuTofuBlock
extends Block {
    public KinuTofuBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        super.m_214162_(stateIn, worldIn, pos, rand);
        if (this.isUnderWeight(worldIn, pos) && rand.m_188503_(4) == 0) {
            double d4 = rand.m_188499_() ? 0.8 : -0.8;
            double d0 = (double)pos.m_123341_() + 0.5 + (double)rand.m_188501_() * d4;
            double d1 = (float)pos.m_123342_() + rand.m_188501_();
            double d2 = (double)pos.m_123343_() + 0.5 + (double)rand.m_188501_() * d4;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123803_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void m_142072_(Level p_152426_, BlockState p_152427_, BlockPos p_152428_, Entity p_152429_, float p_152430_) {
        super.m_142072_(p_152426_, p_152427_, p_152428_, p_152429_, p_152430_ * 0.25f);
        if (p_152430_ > 0.5f && !p_152429_.m_6095_().m_204039_(EntityTypeTags.f_144291_)) {
            p_152426_.m_46961_(p_152428_, true);
        }
    }

    public void m_213898_(BlockState p_225542_1_, ServerLevel p_225542_2_, BlockPos p_225542_3_, RandomSource p_225542_4_) {
        super.m_213898_(p_225542_1_, p_225542_2_, p_225542_3_, p_225542_4_);
        if (this.isUnderWeight((Level)p_225542_2_, p_225542_3_)) {
            p_225542_2_.m_46961_(p_225542_3_, true);
        }
    }

    public boolean isUnderWeight(Level world, BlockPos pos) {
        BlockState weightBlock = world.m_8055_(pos.m_7494_());
        BlockState baseBlock = world.m_8055_(pos.m_7495_());
        float weightHardness = weightBlock.m_60800_((BlockGetter)world, pos.m_7494_());
        boolean isWeightValid = weightBlock != null && (weightHardness >= 1.0f || weightHardness < 0.0f) && !(weightBlock.m_60734_() instanceof TofuBlock);
        float baseHardness = baseBlock.m_60800_((BlockGetter)world, pos.m_7495_());
        boolean isBaseValid = baseBlock.m_60838_((BlockGetter)world, pos) && (baseHardness >= 1.0f || baseHardness < 0.0f) && !(baseBlock.m_60734_() instanceof TofuBlock);
        return isWeightValid && isBaseValid;
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return TofuEntityTypes.UNSTABLE_TOFU_PATH;
    }

    @Nullable
    public BlockPathTypes getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, BlockPathTypes originalType) {
        return TofuEntityTypes.UNSTABLE_TOFU_PATH;
    }
}

