/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block;

import baguchan.tofucraft.entity.TofuGolem;
import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuEntityTypes;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;

public class TofuGemBlock
extends Block {
    @Nullable
    private BlockPattern tofuGolemBase;
    @Nullable
    private BlockPattern tofuGolemFull;

    public TofuGemBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6807_(BlockState p_51387_, Level p_51388_, BlockPos p_51389_, BlockState p_51390_, boolean p_51391_) {
        if (!p_51390_.m_60713_(p_51387_.m_60734_())) {
            this.trySpawnGolem(p_51388_, p_51389_);
        }
    }

    public boolean canSpawnGolem(LevelReader p_51382_, BlockPos p_51383_) {
        return this.getOrCreateTofuGolemBase().m_61184_(p_51382_, p_51383_) != null;
    }

    private void trySpawnGolem(Level p_51379_, BlockPos p_51380_) {
        TofuGolem tofuGolem;
        BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch = this.getOrCreateTofuGolemFull().m_61184_((LevelReader)p_51379_, p_51380_);
        if (blockpattern$blockpatternmatch != null && (tofuGolem = (TofuGolem)((EntityType)TofuEntityTypes.TOFU_GOLEM.get()).m_20615_(p_51379_)) != null) {
            tofuGolem.setPlayerCreated(true);
            TofuGemBlock.spawnGolemInWorld(p_51379_, blockpattern$blockpatternmatch, (Entity)tofuGolem, blockpattern$blockpatternmatch.m_61229_(0, 2, 0).m_61176_());
        }
    }

    private static void spawnGolemInWorld(Level p_249110_, BlockPattern.BlockPatternMatch p_251293_, Entity p_251251_, BlockPos p_251189_) {
        TofuGemBlock.clearPatternBlocks(p_249110_, p_251293_);
        p_251251_.m_7678_((double)p_251189_.m_123341_() + 0.5, (double)p_251189_.m_123342_() + 0.05, (double)p_251189_.m_123343_() + 0.5, 0.0f, 0.0f);
        p_249110_.m_7967_(p_251251_);
        for (ServerPlayer serverplayer : p_249110_.m_45976_(ServerPlayer.class, p_251251_.m_20191_().m_82400_(5.0))) {
            CriteriaTriggers.f_10580_.m_68256_(serverplayer, p_251251_);
        }
        TofuGemBlock.updatePatternBlocks(p_249110_, p_251293_);
    }

    public static void clearPatternBlocks(Level p_249604_, BlockPattern.BlockPatternMatch p_251190_) {
        for (int i = 0; i < p_251190_.m_155970_(); ++i) {
            for (int j = 0; j < p_251190_.m_155971_(); ++j) {
                BlockInWorld blockinworld = p_251190_.m_61229_(i, j, 0);
                p_249604_.m_7731_(blockinworld.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                p_249604_.m_46796_(2001, blockinworld.m_61176_(), Block.m_49956_((BlockState)blockinworld.m_61168_()));
            }
        }
    }

    public static void updatePatternBlocks(Level p_248711_, BlockPattern.BlockPatternMatch p_251935_) {
        for (int i = 0; i < p_251935_.m_155970_(); ++i) {
            for (int j = 0; j < p_251935_.m_155971_(); ++j) {
                BlockInWorld blockinworld = p_251935_.m_61229_(i, j, 0);
                p_248711_.m_6289_(blockinworld.m_61176_(), Blocks.f_50016_);
            }
        }
    }

    private BlockPattern getOrCreateTofuGolemBase() {
        if (this.tofuGolemBase == null) {
            this.tofuGolemBase = BlockPatternBuilder.m_61243_().m_61247_(new String[]{" ", "#", "#"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)TofuBlocks.ISHITOFU.get())))).m_61249_();
        }
        return this.tofuGolemBase;
    }

    private BlockPattern getOrCreateTofuGolemFull() {
        if (this.tofuGolemFull == null) {
            this.tofuGolemFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"^", "#", "#"}).m_61244_('^', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)TofuBlocks.TOFU_GEM_BLOCK.get())))).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)TofuBlocks.ISHITOFU.get())))).m_61249_();
        }
        return this.tofuGolemFull;
    }
}

