/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block.utils;

import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuItems;
import baguchan.tofucraft.utils.TileScanner;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SproutsJarBlock
extends Block
implements SimpleWaterloggedBlock {
    public static VoxelShape SPROUTSJAR_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final EnumProperty<Stat> STAT = EnumProperty.m_61587_((String)"stat", Stat.class);
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public SproutsJarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos) && !worldIn.m_183326_().m_183582_(currentPos, (Object)this)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
            Stat stat = this.getStat(stateIn);
            if (stat == Stat.EMPTY) {
                worldIn.m_7731_(currentPos, (BlockState)stateIn.m_61124_(STAT, (Comparable)((Object)Stat.WATER)), 3);
            } else if (stat == Stat.SPROUTS_3) {
                ItemStack sprouts = new ItemStack((ItemLike)TofuItems.SPROUTS.get(), 1);
                if (worldIn instanceof Level) {
                    float f = 0.7f;
                    double d0 = (double)(worldIn.m_213780_().m_188501_() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(worldIn.m_213780_().m_188501_() * f) + (double)(1.0f - f) * 0.2 + 0.6;
                    double d2 = (double)(worldIn.m_213780_().m_188501_() * f) + (double)(1.0f - f) * 0.5;
                    ItemEntity itemEntity = new ItemEntity((Level)worldIn, (double)currentPos.m_123341_() + d0, (double)currentPos.m_123342_() + d1, (double)currentPos.m_123343_() + d2, sprouts);
                    itemEntity.m_32010_(10);
                    worldIn.m_7967_((Entity)itemEntity);
                }
                worldIn.m_7731_(currentPos, (BlockState)stateIn.m_61124_(STAT, (Comparable)((Object)Stat.WATER)), 3);
            }
        }
        return facing.m_122434_().m_122479_() ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, currentPos.m_122012_())))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, currentPos.m_122029_())))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, currentPos.m_122019_())))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, currentPos.m_122024_()))) : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        return blockstate.m_60734_() == this ? (BlockState)((BlockState)((BlockState)((BlockState)context.m_43725_().m_8055_(context.m_8083_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)context.m_43725_(), context.m_8083_().m_122012_())))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)context.m_43725_(), context.m_8083_().m_122029_())))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)context.m_43725_(), context.m_8083_().m_122019_())))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)context.m_43725_(), context.m_8083_().m_122024_()))) : super.m_5573_(context);
    }

    public boolean m_7898_(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        return p_196260_2_.m_8055_(p_196260_3_.m_7495_()).m_280296_();
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemHeld = player.m_21120_(handIn);
        Stat stat = this.getStat(state);
        if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            if (stat == Stat.EMPTY && itemHeld != null && itemHeld.m_41720_() == Items.f_42447_) {
                if (!player.m_7500_()) {
                    player.m_21008_(handIn, new ItemStack((ItemLike)Items.f_42446_));
                }
                worldIn.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                TileScanner tileScanner = new TileScanner(worldIn, pos);
                tileScanner.scan(1, TileScanner.Method.fullSimply, new TileScanner.Impl<Object>(){

                    @Override
                    public void apply(Level world, BlockPos pos) {
                        if (SproutsJarBlock.this.getStat(world.m_8055_(pos)) == Stat.EMPTY) {
                            world.m_7731_(pos, (BlockState)((Block)TofuBlocks.SPROUTSJAR.get()).m_49966_().m_61124_(STAT, (Comparable)((Object)Stat.WATER)), 3);
                        }
                    }
                });
                worldIn.m_7731_(pos, (BlockState)state.m_61124_(STAT, (Comparable)((Object)Stat.WATER)), 3);
                return InteractionResult.SUCCESS;
            }
            if (stat == Stat.WATER && itemHeld != null && itemHeld.m_41720_() == Items.f_42446_) {
                ItemStack water = new ItemStack((ItemLike)Items.f_42447_);
                worldIn.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (itemHeld.m_41613_() == 1) {
                    player.m_21008_(handIn, water);
                } else {
                    if (player.m_150109_().m_36054_(water)) {
                        worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, water));
                    }
                    itemHeld.m_41774_(1);
                }
                worldIn.m_7731_(pos, (BlockState)state.m_61124_(STAT, (Comparable)((Object)Stat.EMPTY)), 3);
                return InteractionResult.SUCCESS;
            }
            if (stat == Stat.WATER && itemHeld != null && itemHeld.m_41720_() == TofuItems.SEEDS_SOYBEANS.get()) {
                if (!player.m_7500_()) {
                    itemHeld.m_41774_(1);
                }
                worldIn.m_5594_(null, pos, SoundEvents.f_11828_, SoundSource.BLOCKS, 1.0f, 1.0f);
                worldIn.m_7731_(pos, (BlockState)state.m_61124_(STAT, (Comparable)((Object)Stat.SPROUTS_0)), 3);
                return InteractionResult.SUCCESS;
            }
            if (stat == Stat.SPROUTS_3) {
                ItemStack salt = new ItemStack((ItemLike)TofuItems.SPROUTS.get(), 1);
                float f = 0.7f;
                double d0 = (double)(worldIn.f_46441_.m_188501_() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(worldIn.f_46441_.m_188501_() * f) + (double)(1.0f - f) * 0.2 + 0.6;
                double d2 = (double)(worldIn.f_46441_.m_188501_() * f) + (double)(1.0f - f) * 0.5;
                ItemEntity itemEntity = new ItemEntity(worldIn, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, salt);
                itemEntity.m_32010_(10);
                worldIn.m_7967_((Entity)itemEntity);
                worldIn.m_7731_(pos, (BlockState)state.m_61124_(STAT, (Comparable)((Object)Stat.WATER)), 3);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
        }
        Stat stat = this.getStat(state);
        int l = stat.getMeta();
        if (stat == Stat.SPROUTS_0 && this.canGrowing((Level)worldIn, pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_(STAT, (Comparable)((Object)Stat.SPROUTS_1)), 3);
        }
        if (stat == Stat.SPROUTS_1 && this.canGrowing((Level)worldIn, pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_(STAT, (Comparable)((Object)Stat.SPROUTS_2)), 3);
        }
        if (stat == Stat.SPROUTS_2 && this.canGrowing((Level)worldIn, pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_(STAT, (Comparable)((Object)Stat.SPROUTS_3)), 3);
        }
    }

    public Stat getStat(BlockState meta) {
        if (meta.m_60734_() == this) {
            return (Stat)((Object)meta.m_61143_(STAT));
        }
        return Stat.NA;
    }

    public boolean canConnectTo(LevelAccessor worldIn, BlockPos pos) {
        Block block = worldIn.m_8055_(pos).m_60734_();
        return block instanceof SproutsJarBlock;
    }

    public boolean canGrowing(Level world, BlockPos pos) {
        return world.m_45524_(pos, 0) <= 8;
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SPROUTSJAR_AABB;
    }

    public RenderShape m_7514_(BlockState p_60550_) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STAT, NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_204507_1_);
    }

    public static enum Stat implements StringRepresentable
    {
        EMPTY(0, "empty"),
        WATER(1, "water"),
        SPROUTS_0(2, "sprouts_0"),
        SPROUTS_1(3, "sprouts_1"),
        SPROUTS_2(4, "sprouts_2"),
        SPROUTS_3(5, "sprouts_3"),
        NA(6, "na");

        private static final Stat[] META_LOOKUP;
        private final int meta;
        private final String name;

        private Stat(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            META_LOOKUP = new Stat[Stat.values().length];
            Stat[] statArray = Stat.values();
            int n = statArray.length;
            for (int i = 0; i < n; ++i) {
                Stat enumtype;
                Stat.META_LOOKUP[enumtype.getMeta()] = enumtype = statArray[i];
            }
        }
    }
}

