/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.blockentity;

import baguchan.tofucraft.block.utils.TofuPotBlock;
import baguchan.tofucraft.blockentity.SyncedBlockEntity;
import baguchan.tofucraft.inventory.TofuPotMenu;
import baguchan.tofucraft.recipe.TofuPotRecipe;
import baguchan.tofucraft.registry.TofuBlockEntitys;
import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuRecipes;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class TofuPotBlockEntity
extends SyncedBlockEntity
implements MenuProvider,
RecipeHolder,
Nameable,
Container {
    public static final int CONTAINER_SLOT = 12;
    public static final int OUTPUT_SLOT = 13;
    public static final int INVENTORY_SIZE = 14;
    public NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)14, (Object)ItemStack.f_41583_);
    private int cookTime;
    private int cookTimeTotal;
    private Component customName;
    protected final ContainerData cookingPotData;
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<Container, TofuPotRecipe> quickCheck;
    public FluidTank fluidTank = new FluidTank(2000){

        protected void onContentsChanged() {
            TofuPotBlockEntity.this.inventoryChanged();
        }

        public boolean isFluidValid(FluidStack stack) {
            return true;
        }
    };
    private final LazyOptional<IFluidHandler> holder;

    public TofuPotBlockEntity(BlockPos pos, BlockState state) {
        super(TofuBlockEntitys.TOFU_POT.get(), pos, state);
        this.cookingPotData = this.createIntArray();
        this.quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)TofuRecipes.RECIPETYPE_TOFU_POT.get()));
        this.holder = LazyOptional.of(() -> this.fluidTank);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory = NonNullList.m_122780_((int)14, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, this.inventory);
        this.cookTime = compound.m_128451_("CookTime");
        this.cookTimeTotal = compound.m_128451_("CookTimeTotal");
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        CompoundTag compoundRecipes = compound.m_128469_("RecipesUsed");
        for (String key : compoundRecipes.m_128431_()) {
            this.recipesUsed.put((Object)ResourceLocation.m_135820_((String)key), compoundRecipes.m_128451_(key));
        }
        this.fluidTank = this.fluidTank.readFromNBT(compound.m_128469_("Tank"));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("CookTime", this.cookTime);
        compound.m_128405_("CookTimeTotal", this.cookTimeTotal);
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        ContainerHelper.m_18973_((CompoundTag)compound, this.inventory);
        CompoundTag compoundRecipes = new CompoundTag();
        this.recipesUsed.forEach((recipeId, craftedAmount) -> compoundRecipes.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        compound.m_128365_("RecipesUsed", (Tag)compoundRecipes);
        CompoundTag tankTag = this.fluidTank.writeToNBT(new CompoundTag());
        compound.m_128365_("Tank", (Tag)tankTag);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        CompoundTag tankTag = this.fluidTank.writeToNBT(new CompoundTag());
        compound.m_128365_("Tank", (Tag)tankTag);
        ContainerHelper.m_18973_((CompoundTag)compound, this.inventory);
        return compound;
    }

    public ItemStack getAsItem() {
        ItemStack stack = new ItemStack((ItemLike)TofuBlocks.TOFU_POT.get());
        return stack;
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, TofuPotBlockEntity cookingPot) {
        boolean isHeated = cookingPot.isHeated(level, pos);
        boolean didInventoryChange = false;
        if (isHeated && cookingPot.hasInput()) {
            Optional<TofuPotRecipe> recipe = cookingPot.getMatchingRecipe();
            if (recipe.isPresent() && cookingPot.canCook(recipe.get()) && recipe.get().matchesWithFluid(cookingPot.fluidTank.getFluid(), cookingPot, level)) {
                didInventoryChange = cookingPot.processCooking(recipe.get(), cookingPot);
            } else {
                cookingPot.cookTime = 0;
            }
        } else if (cookingPot.cookTime > 0) {
            cookingPot.cookTime = Mth.m_14045_((int)(cookingPot.cookTime - 2), (int)0, (int)cookingPot.cookTimeTotal);
        }
        if (didInventoryChange) {
            cookingPot.inventoryChanged();
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, TofuPotBlockEntity cookingPot) {
        RandomSource random;
        if (cookingPot.isHeated(level, pos) && (random = level.f_46441_).m_188501_() < 0.2f) {
            double x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() * 0.6 - 0.3);
            double y = (double)pos.m_123342_() + 1.2;
            double z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() * 0.6 - 0.3);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123772_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private Optional<TofuPotRecipe> getMatchingRecipe() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        return this.hasInput() ? this.quickCheck.m_213657_((Container)new SimpleContainer((ItemStack[])this.inventory.stream().limit(13L).toArray(ItemStack[]::new)), this.f_58857_) : Optional.empty();
    }

    private boolean hasInput() {
        for (int i = 0; i < 13; ++i) {
            if (((ItemStack)this.inventory.get(i)).m_41619_()) continue;
            return true;
        }
        return false;
    }

    protected boolean canCook(TofuPotRecipe recipe) {
        int i = this.m_6893_();
        if (this.hasInput()) {
            ItemStack resultStack = recipe.m_8043_(this.f_58857_.m_9598_());
            if (resultStack.m_41619_()) {
                return false;
            }
            ItemStack storedMealStack = (ItemStack)this.inventory.get(13);
            if (storedMealStack.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)storedMealStack, (ItemStack)resultStack)) {
                return false;
            }
            if (storedMealStack.m_41613_() + resultStack.m_41613_() <= i && storedMealStack.m_41613_() + resultStack.m_41613_() <= storedMealStack.m_41741_()) {
                return true;
            }
            return storedMealStack.m_41613_() + resultStack.m_41613_() <= resultStack.m_41741_();
        }
        return false;
    }

    private boolean processCooking(TofuPotRecipe recipe, TofuPotBlockEntity cookingPot) {
        if (this.f_58857_ == null) {
            return false;
        }
        ++this.cookTime;
        this.cookTimeTotal = recipe.getCookTime();
        if (this.cookTime < this.cookTimeTotal) {
            return false;
        }
        this.cookTime = 0;
        ItemStack resultStack = recipe.m_8043_(this.f_58857_.m_9598_());
        ItemStack storedMealStack = (ItemStack)this.inventory.get(13);
        if (storedMealStack.m_41619_()) {
            this.inventory.set(13, (Object)resultStack.m_41777_());
        } else if (ItemStack.m_41656_((ItemStack)storedMealStack, (ItemStack)resultStack)) {
            storedMealStack.m_41769_(resultStack.m_41613_());
        }
        if (!recipe.matchesWithFluid(this.fluidTank.getFluid(), this, this.f_58857_)) {
            cookingPot.fluidTank.drain(250, IFluidHandler.FluidAction.EXECUTE);
        }
        cookingPot.m_6029_(recipe);
        for (int i = 0; i < 13; ++i) {
            ItemStack slotStack = (ItemStack)this.inventory.get(i);
            if (slotStack.hasCraftingRemainingItem()) {
                this.ejectIngredientRemainder(slotStack.getCraftingRemainingItem());
            }
            if (slotStack.m_41619_()) continue;
            slotStack.m_41774_(1);
        }
        return true;
    }

    protected void ejectIngredientRemainder(ItemStack remainderStack) {
        Direction direction = ((Direction)this.m_58900_().m_61143_((Property)TofuPotBlock.FACING)).m_122428_();
        double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
        double y = (double)this.f_58858_.m_123342_() + 0.7;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
        ItemEntity entity = new ItemEntity(this.f_58857_, x, y, z, remainderStack);
        entity.m_20334_((double)((float)direction.m_122429_() * 0.08f), 0.25, (double)((float)direction.m_122431_() * 0.08f));
        this.f_58857_.m_7967_((Entity)entity);
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeID = recipe.m_6423_();
            this.recipesUsed.addTo((Object)recipeID, 1);
        }
    }

    @javax.annotation.Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer p_155004_) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(p_155004_.m_284548_(), p_155004_.m_20182_());
        p_155004_.m_7281_(list);
        for (Recipe<?> recipe : list) {
            if (recipe == null) continue;
            p_155004_.m_280300_(recipe, this.inventory);
        }
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel p_154996_, Vec3 p_154997_) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            p_154996_.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(p_155023_ -> {
                list.add(p_155023_);
                TofuPotBlockEntity.createExperience(p_154996_, p_154997_, entry.getIntValue(), ((TofuPotRecipe)p_155023_).getExperience());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel p_154999_, Vec3 p_155000_, int p_155001_, float p_155002_) {
        int i = Mth.m_14143_((float)((float)p_155001_ * p_155002_));
        float f = Mth.m_14187_((float)((float)p_155001_ * p_155002_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)p_154999_, (Vec3)p_155000_, (int)i);
    }

    public boolean isHeated() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.isHeated(this.f_58857_, this.f_58858_);
    }

    private boolean isHeated(Level level, BlockPos worldPosition) {
        return level.m_8055_(worldPosition.m_7495_()).m_204336_(BlockTags.f_13076_) || level.m_8055_(worldPosition.m_7495_()).m_204336_(BlockTags.f_13087_);
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        for (int i = 0; i < 14; ++i) {
            if (i == 13) continue;
            drops.add((Object)((ItemStack)this.inventory.get(i)));
        }
        return drops;
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : Component.m_237115_((String)"container.tofucraft.tofu_pot");
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @javax.annotation.Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory player, Player entity) {
        return new TofuPotMenu(id, player, this, this.cookingPotData);
    }

    @Override
    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(14){

            protected void onContentsChanged(int slot) {
                TofuPotBlockEntity.this.inventoryChanged();
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> TofuPotBlockEntity.this.cookTime;
                    case 1 -> TofuPotBlockEntity.this.cookTimeTotal;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        TofuPotBlockEntity.this.cookTime = value;
                        break;
                    }
                    case 1: {
                        TofuPotBlockEntity.this.cookTimeTotal = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public int m_6643_() {
        return 14;
    }

    public boolean m_7983_() {
        return this.inventory.isEmpty();
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack m_7407_(int p_70298_1_, int p_70298_2_) {
        return ContainerHelper.m_18969_(this.inventory, (int)p_70298_1_, (int)p_70298_2_);
    }

    public ItemStack m_8016_(int p_70304_1_) {
        return ContainerHelper.m_18966_(this.inventory, (int)p_70304_1_);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public boolean m_6542_(Player p_70300_1_) {
        return Container.m_272074_((BlockEntity)this, (Player)p_70300_1_);
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            if (facing == Direction.UP) {
                return this.holder.cast();
            }
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }
}

