/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.blockentity;

import baguchan.tofucraft.block.TofunianStatueBlock;
import baguchan.tofucraft.blockentity.FoodPlateBlockEntity;
import baguchan.tofucraft.blockentity.SyncedBlockEntity;
import baguchan.tofucraft.registry.TofuBlockEntitys;
import baguchan.tofucraft.registry.TofuParticleTypes;
import baguchan.tofucraft.registry.TofuTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class TofunianStatueBlockEntity
extends SyncedBlockEntity {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("tofucraft", "gameplay/tofunian_statue");
    private int processTick;
    private long cooldown;
    private float happyScale;
    private long happyTime;

    public TofunianStatueBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TofuBlockEntitys.TOFUNIAN_STATUE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState blockstate, TofunianStatueBlockEntity statue) {
        BlockPos platePos;
        BlockEntity blockEntity;
        if (!level.m_5776_() && statue.cooldown <= level.m_46467_() && (blockEntity = level.m_7702_(platePos = pos.m_121945_((Direction)blockstate.m_61143_((Property)TofunianStatueBlock.FACING)))) instanceof FoodPlateBlockEntity) {
            FoodPlateBlockEntity foodPlate = (FoodPlateBlockEntity)blockEntity;
            if (foodPlate.getStoredItem().m_204117_(TofuTags.Items.STATUE_HAPPY)) {
                if (++statue.processTick > 200) {
                    foodPlate.removeItem();
                    LootTable loottable = level.m_7654_().m_278653_().m_278676_(LOOT_TABLE);
                    LootParams lootparams = new LootParams.Builder((ServerLevel)level).m_287239_(statue.happyScale).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)platePos)).m_287235_(LootContextParamSets.f_81411_);
                    ObjectArrayList objectarraylist = loottable.m_287195_(lootparams);
                    foodPlate.addAllItem((ItemStack)objectarraylist.get(0));
                    statue.processTick = 0;
                    statue.cooldown = level.m_46467_() + 12000L + (long)level.f_46441_.m_188503_(12000);
                    statue.happyTime = statue.getCooldown() + 24000L;
                    statue.happyScale = Mth.m_14036_((float)(statue.happyScale + 1.0f), (float)0.0f, (float)5.0f);
                    level.m_247517_(null, platePos, SoundEvents.f_11887_, SoundSource.BLOCKS);
                } else if (level.f_46441_.m_188503_(4) == 0) {
                    ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)TofuParticleTypes.TOFU_PORTAL.get()), (double)((float)platePos.m_123341_() + 0.5f), (double)((float)platePos.m_123342_() + 0.1f), (double)((float)platePos.m_123343_() + 0.5f), 1, 0.0, 0.0, 0.0, 1.0);
                }
            } else {
                if (statue.happyTime < level.m_46467_()) {
                    statue.happyTime = 12000L + level.m_46467_();
                    statue.happyScale = Mth.m_14036_((float)(statue.happyScale - 0.25f), (float)0.0f, (float)5.0f);
                }
                statue.processTick = 0;
            }
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.setProcessTick(compound.m_128451_("ProcessTick"));
        this.setCooldown(compound.m_128454_("CooldownAt"));
        this.setHappyScale(compound.m_128457_("HappyScale"));
        this.setHappyTime(compound.m_128454_("HappyTimeAt"));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("ProcessTick", this.getProcessTick());
        compound.m_128356_("CooldownAt", this.getCooldown());
        compound.m_128350_("HappyScale", this.getHappyScale());
        compound.m_128356_("HappyTimeAt", this.getHappyTime());
    }

    public int getProcessTick() {
        return this.processTick;
    }

    public void setProcessTick(int process) {
        this.processTick = process;
    }

    public void setHappyScale(float happyScale) {
        this.happyScale = happyScale;
    }

    public float getHappyScale() {
        return this.happyScale;
    }

    public void setHappyTime(long happyTime) {
        this.happyTime = happyTime;
    }

    public long getHappyTime() {
        return this.happyTime;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(long cooldown) {
        this.cooldown = cooldown;
    }
}

