/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.blockentity.tfenergy.base;

import baguchan.tofucraft.api.tfenergy.IAnntena;
import baguchan.tofucraft.api.tfenergy.ITofuEnergy;
import baguchan.tofucraft.api.tfenergy.TofuNetwork;
import baguchan.tofucraft.api.tfenergy.TofuNetworkChangedEvent;
import baguchan.tofucraft.blockentity.tfenergy.base.EnergyBaseBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SenderBaseBlockEntity
extends EnergyBaseBlockEntity {
    protected List<BlockEntity> cache = new ArrayList<BlockEntity>();
    protected boolean isCached = false;
    protected int findCooldown;
    private Block antenna;

    public SenderBaseBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_, int energyMax) {
        super(p_155228_, p_155229_, p_155230_, energyMax);
    }

    @SubscribeEvent
    public static void onLoaded(TofuNetworkChangedEvent.NetworkLoaded event) {
        List<BlockEntity> tes = TofuNetwork.toTiles(TofuNetwork.Instance.getReference().entrySet().stream().filter(entry -> entry.getValue() instanceof SenderBaseBlockEntity && ((SenderBaseBlockEntity)entry.getValue()).isValid()));
        tes.forEach(te -> ((SenderBaseBlockEntity)te).onCache());
    }

    @SubscribeEvent
    public static void onRemoved(TofuNetworkChangedEvent.NetworkRemoved event) {
        List<BlockEntity> tes = TofuNetwork.toTiles(TofuNetwork.Instance.getReference().entrySet().stream().filter(entry -> entry.getValue() instanceof SenderBaseBlockEntity && ((SenderBaseBlockEntity)entry.getValue()).isValid()));
        tes.forEach(te -> ((SenderBaseBlockEntity)te).onCache());
    }

    public static void senderUpdate(SenderBaseBlockEntity senderBaseBlockEntity) {
        if (!senderBaseBlockEntity.f_58857_.m_5776_() && senderBaseBlockEntity.getEnergyStored() > 0) {
            if (senderBaseBlockEntity.isValid()) {
                if (!senderBaseBlockEntity.cache.isEmpty()) {
                    ArrayList toSend = new ArrayList();
                    senderBaseBlockEntity.cache.forEach(tileEntity -> {
                        if (((EnergyBaseBlockEntity)tileEntity).getEnergyStored() < ((EnergyBaseBlockEntity)tileEntity).getMaxEnergyStored()) {
                            toSend.add(tileEntity);
                        }
                    });
                    if (toSend.size() > 0) {
                        int packSize = Math.max(Math.min(senderBaseBlockEntity.getTransferPower(), senderBaseBlockEntity.getEnergyStored()) / toSend.size(), 1);
                        for (BlockEntity te : toSend) {
                            senderBaseBlockEntity.drain(((ITofuEnergy)te).receive(Math.min(packSize, senderBaseBlockEntity.getEnergyStored()), false), false);
                        }
                    }
                }
                if (--senderBaseBlockEntity.findCooldown <= 0) {
                    senderBaseBlockEntity.onCache();
                }
            } else {
                senderBaseBlockEntity.cache.clear();
            }
        }
    }

    public boolean isValid() {
        if (this.f_58857_.m_46749_(this.m_58899_().m_7494_())) {
            this.antenna = this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_60734_();
        }
        return this.antenna instanceof IAnntena;
    }

    public void onCache() {
        this.cache = TofuNetwork.toTiles(TofuNetwork.Instance.getInsertableWithinRadius(this, ((IAnntena)this.antenna).getRadius(this.m_58899_().m_7494_(), this.f_58857_)));
        this.isCached = true;
        this.findCooldown = 100;
    }

    public int getTransferPower() {
        return this.isValid() ? ((IAnntena)this.f_58857_.m_8055_(this.m_58899_().m_7494_()).m_60734_()).getPower(this.m_58899_().m_7494_(), this.f_58857_) : 0;
    }

    public double getRadius() {
        return ((IAnntena)this.antenna).getRadius(this.m_58899_(), this.f_58857_);
    }

    @Override
    public boolean canDrain(BlockEntity to) {
        return true;
    }

    @Override
    public boolean canReceive(BlockEntity from) {
        return false;
    }
}

