/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.capability;

import baguchan.tofucraft.TofuCraftReload;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class TofuLivingCapability
implements ICapabilityProvider,
ICapabilitySerializable<CompoundTag> {
    private static final UUID MODIFIER_SPEED_BOOST_UUID = UUID.fromString("4c1289d9-c549-14ae-5384-b9ed850b44a1");
    private static final UUID MODIFIER_HORSE_JUMP_BOOST_UUID = UUID.fromString("98f128f6-3043-bb90-2e49-b584f3de02f9");
    public boolean isInTofuPortal = false;
    public int tofuPortalTimer = 0;
    public int tofuPortalCooldown = 200;
    public float prevPortalAnimTime;
    public float portalAnimTime = 0.0f;
    public int saltBoostCooldown = 0;
    public int saltBoost = 0;
    public int wolfEatCooldown;

    public void tick(Entity entity) {
        if (entity.m_9236_().f_46443_) {
            this.prevPortalAnimTime = this.portalAnimTime;
            Minecraft mc = Minecraft.m_91087_();
            if (this.isInTofuPortal) {
                if (mc.f_91080_ != null && !mc.f_91080_.m_7043_()) {
                    if (mc.f_91080_ instanceof ContainerScreen && mc.f_91074_ != null) {
                        mc.f_91074_.m_6915_();
                    }
                    mc.m_91152_(null);
                }
                if (this.portalAnimTime == 0.0f) {
                    this.playPortalSound(mc);
                }
            }
        } else {
            this.handleSaltBoost(entity);
        }
        if (this.tofuPortalCooldown > 0) {
            --this.tofuPortalCooldown;
        }
        if (this.isInTofuPortal) {
            ++this.tofuPortalTimer;
            if (entity.m_9236_().f_46443_) {
                this.portalAnimTime += 0.0125f;
                if (this.portalAnimTime > 1.0f) {
                    this.portalAnimTime = 1.0f;
                }
            }
            this.isInTofuPortal = false;
        } else {
            if (entity.m_9236_().f_46443_) {
                if (this.portalAnimTime > 0.0f) {
                    this.portalAnimTime -= 0.05f;
                }
                if (this.portalAnimTime < 0.0f) {
                    this.portalAnimTime = 0.0f;
                }
            }
            if (this.tofuPortalTimer > 0) {
                this.tofuPortalTimer -= 4;
            }
        }
        this.handleFood(entity);
    }

    private void handleFood(Entity entity) {
        if (this.wolfEatCooldown > 0) {
            --this.wolfEatCooldown;
        }
    }

    public boolean isWolfEatCooldown() {
        return this.wolfEatCooldown > 0;
    }

    public void setWolfEatCooldown(int wolfEatCooldown) {
        this.wolfEatCooldown = wolfEatCooldown;
    }

    private void handleSaltBoost(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.saltBoost == 0) {
                this.removeBoost(livingEntity);
                this.saltBoost = -1;
            } else if (this.saltBoost > 0) {
                --this.saltBoost;
            }
            if (this.saltBoostCooldown > 0) {
                --this.saltBoostCooldown;
            }
        }
    }

    protected void removeBoost(LivingEntity entity) {
        AttributeInstance attributeinstance2;
        AttributeInstance attributeinstance = entity.m_21051_(Attributes.f_22288_);
        if (attributeinstance != null && attributeinstance.m_22111_(MODIFIER_HORSE_JUMP_BOOST_UUID) != null) {
            attributeinstance.m_22120_(MODIFIER_HORSE_JUMP_BOOST_UUID);
        }
        if ((attributeinstance2 = entity.m_21051_(Attributes.f_22279_)) != null && attributeinstance2.m_22111_(MODIFIER_SPEED_BOOST_UUID) != null) {
            attributeinstance2.m_22120_(MODIFIER_SPEED_BOOST_UUID);
        }
    }

    public void tryAddSaltBoost(LivingEntity entity) {
        if (!entity.m_9236_().f_46443_) {
            AttributeInstance attributeinstance = entity.m_21051_(Attributes.f_22279_);
            AttributeInstance attributeinstance2 = entity.m_21051_(Attributes.f_22288_);
            if (attributeinstance == null || attributeinstance2 == null) {
                return;
            }
            attributeinstance.m_22118_(new AttributeModifier(MODIFIER_SPEED_BOOST_UUID, "SaltBoost", 0.025, AttributeModifier.Operation.ADDITION));
            attributeinstance2.m_22118_(new AttributeModifier(MODIFIER_HORSE_JUMP_BOOST_UUID, "SaltBoostJump", 0.125, AttributeModifier.Operation.ADDITION));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playPortalSound(Minecraft mc) {
        if (mc.f_91074_ != null) {
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119766_((SoundEvent)SoundEvents.f_12288_, (float)(mc.f_91074_.m_217043_().m_188501_() * 0.4f + 0.8f), (float)0.25f));
        }
    }

    public void setSaltBoost(int saltBoost, int cooldown, LivingEntity entity) {
        this.saltBoost = saltBoost;
        this.saltBoostCooldown = cooldown;
        this.tryAddSaltBoost(entity);
    }

    public int getSaltBoost() {
        return this.saltBoost;
    }

    public int getSaltBoostCooldown() {
        return this.saltBoostCooldown;
    }

    public boolean isInPortal() {
        return this.isInTofuPortal;
    }

    public void setInPortal(boolean inPortal) {
        this.isInTofuPortal = inPortal;
    }

    public void setPortalTimer(int timer) {
        this.tofuPortalTimer = timer;
    }

    public int getPortalTimer() {
        return this.tofuPortalTimer;
    }

    public float getPortalAnimTime() {
        return this.portalAnimTime;
    }

    public float getPrevPortalAnimTime() {
        return this.prevPortalAnimTime;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == TofuCraftReload.TOFU_LIVING_CAPABILITY ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("SaltBoost", this.saltBoost);
        nbt.m_128405_("SaltBoostCooldown", this.saltBoostCooldown);
        if (this.wolfEatCooldown > 0) {
            nbt.m_128405_("wolf_eat_cooldown", this.wolfEatCooldown);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.saltBoost = nbt.m_128451_("SaltBoost");
        this.saltBoostCooldown = nbt.m_128451_("SaltBoostCooldown");
        if (nbt.m_128441_("wolf_eat_cooldown")) {
            this.wolfEatCooldown = nbt.m_128451_("wolf_eat_cooldown");
        }
    }
}

