/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.client.particle;

import baguchan.tofucraft.client.render.TofuCraftRenderType;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleStink
extends TextureSheetParticle {
    private final float scale;
    private final EnumStinkBehavior behavior;
    private final float shake;

    public ParticleStink(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, double scale, int duration, EnumStinkBehavior behavior, double shake) {
        super(level, x, y, z);
        this.scale = (float)scale * 0.8f * 0.1f;
        this.f_107225_ = duration;
        this.f_107215_ = vx * 0.8;
        this.f_107216_ = vy * 0.8;
        this.f_107217_ = vz * 0.8;
        this.behavior = behavior;
        this.f_107231_ = this.f_107204_ = (float)((double)this.f_107223_.m_188503_(4) * Math.PI / 2.0);
        this.shake = (float)shake;
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float tick) {
        float time = ((float)this.f_107224_ + tick) / (float)this.f_107225_;
        this.f_107230_ = 0.5f * (float)(1.0 - Math.exp(4.0f * (time - 1.0f)) - Math.pow(1500.0, -time));
        if ((double)this.f_107230_ <= 0.1) {
            this.f_107230_ = 0.1f;
        }
        this.f_107663_ = this.behavior == EnumStinkBehavior.GROW ? this.scale * (0.7f * time + 0.3f) : this.scale;
        super.m_5744_(consumer, camera, tick);
    }

    public ParticleRenderType m_7556_() {
        return TofuCraftRenderType.NO_TRANSLUCENT_DEPTH;
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107215_ *= (double)this.shake;
        this.f_107216_ *= (double)this.shake;
        this.f_107217_ *= (double)this.shake;
    }

    public static enum EnumStinkBehavior {
        GROW;

    }

    public static class StinkData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<StinkData> DESERIALIZER = new ParticleOptions.Deserializer<StinkData>(){

            public StinkData fromCommand(ParticleType<StinkData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float scale = (float)reader.readDouble();
                reader.expect(' ');
                int duration = reader.readInt();
                reader.expect(' ');
                float shake = (float)reader.readDouble();
                return new StinkData(particleTypeIn, scale, duration, EnumStinkBehavior.GROW, shake);
            }

            public StinkData fromNetwork(ParticleType<StinkData> type, FriendlyByteBuf buff) {
                return new StinkData(type, buff.readFloat(), buff.readInt(), EnumStinkBehavior.GROW, buff.readFloat());
            }
        };
        private final ParticleType<StinkData> type;
        private final float scale;
        private final int duration;
        private final EnumStinkBehavior behavior;
        private final float shake;

        public StinkData(ParticleType<StinkData> type, float scale, int duration, EnumStinkBehavior behavior, float shake) {
            this.type = type;
            this.scale = scale;
            this.behavior = behavior;
            this.shake = shake;
            this.duration = duration;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.scale);
            buffer.writeInt(this.duration);
            buffer.writeFloat(this.shake);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "Stink", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.scale), this.duration, Float.valueOf(this.shake));
        }

        public ParticleType<StinkData> m_6012_() {
            return this.type;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getScale() {
            return this.scale;
        }

        @OnlyIn(value=Dist.CLIENT)
        public EnumStinkBehavior getBehavior() {
            return this.behavior;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getDuration() {
            return this.duration;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getShake() {
            return this.shake;
        }

        public static Codec<StinkData> CODEC(ParticleType<StinkData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("scale").forGetter(StinkData::getScale), (App)Codec.STRING.fieldOf("behavior").forGetter(StinkData2 -> StinkData2.getBehavior().toString()), (App)Codec.INT.fieldOf("duration").forGetter(StinkData::getDuration), (App)Codec.FLOAT.fieldOf("airdrag").forGetter(StinkData::getShake)).apply((Applicative)codecBuilder, (scale, behavior, duration, shake) -> new StinkData(particleType, scale.floatValue(), (int)duration, EnumStinkBehavior.valueOf(behavior), shake.floatValue())));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class StinkFactory
    implements ParticleProvider<StinkData> {
        private final SpriteSet sprite;

        public StinkFactory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(StinkData type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleStink particleCloud = new ParticleStink(level, x, y, z, xSpeed, ySpeed, zSpeed, type.getScale(), type.getDuration(), type.getBehavior(), type.getShake());
            particleCloud.m_108339_(this.sprite);
            return particleCloud;
        }
    }
}

