/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.client.render.entity;

import baguchan.tofucraft.entity.projectile.SoyballEntity;
import baguchan.tofucraft.registry.TofuFluids;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class SoyballRenderer
extends EntityRenderer<SoyballEntity> {
    public SoyballRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public void render(SoyballEntity p_114485_, float p_114486_, float p_114487_, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        super.m_7392_((Entity)p_114485_, p_114486_, p_114487_, poseStack, bufferSource, light);
        poseStack.m_85836_();
        SoyballRenderer.renderFluid(poseStack, bufferSource, light);
        poseStack.m_85849_();
    }

    private static void renderFluid(PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110466_());
        SoyballRenderer.renderOrb(poseStack, consumer, light);
    }

    private static void renderOrb(PoseStack poseStack, VertexConsumer consumer, int light) {
        float orbSize = 0.3f;
        float rotationOffset = 0.0f;
        float waveOffset = 0.0f;
        float topY = orbSize * (float)Math.sqrt(1.5) / 2.0f;
        float sideX = (float)((double)orbSize * Math.sqrt(0.3333333432674408));
        float sideY = topY / 3.0f;
        float offsetY = orbSize * 0.5f;
        for (int i = 0; i < 3; ++i) {
            Vector3f[] vertPos0 = new Vector3f[]{new Vector3f(0.0f, topY + offsetY + SoyballRenderer.cos(waveOffset + 25.0f, orbSize * 0.03f), 0.0f), new Vector3f(SoyballRenderer.cos((float)(60 + i * 120) + rotationOffset, sideX), sideY + offsetY + SoyballRenderer.cos(waveOffset, orbSize * 0.03f), SoyballRenderer.sin((float)(60 + i * 120) + rotationOffset, sideX)), new Vector3f(SoyballRenderer.cos((float)(i * 120) + rotationOffset, sideX), -sideY + offsetY + SoyballRenderer.cos(waveOffset - 25.0f, orbSize * 0.03f), SoyballRenderer.sin((float)(i * 120) + rotationOffset, sideX)), new Vector3f(SoyballRenderer.cos((float)(-60 + i * 120) + rotationOffset, sideX), sideY + offsetY + SoyballRenderer.cos(waveOffset, orbSize * 0.03f), SoyballRenderer.sin((float)(-60 + i * 120) + rotationOffset, sideX))};
            Vector2f[] vertUV0 = new Vector2f[]{new Vector2f(8.0f - orbSize * 4.0f, 8.0f), new Vector2f(8.0f, 8.0f + orbSize * 4.0f), new Vector2f(8.0f + orbSize * 4.0f, 8.0f), new Vector2f(8.0f, 8.0f - orbSize * 4.0f)};
            SoyballRenderer.renderQuads(vertPos0, vertUV0, poseStack, consumer, light);
            Vector3f[] vertPos1 = new Vector3f[]{new Vector3f(SoyballRenderer.cos((float)(60 + i * 120) + rotationOffset, sideX), sideY + offsetY + SoyballRenderer.cos(waveOffset, orbSize * 0.03f), SoyballRenderer.sin((float)(60 + i * 120) + rotationOffset, sideX)), new Vector3f(SoyballRenderer.cos((float)(120 + i * 120) + rotationOffset, sideX), -sideY + offsetY + SoyballRenderer.cos(waveOffset - 25.0f, orbSize * 0.03f), SoyballRenderer.sin((float)(120 + i * 120) + rotationOffset, sideX)), new Vector3f(0.0f, -topY + offsetY + SoyballRenderer.cos(waveOffset - 50.0f, orbSize * 0.03f), 0.0f), new Vector3f(SoyballRenderer.cos((float)(i * 120) + rotationOffset, sideX), -sideY + offsetY + SoyballRenderer.cos(waveOffset - 25.0f, orbSize * 0.03f), SoyballRenderer.sin((float)(i * 120) + rotationOffset, sideX))};
            Vector2f[] vertUV1 = new Vector2f[]{new Vector2f(8.0f - orbSize * 4.0f, 8.0f), new Vector2f(8.0f, 8.0f + orbSize * 4.0f), new Vector2f(8.0f + orbSize * 4.0f, 8.0f), new Vector2f(8.0f, 8.0f - orbSize * 4.0f)};
            SoyballRenderer.renderQuads(vertPos1, vertUV1, poseStack, consumer, light);
        }
    }

    private static void renderQuads(Vector3f[] vertexPos, Vector2f[] vertexUV, PoseStack poseStack, VertexConsumer consumer, int light) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        VertexConsumer buffer = consumer;
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)((Fluid)TofuFluids.SOYMILK.get()));
        TextureAtlasSprite sprite = SoyballRenderer.getFluidSprite(fluidTypeExtensions, new FluidStack((Fluid)TofuFluids.SOYMILK.get(), 1000));
        Vec3 offset = new Vec3(-0.5, -0.5, -0.5);
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        for (int i = 0; i < 4; ++i) {
            buffer.m_252986_(matrix, 0.5f + vertexPos[i].x + (float)offset.f_82479_, 0.5f + vertexPos[i].y + (float)offset.f_82480_, 0.5f + vertexPos[i].z + (float)offset.f_82481_).m_85950_(red, green, blue, 1.0f).m_7421_(sprite.m_118367_((double)vertexUV[i].x), sprite.m_118393_((double)vertexUV[i].y)).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
    }

    private static int calcLight(int combinedLight, FluidStack fluidStack) {
        int skyLight = combinedLight >> 20 & 0xF;
        int blockLight = combinedLight >> 4 & 0xF;
        int fluidLight = fluidStack.getFluid().getFluidType().getLightLevel();
        int maxBlockLight = Math.max(blockLight, fluidLight);
        return skyLight << 20 | maxBlockLight << 4;
    }

    private static float sin(float waveOffset, float amplitude) {
        return amplitude * Mth.m_14031_((float)((float)Math.toRadians(waveOffset)));
    }

    private static float cos(float waveOffset, float amplitude) {
        return amplitude * Mth.m_14089_((float)((float)Math.toRadians(waveOffset)));
    }

    private static TextureAtlasSprite getFluidSprite(IClientFluidTypeExtensions fluidTypeExtensions, FluidStack fluidStack) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidTypeExtensions.getFlowingTexture(fluidStack));
    }

    public ResourceLocation getTextureLocation(SoyballEntity p_114482_) {
        return null;
    }
}

