/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.compat.jei;

import baguchan.tofucraft.compat.jei.JEIPlugin;
import baguchan.tofucraft.recipe.BitternRecipe;
import baguchan.tofucraft.recipe.FluidIngredient;
import baguchan.tofucraft.registry.TofuItems;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BitternCategory
implements IRecipeCategory<BitternRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("tofucraft", "bittern");
    protected final IDrawableAnimated arrow;
    private final Component title = Component.m_237115_((String)"tofucraft.jei.bittern");
    private final IDrawable background;
    private final IDrawable icon;

    public BitternCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("tofucraft", "textures/gui/general_jei_recipe.png");
        this.background = helper.createDrawable(backgroundImage, 16, 16, 144, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)TofuItems.BITTERN_BOTTLE.get()));
        this.arrow = helper.drawableBuilder(backgroundImage, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getRegistryName(BitternRecipe recipe) {
        return UID;
    }

    public RecipeType<BitternRecipe> getRecipeType() {
        return JEIPlugin.BITTERN_JEI_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BitternRecipe recipe, IFocusGroup focuses) {
        FluidIngredient recipeIngredients = recipe.getFluid();
        int borderSlotSize = 18;
        builder.addSlot(RecipeIngredientRole.INPUT, 38, 18).setFluidRenderer(1000L, false, 16, 16).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, Arrays.stream(recipeIngredients.getFluids()).toList());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 18).addItemStack(recipe.getResult());
    }

    public void draw(BitternRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.arrow.draw(stack, 55, 18);
    }
}

