/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.data;

import baguchan.tofucraft.data.BlockTagGenerator;
import baguchan.tofucraft.data.BlockstateGenerator;
import baguchan.tofucraft.data.CustomTagGenerator;
import baguchan.tofucraft.data.EntityTagGenerator;
import baguchan.tofucraft.data.FluidTagGenerator;
import baguchan.tofucraft.data.ItemModelGenerator;
import baguchan.tofucraft.data.ItemTagGenerator;
import baguchan.tofucraft.data.RegistryDataGenerator;
import baguchan.tofucraft.data.TofuLootTableProvider;
import baguchan.tofucraft.data.recipe.CraftingGenerator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tofucraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        DataGenerators.addArmorTrims(existingFileHelper);
        event.getGenerator().addProvider(event.includeClient(), (DataProvider)new BlockstateGenerator(packOutput, event.getExistingFileHelper()));
        event.getGenerator().addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new CustomTagGenerator.BannerPatternTagGenerator(packOutput, lookupProvider, existingFileHelper));
        BlockTagGenerator blocktags = new BlockTagGenerator(packOutput, lookupProvider, event.getExistingFileHelper());
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)blocktags);
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new ItemTagGenerator(packOutput, lookupProvider, blocktags.m_274426_(), event.getExistingFileHelper()));
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new EntityTagGenerator(packOutput, lookupProvider, event.getExistingFileHelper()));
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new FluidTagGenerator(packOutput, lookupProvider, event.getExistingFileHelper()));
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)TofuLootTableProvider.create(packOutput));
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new CraftingGenerator(packOutput));
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new RegistryDataGenerator(packOutput, lookupProvider));
    }

    private static void addArmorTrims(ExistingFileHelper existingFileHelper) {
        for (ItemModelGenerators.TrimModelData trim : ItemModelGenerators.f_265952_) {
            existingFileHelper.trackGenerated(new ResourceLocation("boots_trim_" + trim.f_265890_()), PackType.CLIENT_RESOURCES, ".png", "textures/trims/items");
            existingFileHelper.trackGenerated(new ResourceLocation("chestplate_trim_" + trim.f_265890_()), PackType.CLIENT_RESOURCES, ".png", "textures/trims/items");
            existingFileHelper.trackGenerated(new ResourceLocation("helmet_trim_" + trim.f_265890_()), PackType.CLIENT_RESOURCES, ".png", "textures/trims/items");
            existingFileHelper.trackGenerated(new ResourceLocation("leggings_trim_" + trim.f_265890_()), PackType.CLIENT_RESOURCES, ".png", "textures/trims/items");
        }
    }
}

