/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.data.resources;

import net.minecraft.util.CubicSpline;
import net.minecraft.util.Mth;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public class TofuTerrainProvider {
    private static final float DEEP_OCEAN_CONTINENTALNESS = -0.51f;
    private static final float OCEAN_CONTINENTALNESS = -0.4f;
    private static final float PLAINS_CONTINENTALNESS = 0.1f;
    private static final float BEACH_CONTINENTALNESS = -0.15f;
    private static final ToFloatFunction<Float> NO_TRANSFORM = ToFloatFunction.f_216471_;
    private static final ToFloatFunction<Float> AMPLIFIED_OFFSET = ToFloatFunction.m_216475_(p_236651_ -> p_236651_ < 0.0f ? p_236651_ : p_236651_ * 2.0f);
    private static final ToFloatFunction<Float> AMPLIFIED_FACTOR = ToFloatFunction.m_216475_(p_236649_ -> 1.25f - 6.25f / (p_236649_ + 5.0f));
    private static final ToFloatFunction<Float> AMPLIFIED_JAGGEDNESS = ToFloatFunction.m_216475_(p_236641_ -> p_236641_ * 2.0f);

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> overworldOffset(I p_236636_, I p_236637_, I p_236638_, boolean p_236639_) {
        ToFloatFunction<Float> tofloatfunction = p_236639_ ? AMPLIFIED_OFFSET : NO_TRANSFORM;
        CubicSpline<C, I> cubicspline = TofuTerrainProvider.buildErosionOffsetSpline(p_236637_, p_236638_, -0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, tofloatfunction);
        CubicSpline<C, I> cubicspline1 = TofuTerrainProvider.buildErosionOffsetSpline(p_236637_, p_236638_, -0.1f, 0.03f, 0.1f, 0.1f, 0.01f, -0.03f, false, false, tofloatfunction);
        CubicSpline<C, I> cubicspline2 = TofuTerrainProvider.buildErosionOffsetSpline(p_236637_, p_236638_, -0.1f, 0.03f, 0.1f, 0.7f, 0.01f, -0.03f, true, true, tofloatfunction);
        CubicSpline<C, I> cubicspline3 = TofuTerrainProvider.buildErosionOffsetSpline(p_236637_, p_236638_, -0.05f, 0.03f, 0.1f, 1.0f, 0.01f, 0.01f, true, true, tofloatfunction);
        return CubicSpline.m_184254_(p_236636_, tofloatfunction).m_216114_(-1.1f, 0.044f).m_216114_(-1.02f, -0.2222f).m_216114_(-0.51f, -0.2222f).m_216114_(-0.44f, -0.12f).m_216114_(-0.18f, -0.12f).m_216117_(-0.16f, cubicspline).m_216117_(-0.15f, cubicspline).m_216117_(-0.1f, cubicspline1).m_216117_(0.25f, cubicspline2).m_216117_(1.0f, cubicspline3).m_184297_();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> overworldFactor(I p_236630_, I p_236631_, I p_236632_, I p_236633_, boolean p_236634_) {
        ToFloatFunction<Float> tofloatfunction = p_236634_ ? AMPLIFIED_FACTOR : NO_TRANSFORM;
        return CubicSpline.m_184254_(p_236630_, NO_TRANSFORM).m_216114_(-0.19f, 3.95f).m_216117_(-0.15f, TofuTerrainProvider.getErosionFactor(p_236631_, p_236632_, p_236633_, 6.25f, true, NO_TRANSFORM)).m_216117_(-0.1f, TofuTerrainProvider.getErosionFactor(p_236631_, p_236632_, p_236633_, 5.47f, true, tofloatfunction)).m_216117_(0.03f, TofuTerrainProvider.getErosionFactor(p_236631_, p_236632_, p_236633_, 5.08f, true, tofloatfunction)).m_216117_(0.06f, TofuTerrainProvider.getErosionFactor(p_236631_, p_236632_, p_236633_, 4.69f, false, tofloatfunction)).m_184297_();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> overworldJaggedness(I p_236643_, I p_236644_, I p_236645_, I p_236646_, boolean p_236647_) {
        ToFloatFunction<Float> tofloatfunction = p_236647_ ? AMPLIFIED_JAGGEDNESS : NO_TRANSFORM;
        float f = 0.65f;
        return CubicSpline.m_184254_(p_236643_, tofloatfunction).m_216114_(-0.11f, 0.0f).m_216117_(0.03f, TofuTerrainProvider.buildErosionJaggednessSpline(p_236644_, p_236645_, p_236646_, 1.0f, 0.5f, 0.0f, 0.0f, tofloatfunction)).m_216117_(0.65f, TofuTerrainProvider.buildErosionJaggednessSpline(p_236644_, p_236645_, p_236646_, 1.0f, 1.0f, 1.0f, 0.0f, tofloatfunction)).m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildErosionJaggednessSpline(I p_236614_, I p_236615_, I p_236616_, float p_236617_, float p_236618_, float p_236619_, float p_236620_, ToFloatFunction<Float> p_236621_) {
        float f = -0.5775f;
        CubicSpline<C, I> cubicspline = TofuTerrainProvider.buildRidgeJaggednessSpline(p_236615_, p_236616_, p_236617_, p_236619_, p_236621_);
        CubicSpline<C, I> cubicspline1 = TofuTerrainProvider.buildRidgeJaggednessSpline(p_236615_, p_236616_, p_236618_, p_236620_, p_236621_);
        return CubicSpline.m_184254_(p_236614_, p_236621_).m_216117_(-1.0f, cubicspline).m_216117_(-0.78f, cubicspline1).m_216117_(-0.5775f, cubicspline1).m_216114_(-0.375f, 0.0f).m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildRidgeJaggednessSpline(I p_236608_, I p_236609_, float p_236610_, float p_236611_, ToFloatFunction<Float> p_236612_) {
        float f = NoiseRouterData.m_224435_((float)0.4f);
        float f1 = NoiseRouterData.m_224435_((float)0.56666666f);
        float f2 = (f + f1) / 2.0f;
        CubicSpline.Builder builder = CubicSpline.m_184254_(p_236609_, p_236612_);
        builder.m_216114_(f, 0.0f);
        if (p_236611_ > 0.0f) {
            builder.m_216117_(f2, TofuTerrainProvider.buildWeirdnessJaggednessSpline(p_236608_, p_236611_, p_236612_));
        } else {
            builder.m_216114_(f2, 0.0f);
        }
        if (p_236610_ > 0.0f) {
            builder.m_216117_(1.0f, TofuTerrainProvider.buildWeirdnessJaggednessSpline(p_236608_, p_236610_, p_236612_));
        } else {
            builder.m_216114_(1.0f, 0.0f);
        }
        return builder.m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildWeirdnessJaggednessSpline(I p_236587_, float p_236588_, ToFloatFunction<Float> p_236589_) {
        float f = 0.63f * p_236588_;
        float f1 = 0.3f * p_236588_;
        return CubicSpline.m_184254_(p_236587_, p_236589_).m_216114_(-0.01f, f).m_216114_(0.01f, f1).m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> getErosionFactor(I p_236623_, I p_236624_, I p_236625_, float p_236626_, boolean p_236627_, ToFloatFunction<Float> p_236628_) {
        CubicSpline cubicspline = CubicSpline.m_184254_(p_236624_, p_236628_).m_216114_(-0.2f, 6.3f).m_216114_(0.2f, p_236626_).m_184297_();
        CubicSpline.Builder builder = CubicSpline.m_184254_(p_236623_, p_236628_).m_216117_(-0.6f, cubicspline).m_216117_(-0.5f, CubicSpline.m_184254_(p_236624_, p_236628_).m_216114_(-0.05f, 6.3f).m_216114_(0.05f, 2.67f).m_184297_()).m_216117_(-0.35f, cubicspline).m_216117_(-0.25f, cubicspline).m_216117_(-0.1f, CubicSpline.m_184254_(p_236624_, p_236628_).m_216114_(-0.05f, 2.67f).m_216114_(0.05f, 6.3f).m_184297_()).m_216117_(0.03f, cubicspline);
        if (p_236627_) {
            CubicSpline cubicspline1 = CubicSpline.m_184254_(p_236624_, p_236628_).m_216114_(0.0f, p_236626_).m_216114_(0.1f, 0.625f).m_184297_();
            CubicSpline cubicspline2 = CubicSpline.m_184254_(p_236625_, p_236628_).m_216114_(-0.9f, p_236626_).m_216117_(-0.69f, cubicspline1).m_184297_();
            builder.m_216114_(0.35f, p_236626_).m_216117_(0.45f, cubicspline2).m_216117_(0.55f, cubicspline2).m_216114_(0.62f, p_236626_);
        } else {
            CubicSpline cubicspline1 = CubicSpline.m_184254_(p_236625_, p_236628_).m_216117_(-0.7f, cubicspline).m_216114_(-0.15f, 1.37f).m_184297_();
            CubicSpline cubicspline2 = CubicSpline.m_184254_(p_236625_, p_236628_).m_216117_(0.45f, cubicspline).m_216114_(0.7f, 1.56f).m_184297_();
            builder.m_216117_(0.05f, cubicspline2).m_216117_(0.4f, cubicspline2).m_216117_(0.45f, cubicspline1).m_216117_(0.55f, cubicspline1).m_216114_(0.58f, p_236626_);
        }
        return builder.m_184297_();
    }

    private static float calculateSlope(float p_236573_, float p_236574_, float p_236575_, float p_236576_) {
        return (p_236574_ - p_236573_) / (p_236576_ - p_236575_);
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildMountainRidgeSplineWithPoints(I p_236591_, float p_236592_, boolean p_236593_, ToFloatFunction<Float> p_236594_) {
        CubicSpline.Builder builder = CubicSpline.m_184254_(p_236591_, p_236594_);
        float f = -0.7f;
        float f1 = -1.0f;
        float f2 = TofuTerrainProvider.mountainContinentalness(-1.0f, p_236592_, -0.7f);
        float f3 = 1.0f;
        float f4 = TofuTerrainProvider.mountainContinentalness(1.0f, p_236592_, -0.7f);
        float f5 = TofuTerrainProvider.calculateMountainRidgeZeroContinentalnessPoint(p_236592_);
        float f6 = -0.65f;
        if (-0.65f < f5 && f5 < 1.0f) {
            float f7 = TofuTerrainProvider.mountainContinentalness(-0.65f, p_236592_, -0.7f);
            float f8 = -0.75f;
            float f9 = TofuTerrainProvider.mountainContinentalness(-0.75f, p_236592_, -0.7f);
            float f10 = TofuTerrainProvider.calculateSlope(f2, f9, -1.0f, -0.75f);
            builder.m_184298_(-1.0f, f2, f10);
            builder.m_216114_(-0.75f, f9);
            builder.m_216114_(-0.65f, f7);
            float f11 = TofuTerrainProvider.mountainContinentalness(f5, p_236592_, -0.7f);
            float f12 = TofuTerrainProvider.calculateSlope(f11, f4, f5, 1.0f);
            float f13 = 0.01f;
            builder.m_216114_(f5 - 0.01f, f11);
            builder.m_184298_(f5, f11, f12);
            builder.m_184298_(1.0f, f4, f12);
        } else {
            float f7 = TofuTerrainProvider.calculateSlope(f2, f4, -1.0f, 1.0f);
            if (p_236593_) {
                builder.m_216114_(-1.0f, Math.max(0.2f, f2));
                builder.m_184298_(0.0f, Mth.m_14179_((float)0.5f, (float)f2, (float)f4), f7);
            } else {
                builder.m_184298_(-1.0f, f2, f7);
            }
            builder.m_184298_(1.0f, f4, f7);
        }
        return builder.m_184297_();
    }

    private static float mountainContinentalness(float p_236569_, float p_236570_, float p_236571_) {
        float f = 1.17f;
        float f1 = 0.46082947f;
        float f2 = 1.0f - (1.0f - p_236570_) * 0.5f;
        float f3 = 0.5f * (1.0f - p_236570_);
        float f4 = (p_236569_ + 1.17f) * 0.46082947f;
        float f5 = f4 * f2 - f3;
        return p_236569_ < p_236571_ ? Math.max(f5, -0.2222f) : Math.max(f5, 0.0f);
    }

    private static float calculateMountainRidgeZeroContinentalnessPoint(float p_236567_) {
        float f = 1.17f;
        float f1 = 0.46082947f;
        float f2 = 1.0f - (1.0f - p_236567_) * 0.5f;
        float f3 = 0.5f * (1.0f - p_236567_);
        return f3 / (0.46082947f * f2) - 1.17f;
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildErosionOffsetSpline(I p_236596_, I p_236597_, float p_236598_, float p_236599_, float p_236600_, float p_236601_, float p_236602_, float p_236603_, boolean p_236604_, boolean p_236605_, ToFloatFunction<Float> p_236606_) {
        float f = 0.6f;
        float f1 = 0.5f;
        float f2 = 0.5f;
        CubicSpline<C, I> cubicspline = TofuTerrainProvider.buildMountainRidgeSplineWithPoints(p_236597_, Mth.m_14179_((float)p_236601_, (float)0.6f, (float)1.5f), p_236605_, p_236606_);
        CubicSpline<C, I> cubicspline1 = TofuTerrainProvider.buildMountainRidgeSplineWithPoints(p_236597_, Mth.m_14179_((float)p_236601_, (float)0.6f, (float)1.0f), p_236605_, p_236606_);
        CubicSpline<C, I> cubicspline2 = TofuTerrainProvider.buildMountainRidgeSplineWithPoints(p_236597_, p_236601_, p_236605_, p_236606_);
        CubicSpline<C, I> cubicspline3 = TofuTerrainProvider.ridgeSpline(p_236597_, p_236598_ - 0.15f, 0.5f * p_236601_, Mth.m_14179_((float)0.5f, (float)0.5f, (float)0.5f) * p_236601_, 0.5f * p_236601_, 0.6f * p_236601_, 0.5f, p_236606_);
        CubicSpline<C, I> cubicspline4 = TofuTerrainProvider.ridgeSpline(p_236597_, p_236598_, p_236602_ * p_236601_, p_236599_ * p_236601_, 0.5f * p_236601_, 0.6f * p_236601_, 0.5f, p_236606_);
        CubicSpline<C, I> cubicspline5 = TofuTerrainProvider.ridgeSpline(p_236597_, p_236598_, p_236602_, p_236602_, p_236599_, p_236600_, 0.5f, p_236606_);
        CubicSpline<C, I> cubicspline6 = TofuTerrainProvider.ridgeSpline(p_236597_, p_236598_, p_236602_, p_236602_, p_236599_, p_236600_, 0.5f, p_236606_);
        CubicSpline cubicspline7 = CubicSpline.m_184254_(p_236597_, p_236606_).m_216114_(-1.0f, p_236598_).m_216117_(-0.4f, cubicspline5).m_216114_(0.0f, p_236600_ + 0.07f).m_184297_();
        CubicSpline<C, I> cubicspline8 = TofuTerrainProvider.ridgeSpline(p_236597_, -0.02f, p_236603_, p_236603_, p_236599_, p_236600_, 0.0f, p_236606_);
        CubicSpline.Builder builder = CubicSpline.m_184254_(p_236596_, p_236606_).m_216117_(-0.85f, cubicspline).m_216117_(-0.7f, cubicspline1).m_216117_(-0.4f, cubicspline2).m_216117_(-0.35f, cubicspline3).m_216117_(-0.1f, cubicspline4).m_216117_(0.2f, cubicspline5);
        if (p_236604_) {
            builder.m_216117_(0.4f, cubicspline6).m_216117_(0.45f, cubicspline7).m_216117_(0.55f, cubicspline7).m_216117_(0.58f, cubicspline6);
        }
        builder.m_216117_(0.7f, cubicspline8);
        return builder.m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> ridgeSpline(I p_236578_, float p_236579_, float p_236580_, float p_236581_, float p_236582_, float p_236583_, float p_236584_, ToFloatFunction<Float> p_236585_) {
        float f = Math.max(0.5f * (p_236580_ - p_236579_), p_236584_);
        float f1 = 5.0f * (p_236581_ - p_236580_);
        return CubicSpline.m_184254_(p_236578_, p_236585_).m_184298_(-1.0f, p_236579_, f).m_184298_(-0.4f, p_236580_, Math.min(f, f1)).m_184298_(0.0f, p_236581_, f1).m_184298_(0.4f, p_236582_, 2.0f * (p_236582_ - p_236581_)).m_184298_(1.0f, p_236583_, 0.7f * (p_236583_ - p_236582_)).m_184297_();
    }
}

