/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity;

import baguchan.tofucraft.entity.AbstractTofunian;
import baguchan.tofucraft.entity.control.StafeableFlyingMoveControl;
import baguchan.tofucraft.entity.goal.ChargeGoal;
import baguchan.tofucraft.entity.goal.SpinAttackGoal;
import baguchan.tofucraft.entity.projectile.FukumameEntity;
import baguchan.tofucraft.registry.TofuParticleTypes;
import baguchan.tofucraft.registry.TofuStructures;
import baguchan.tofucraft.world.TofuData;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class TofuGandlem
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_ID_SHOOT = SynchedEntityData.m_135353_(TofuGandlem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_RUSH = SynchedEntityData.m_135353_(TofuGandlem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_SLEEP = SynchedEntityData.m_135353_(TofuGandlem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> DATA_CHARGE_FLAGS_ID = SynchedEntityData.m_135353_(TofuGandlem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Float> DATA_CHARGE_HEALTH = SynchedEntityData.m_135353_(TofuGandlem.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Nullable
    private BlockPos homePos;
    private static final UniformInt RUSH_COOLDOWN = UniformInt.m_146622_((int)200, (int)400);
    private static final UniformInt CHARGE_COOLDOWN = UniformInt.m_146622_((int)100, (int)300);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState shootAnimationState = new AnimationState();
    public final AnimationState shootingAnimationState = new AnimationState();
    public final AnimationState rushAnimationState = new AnimationState();
    public final AnimationState deathAnimationState = new AnimationState();
    public final AnimationState chargeAnimationState = new AnimationState();
    public final AnimationState chargeStopAnimationState = new AnimationState();
    public final AnimationState chargeFailAnimationState = new AnimationState();
    public int failTick;

    public TofuGandlem(EntityType<? extends TofuGandlem> p_27508_, Level p_27509_) {
        super(p_27508_, p_27509_);
        this.f_21342_ = new StafeableFlyingMoveControl((Mob)this, 20, false);
        this.f_21364_ = 60;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_SHOOT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_RUSH, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_SLEEP, (Object)false);
        this.f_19804_.m_135372_(DATA_CHARGE_HEALTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_CHARGE_FLAGS_ID, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (DATA_CHARGE_FLAGS_ID.equals(p_21104_)) {
            if (this.isCharging()) {
                this.chargeAnimationState.m_216977_(this.f_19797_);
                this.chargeStopAnimationState.m_216973_();
            }
            if (this.isFullCharge()) {
                this.chargeStopAnimationState.m_216977_(this.f_19797_);
                this.chargeAnimationState.m_216973_();
            }
            if (this.isChargeFailed()) {
                this.chargeFailAnimationState.m_216977_(this.f_19797_);
                this.chargeAnimationState.m_216973_();
                this.rushAnimationState.m_216973_();
            }
        }
        if (DATA_ID_RUSH.equals(p_21104_)) {
            this.m_6210_();
        }
        super.m_7350_(p_21104_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new DoNothingGoal());
        this.f_21345_.m_25352_(3, (Goal)new ChargeGoal(this, CHARGE_COOLDOWN));
        this.f_21345_.m_25352_(4, (Goal)new SpinAttackGoal(this, RUSH_COOLDOWN));
        this.f_21345_.m_25352_(5, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractTofunian.class, true));
    }

    protected PathNavigation m_6037_(Level p_218342_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_218342_);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public boolean isShoot() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_SHOOT);
    }

    public void setShoot(boolean shoot) {
        this.f_19804_.m_135381_(DATA_ID_SHOOT, (Object)shoot);
    }

    public boolean hasChargeHealth() {
        return ((Float)this.f_19804_.m_135370_(DATA_CHARGE_HEALTH)).floatValue() > 0.0f;
    }

    public float getChargeHealth() {
        return ((Float)this.f_19804_.m_135370_(DATA_CHARGE_HEALTH)).floatValue();
    }

    public void setChargeHealth(float chargeHealth) {
        this.f_19804_.m_135381_(DATA_CHARGE_HEALTH, (Object)Float.valueOf(chargeHealth));
    }

    public boolean isRush() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_RUSH);
    }

    public void setRush(boolean rush) {
        this.f_19804_.m_135381_(DATA_ID_RUSH, (Object)rush);
    }

    public boolean isSleep() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_SLEEP);
    }

    public void setSleep(boolean rush) {
        this.f_19804_.m_135381_(DATA_ID_SLEEP, (Object)rush);
    }

    private void setChargeFlag(int p_28533_, boolean p_28534_) {
        if (p_28534_) {
            this.f_19804_.m_135381_(DATA_CHARGE_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_CHARGE_FLAGS_ID) | p_28533_)));
        } else {
            this.f_19804_.m_135381_(DATA_CHARGE_FLAGS_ID, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_CHARGE_FLAGS_ID) & ~p_28533_)));
        }
    }

    private boolean getChargeFlag(int p_28609_) {
        return ((Byte)this.f_19804_.m_135370_(DATA_CHARGE_FLAGS_ID) & p_28609_) != 0;
    }

    public boolean isFullCharge() {
        return this.getChargeFlag(16);
    }

    public void setFullCharge(boolean fullcharge) {
        this.setChargeFlag(16, fullcharge);
        if (fullcharge) {
            this.setChargeHealth(40.0f);
        }
    }

    public void setCharging(boolean p_28615_) {
        this.setChargeFlag(4, p_28615_);
    }

    public boolean isCharging() {
        return this.getChargeFlag(4);
    }

    public void setChargeFailed(boolean p_28617_) {
        this.setChargeFlag(8, p_28617_);
    }

    public boolean isChargeFailed() {
        return this.getChargeFlag(8);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sleep", this.isSleep());
        compound.m_128379_("FullCharge", this.isFullCharge());
        if (this.homePos != null) {
            compound.m_128365_("HomePos", (Tag)NbtUtils.m_129224_((BlockPos)this.homePos));
        } else if (this.m_21532_()) {
            compound.m_128365_("HomePos", (Tag)NbtUtils.m_129224_((BlockPos)this.m_20183_()));
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSleep(compound.m_128471_("Sleep"));
        this.setFullCharge(compound.m_128471_("FullCharge"));
        if (compound.m_128441_("HomePos")) {
            this.homePos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("HomePos"));
        }
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }

    public int m_8100_() {
        return 120;
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            if (this.m_6084_() && !this.isSleep()) {
                this.idleAnimationState.m_216982_(this.f_19797_);
            } else {
                this.idleAnimationState.m_216973_();
                this.rushAnimationState.m_216973_();
            }
            if (this.m_6084_() && this.isShoot()) {
                this.shootAnimationState.m_216982_(this.f_19797_);
            } else {
                this.shootAnimationState.m_216973_();
                this.shootingAnimationState.m_216973_();
            }
        }
        if (this.m_6084_() && this.isRush()) {
            Vec3 movement = this.m_20184_();
            this.checkRushAttack(this.m_20191_(), this.m_20191_().m_82363_(movement.f_82479_, movement.f_82480_, movement.f_82481_));
        }
        if (this.isChargeFailed() && ++this.failTick > 80) {
            this.setChargeFailed(false);
            this.failTick = 0;
        }
        super.m_8119_();
    }

    public boolean m_6469_(DamageSource p_21016_, float amount) {
        if (p_21016_.m_7640_() instanceof LivingEntity && this.isSleep()) {
            this.setSleep(false);
        }
        if (this.isCharging() && this.f_19796_.m_188501_() < 0.015f * amount) {
            this.setCharging(false);
            this.setChargeFailed(true);
            this.m_5496_(SoundEvents.f_12347_, 2.0f, 1.0f);
        }
        if (this.hasChargeHealth()) {
            this.setChargeHealth(this.getChargeHealth() - amount);
        }
        if (this.isFullCharge() && !this.hasChargeHealth()) {
            this.setFullCharge(false);
            this.setChargeFailed(true);
            this.m_5496_(SoundEvents.f_12347_, 2.0f, 1.0f);
        } else if (this.isFullCharge()) {
            return super.m_6469_(p_21016_, amount * 0.45f);
        }
        if (p_21016_.m_269533_(DamageTypeTags.f_268524_)) {
            return super.m_6469_(p_21016_, amount * 0.8f);
        }
        return super.m_6469_(p_21016_, amount * 0.95f);
    }

    protected void checkRushAttack(AABB p_21072_, AABB p_21073_) {
        AABB aabb = p_21072_.m_82367_(p_21073_);
        List list = this.m_9236_().m_45933_((Entity)this, aabb);
        if (!list.isEmpty()) {
            int i = 0;
            if (i < list.size()) {
                Entity entity = (Entity)list.get(i);
                this.rushAttack(entity);
            }
        } else if (this.f_19862_ && this.f_19797_ % 3 == 0) {
            boolean flag = false;
            int l = Mth.m_14143_((float)(this.m_20205_() / 2.0f + 1.0f));
            int i1 = Mth.m_14143_((float)this.m_20206_()) + 1;
            for (BlockPos blockpos : BlockPos.m_121976_((int)(this.m_146903_() - l), (int)this.m_146904_(), (int)(this.m_146907_() - l), (int)(this.m_146903_() + l), (int)(this.m_146904_() + i1), (int)(this.m_146907_() + l))) {
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                if (!blockstate.canEntityDestroy((BlockGetter)this.m_9236_(), blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
            }
            if (flag) {
                this.m_9236_().m_5898_(null, 1022, this.m_20183_(), 0);
            }
            this.m_5496_(SoundEvents.f_12314_, 2.0f, 1.0f);
        }
    }

    public void rushAttack(Entity p_36347_) {
        LivingEntity living;
        DamageSource source = this.m_269291_().m_269333_((LivingEntity)this);
        if (p_36347_ instanceof LivingEntity && (living = (LivingEntity)p_36347_).m_21275_(source)) {
            this.setRush(false);
            this.setChargeFailed(true);
            this.m_5496_(SoundEvents.f_12314_, 2.0f, 1.0f);
        } else if (p_36347_.m_6097_()) {
            p_36347_.m_6469_(source, 16.0f);
            float i = (float)this.m_21133_(Attributes.f_22282_);
            i += (float)EnchantmentHelper.m_44894_((LivingEntity)this) + 0.65f;
            if (i > 0.0f) {
                if (p_36347_ instanceof LivingEntity) {
                    ((LivingEntity)p_36347_).m_147240_((double)(i * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                } else {
                    p_36347_.m_5997_((double)(-Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * i * 0.5f), 0.1, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * i * 0.5f));
                }
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                this.m_6858_(false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (p_70103_1_ == 5) {
            this.shootingAnimationState.m_216977_(this.f_19797_);
        } else if (p_70103_1_ == 6) {
            this.rushAnimationState.m_216977_(this.f_19797_);
        } else if (p_70103_1_ == 7) {
            this.deathAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    public boolean m_7327_(Entity p_21372_) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        return super.m_7327_(p_21372_);
    }

    public void m_7023_(Vec3 p_218382_) {
        if (this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), p_218382_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
        }
        this.m_267651_(false);
    }

    public void m_8107_() {
        if (this.isFullCharge() && this.m_9236_().f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)TofuParticleTypes.TOFU_PORTAL.get(), this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        super.m_8107_();
        if (this.m_6084_() && !this.isSleep()) {
            this.calculateFlapping();
        }
        if (this.isSleep() && this.m_5448_() != null) {
            this.setSleep(false);
            this.m_5496_(SoundEvents.f_11736_, 3.0f, 1.0f);
        }
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.f_19797_ % 10 == 0 && this.isCharging()) {
            this.m_5634_(3.0f);
        }
    }

    private void calculateFlapping() {
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
    }

    public void m_6667_(DamageSource p_21014_) {
        super.m_6667_(p_21014_);
        this.m_5496_(SoundEvents.f_11738_, 2.0f, 1.0f);
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                Structure structure;
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.homePos != null && (structure = (Structure)serverLevel.m_9598_().m_175515_(Registries.f_256944_).m_6246_(TofuStructures.TOFU_CASTLE)) != null) {
                    TofuData data = TofuData.get((Level)serverLevel);
                    StructureStart structureStart = serverLevel.m_215010_().m_220494_(this.homePos, structure);
                    if (structureStart.m_73603_() && !data.getBeatenDungeons().contains(structureStart.m_73601_())) {
                        data.addBeatenDungeons(structureStart.m_73601_());
                    }
                }
            }
        }
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 38) {
            this.m_5496_(SoundEvents.f_12018_, 1.0f, 1.4f);
        }
        if (this.f_20919_ == 40) {
            this.m_5496_(SoundEvents.f_12018_, 1.0f, 1.35f);
        }
        if (this.f_20919_ == 100 && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_142535_(float p_148989_, float p_148990_, DamageSource p_148991_) {
        return false;
    }

    protected void m_7840_(double p_29370_, boolean p_29371_, BlockState p_29372_, BlockPos p_29373_) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22277_, 28.0).m_22268_(Attributes.f_22279_, 0.11).m_22268_(Attributes.f_22280_, 0.11).m_22268_(Attributes.f_22282_, (double)0.9f).m_22268_(Attributes.f_22278_, 0.9).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22285_, 2.0).m_22268_(Attributes.f_22281_, 6.0);
    }

    protected int m_7302_(int p_28882_) {
        return p_28882_;
    }

    public void m_7334_(Entity p_21294_) {
        if (!this.isSleep()) {
            super.m_7334_(p_21294_);
        }
    }

    public EntityDimensions m_6972_(Pose p_21047_) {
        EntityDimensions entitydimensions = super.m_6972_(p_21047_);
        return this.isRush() ? EntityDimensions.m_20398_((float)entitydimensions.f_20377_, (float)(entitydimensions.f_20378_ * 0.45f)) : entitydimensions;
    }

    public void m_6504_(LivingEntity p_29912_, float p_29913_) {
        this.m_5496_(SoundEvents.f_12417_, 3.0f, 1.0f);
        for (int i = 0; i < 4; ++i) {
            FukumameEntity fukumame = new FukumameEntity(this.m_9236_(), (LivingEntity)this);
            double d1 = p_29912_.m_20185_() - this.m_20185_();
            double d2 = p_29912_.m_20188_() - this.m_20188_();
            double d3 = p_29912_.m_20189_() - this.m_20189_();
            float f = Mth.m_14116_((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
            fukumame.m_6686_(d1, d2 + (double)f, d3, 1.0f, 2.0f + p_29913_);
            fukumame.damage = 1.0f;
            this.m_9236_().m_7967_((Entity)fukumame);
        }
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return TofuGandlem.this.isSleep() || TofuGandlem.this.isChargeFailed();
        }
    }

    static class AttackGoal
    extends Goal {
        private final TofuGandlem gandlem;
        private int attackStep;
        private int attackTime;
        private int lastSeen;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;

        public AttackGoal(TofuGandlem p_32247_) {
            this.gandlem = p_32247_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.gandlem.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.gandlem.m_6779_(livingentity);
        }

        public void m_8056_() {
            this.attackStep = 0;
            this.gandlem.setShoot(true);
        }

        public void m_8041_() {
            this.lastSeen = 0;
            this.gandlem.setShoot(false);
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity livingentity = this.gandlem.m_5448_();
            if (livingentity != null) {
                boolean flag = this.gandlem.m_21574_().m_148306_((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.gandlem.m_20280_((Entity)livingentity);
                if (d0 < 8.5) {
                    if (!flag) {
                        return;
                    }
                    this.attackStep = 0;
                    if (this.gandlem.isShoot()) {
                        this.gandlem.setShoot(false);
                    }
                    if (d0 < 5.0 + (double)this.gandlem.m_20205_() && this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.gandlem.m_7327_((Entity)livingentity);
                    }
                    this.gandlem.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
                    this.gandlem.m_21573_().m_26519_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() * (double)0.85f && flag) {
                    if (!this.gandlem.isShoot()) {
                        this.gandlem.setShoot(true);
                    }
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 30;
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 8;
                        } else {
                            this.attackTime = 30;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
                            this.gandlem.m_9236_().m_7605_((Entity)this.gandlem, (byte)5);
                            this.gandlem.m_6504_(livingentity, this.attackTime);
                        }
                    }
                    if (d0 < this.getFollowDistance() * this.getFollowDistance() * 0.75 && this.lastSeen <= 20) {
                        ++this.strafingTime;
                        this.gandlem.m_21573_().m_26573_();
                    } else {
                        this.strafingTime = -1;
                        this.gandlem.m_21573_().m_26519_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                    }
                    if (this.strafingTime >= 20) {
                        if ((double)this.gandlem.m_217043_().m_188501_() < 0.3) {
                            boolean bl = this.strafingClockwise = !this.strafingClockwise;
                        }
                        if ((double)this.gandlem.m_217043_().m_188501_() < 0.3) {
                            this.strafingBackwards = !this.strafingBackwards;
                        }
                        this.strafingTime = 0;
                    }
                    if (this.strafingTime > -1) {
                        if (d0 > this.getFollowDistance() * this.getFollowDistance() * (double)0.6f) {
                            this.strafingBackwards = false;
                        } else if (d0 < this.getFollowDistance() * this.getFollowDistance() * (double)0.4f) {
                            this.strafingBackwards = true;
                        }
                        this.gandlem.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                        this.gandlem.m_21391_((Entity)livingentity, 10.0f, 10.0f);
                    } else {
                        this.gandlem.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
                    }
                } else if (this.lastSeen < 200 && d0 > this.getFollowDistance() * this.getFollowDistance() || d0 <= this.getFollowDistance() * this.getFollowDistance()) {
                    this.gandlem.m_21573_().m_26519_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), (double)1.1f);
                }
                super.m_8037_();
            }
        }

        public boolean m_183429_() {
            return true;
        }

        private double getFollowDistance() {
            return this.gandlem.m_21133_(Attributes.f_22277_);
        }
    }
}

