/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity;

import baguchan.tofucraft.entity.ShuDofuSpider;
import baguchan.tofucraft.entity.projectile.FukumameEntity;
import baguchan.tofucraft.registry.TofuAdvancements;
import baguchan.tofucraft.registry.TofuEntityTypes;
import baguchan.tofucraft.registry.TofuSounds;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class TofuSpider
extends Spider
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.m_135353_(TofuSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int conversionTime;

    public TofuSpider(EntityType<? extends TofuSpider> p_33786_, Level p_33787_) {
        super(p_33786_, p_33787_);
        this.f_21364_ = 4;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CONVERTING_ID, (Object)false);
    }

    public static AttributeSupplier.Builder m_33815_() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 18.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 18.0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TofuSounds.TOFUSPIDER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33814_) {
        return (SoundEvent)TofuSounds.TOFUSPIDER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TofuSounds.TOFUSPIDER_DEATH.get();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new TofuSpiderAttackGoal(this));
    }

    public void m_7380_(CompoundTag p_34397_) {
        super.m_7380_(p_34397_);
        p_34397_.m_128405_("ConversionTime", this.isConverting() ? this.conversionTime : -1);
    }

    public void m_7378_(CompoundTag p_34387_) {
        super.m_7378_(p_34387_);
        if (p_34387_.m_128425_("ConversionTime", 99) && p_34387_.m_128451_("ConversionTime") > -1) {
            this.startConverting(p_34387_.m_128451_("ConversionTime"));
        }
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.isConverting()) {
            --this.conversionTime;
            if (this.conversionTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)((EntityType)TofuEntityTypes.SHUDOFUSPIDER.get()), timer -> {
                this.conversionTime = timer;
            })) {
                this.finishConversion((ServerLevel)this.m_9236_());
                if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                    int j1 = Mth.m_14107_((double)this.m_20186_());
                    int i2 = Mth.m_14107_((double)this.m_20185_());
                    int j2 = Mth.m_14107_((double)this.m_20189_());
                    boolean flag = false;
                    for (int j = -1; j <= 1; ++j) {
                        for (int k2 = -1; k2 <= 1; ++k2) {
                            for (int k = 0; k <= 3; ++k) {
                                int l2 = i2 + j;
                                int l = j1 + k;
                                int i1 = j2 + k2;
                                BlockPos blockpos = new BlockPos(l2, l, i1);
                                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                                if (!WitherBoss.m_31491_((BlockState)blockstate) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                                flag = this.m_9236_().m_46953_(blockpos, true, (Entity)this) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.m_9236_().m_5898_((Player)null, 1022, this.m_20183_(), 0);
                    }
                }
            }
        }
        super.m_8119_();
    }

    private void finishConversion(ServerLevel p_34399_) {
        ShuDofuSpider shudofuSpider = (ShuDofuSpider)this.m_21406_((EntityType)TofuEntityTypes.SHUDOFUSPIDER.get(), false);
        shudofuSpider.m_6518_((ServerLevelAccessor)p_34399_, p_34399_.m_6436_(shudofuSpider.m_20183_()), MobSpawnType.CONVERSION, null, null);
        List players = p_34399_.m_45955_(TargetingConditions.m_148353_().m_26893_().m_148355_(), (LivingEntity)this, this.m_20191_().m_82400_(60.0));
        for (Player player : players) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TofuAdvancements.NIGHTMARES_ECHO.trigger(serverPlayer);
        }
        shudofuSpider.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
        if (!this.m_20067_()) {
            this.m_5496_(SoundEvents.f_12563_, 4.0f, 1.0f);
        }
        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)shudofuSpider);
    }

    public boolean m_6785_(double p_34414_) {
        return !this.isConverting();
    }

    public boolean isConverting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_CONVERTING_ID);
    }

    public void startConverting(int p_34385_) {
        this.m_20088_().m_135381_(DATA_CONVERTING_ID, (Object)true);
        this.conversionTime = p_34385_;
        this.m_9236_().m_7605_((Entity)this, (byte)16);
    }

    protected float m_6431_(Pose p_33799_, EntityDimensions p_33800_) {
        return 0.35f;
    }

    public boolean m_7307_(Entity p_20355_) {
        if (p_20355_ instanceof ShuDofuSpider) {
            return this.m_5647_() == null && p_20355_.m_5647_() == null;
        }
        return super.m_7307_(p_20355_);
    }

    public void m_6504_(LivingEntity p_29912_, float p_29913_) {
        this.m_5496_(SoundEvents.f_12098_, 1.0f, 1.0f);
        for (int i = 0; i < 3; ++i) {
            FukumameEntity fukumame = new FukumameEntity(this.m_9236_(), (LivingEntity)this);
            double d1 = p_29912_.m_20185_() - this.m_20185_();
            double d2 = p_29912_.m_20188_() - this.m_20188_();
            double d3 = p_29912_.m_20189_() - this.m_20189_();
            float f = Mth.m_14116_((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
            fukumame.damage = 1.0f;
            fukumame.m_6686_(d1, d2 + (double)f, d3, 1.0f, 2.0f + p_29913_);
            this.m_9236_().m_7967_((Entity)fukumame);
        }
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @javax.annotation.Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag p_33794_) {
        return spawnGroupData;
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.65f : 1.15f;
    }

    static class TofuSpiderAttackGoal
    extends Goal {
        private final TofuSpider spider;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public TofuSpiderAttackGoal(TofuSpider p_32247_) {
            this.spider = p_32247_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.spider.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.spider.m_6779_(livingentity);
        }

        public void m_8056_() {
            this.attackStep = 0;
        }

        public void m_8041_() {
            this.lastSeen = 0;
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity livingentity = this.spider.m_5448_();
            if (livingentity != null) {
                boolean flag = this.spider.m_21574_().m_148306_((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.spider.m_20280_((Entity)livingentity);
                if (d0 < 32.0) {
                    if (!flag) {
                        return;
                    }
                    this.attackStep = 0;
                    if (d0 < 4.0 + (double)this.spider.m_20205_() && this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.spider.m_7327_((Entity)livingentity);
                    }
                    this.spider.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
                    this.spider.m_21573_().m_26519_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 20;
                        } else if (this.attackStep <= 2) {
                            this.attackTime = 10;
                        } else {
                            this.attackTime = 30;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            this.spider.m_6504_(livingentity, this.attackTime);
                            this.spider.m_5496_((SoundEvent)TofuSounds.TOFUSPIDER_SPIT.get(), 1.0f, (float)((double)0.9f + this.spider.f_19796_.m_188500_() * (double)0.2f));
                        }
                    }
                    this.spider.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
                    this.spider.m_21573_().m_26573_();
                } else if (this.lastSeen < 5) {
                    this.spider.m_21573_().m_26519_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                }
                super.m_8037_();
            }
        }

        private double getFollowDistance() {
            return this.spider.m_21133_(Attributes.f_22277_);
        }
    }
}

