/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity;

import baguchan.tofucraft.entity.AbstractTofunian;
import baguchan.tofucraft.entity.ShuDofuSpider;
import baguchan.tofucraft.entity.TofuGandlem;
import baguchan.tofucraft.entity.TofuGolem;
import baguchan.tofucraft.entity.goal.CropHarvestGoal;
import baguchan.tofucraft.entity.goal.DoSleepingGoal;
import baguchan.tofucraft.entity.goal.EatItemGoal;
import baguchan.tofucraft.entity.goal.FindJobBlockGoal;
import baguchan.tofucraft.entity.goal.FindStatueBlockGoal;
import baguchan.tofucraft.entity.goal.LookAtTofunianTradingPlayerGoal;
import baguchan.tofucraft.entity.goal.MakeFoodGoal;
import baguchan.tofucraft.entity.goal.MoveToJobGoal;
import baguchan.tofucraft.entity.goal.MoveToStatueGoal;
import baguchan.tofucraft.entity.goal.OpenTofuDoorGoal;
import baguchan.tofucraft.entity.goal.RestockGoal;
import baguchan.tofucraft.entity.goal.ShareItemAndGossipGoal;
import baguchan.tofucraft.entity.goal.TofunianLoveGoal;
import baguchan.tofucraft.entity.goal.TofunianSleepOnBedGoal;
import baguchan.tofucraft.entity.goal.TofunianTradeWithPlayerGoal;
import baguchan.tofucraft.entity.goal.WakeUpGoal;
import baguchan.tofucraft.registry.TofuAdvancements;
import baguchan.tofucraft.registry.TofuBiomes;
import baguchan.tofucraft.registry.TofuEntityTypes;
import baguchan.tofucraft.registry.TofuItems;
import baguchan.tofucraft.registry.TofuParticleTypes;
import baguchan.tofucraft.registry.TofuSounds;
import baguchan.tofucraft.registry.TofuTrades;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.common.util.ITeleporter;

public class Tofunian
extends AbstractTofunian
implements ReputationEventHandler {
    private static final EntityDataAccessor<String> ACTION = SynchedEntityData.m_135353_(Tofunian.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> ROLE = SynchedEntityData.m_135353_(Tofunian.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> TOFUNIAN_TYPE = SynchedEntityData.m_135353_(Tofunian.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final Map<Item, Integer> FOOD_POINTS = ImmutableMap.of((Object)((Item)TofuItems.SOYMILK.get()), (Object)3, (Object)((Item)TofuItems.TOFUCOOKIE.get()), (Object)3, (Object)((Item)TofuItems.TOFUGRILLED.get()), (Object)1);
    private static final Set<Item> WANTED_ITEMS = ImmutableSet.of((Object)((Item)TofuItems.SOYMILK.get()), (Object)((Item)TofuItems.TOFUCOOKIE.get()), (Object)((Item)TofuItems.TOFUGRILLED.get()), (Object)((Item)TofuItems.SEEDS_SOYBEANS.get()));
    private static final Predicate<? super ItemEntity> ALLOWED_ITEMS = p_213616_0_ -> WANTED_ITEMS.contains(p_213616_0_.m_32055_().m_41720_());
    private byte foodLevel;
    private final GossipContainer gossips = new GossipContainer();
    @Nullable
    private BlockPos tofunianHome;
    @Nullable
    private BlockPos tofunianJobBlock;
    @Nullable
    private BlockPos villageCenter;
    private long lastGossipTime;
    private long lastGossipDecay;
    private long lastRestock;
    private int restocksToday;
    private long lastRestockDayTime;
    private int timeUntilReset;
    private boolean leveledUp;
    @Nullable
    private Player previousCustomer;
    private int xp;
    private int tofunianLevel = 1;
    private int actionTick;
    public final AnimationState happyAnimationState = new AnimationState();
    public final AnimationState eatFoodAnimationState = new AnimationState();
    public final AnimationState waveAnimationState = new AnimationState();

    public Tofunian(EntityType<? extends Tofunian> type, Level worldIn) {
        super(type, worldIn);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21553_(true);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new WakeUpGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new DoSleepingGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TofunianTradeWithPlayerGoal(this){

            @Override
            public void m_8056_() {
                super.m_8056_();
                Tofunian.this.setAction(Actions.NORMAL);
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new OpenTofuDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(1, new TofunianAvoidEntityGoal<Zombie>(this, Zombie.class, 8.0f, 1.25, 1.3));
        this.f_21345_.m_25352_(1, new TofunianAvoidEntityGoal<Evoker>(this, Evoker.class, 12.0f, 1.25, 1.3));
        this.f_21345_.m_25352_(1, new TofunianAvoidEntityGoal<Vindicator>(this, Vindicator.class, 8.0f, 1.25, 1.3));
        this.f_21345_.m_25352_(1, new TofunianAvoidEntityGoal<Vex>(this, Vex.class, 8.0f, 1.25, 1.3));
        this.f_21345_.m_25352_(1, new TofunianAvoidEntityGoal<Pillager>(this, Pillager.class, 15.0f, 1.25, 1.3));
        this.f_21345_.m_25352_(1, new TofunianAvoidEntityGoal<Illusioner>(this, Illusioner.class, 12.0f, 1.25, 1.3));
        this.f_21345_.m_25352_(1, new TofunianAvoidEntityGoal<Zoglin>(this, Zoglin.class, 10.0f, 1.25, 1.3));
        this.f_21345_.m_25352_(1, new TofunianAvoidEntityGoal<ShuDofuSpider>(this, ShuDofuSpider.class, 10.0f, 1.25, 1.3));
        this.f_21345_.m_25352_(1, new TofunianAvoidEntityGoal<TofuGandlem>(this, TofuGandlem.class, 10.0f, 1.25, 1.3));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.35){

            public void m_8056_() {
                super.m_8056_();
                Tofunian.this.setAction(Actions.AVOID);
            }

            public void m_8041_() {
                super.m_8041_();
                Tofunian.this.setAction(Actions.NORMAL);
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new LookAtTofunianTradingPlayerGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new TofunianSleepOnBedGoal(this, (double)0.85f, 6));
        this.f_21345_.m_25352_(3, new EatItemGoal<Tofunian>(this, null, p_35882_ -> this.m_21223_() < this.m_21233_()));
        this.f_21345_.m_25352_(4, (Goal)new TofunianLoveGoal(this, 0.8f));
        this.f_21345_.m_25352_(5, (Goal)new GetItemGoal(this, this));
        this.f_21345_.m_25352_(6, (Goal)new MoveToStatueGoal(this, 0.8f, 5));
        this.f_21345_.m_25352_(8, (Goal)new CropHarvestGoal(this, 0.9f));
        this.f_21345_.m_25352_(9, (Goal)new MakeFoodGoal(this, 0.9f, 1));
        this.f_21345_.m_25352_(10, (Goal)new RestockGoal(this, 0.9f, 1));
        this.f_21345_.m_25352_(11, (Goal)new MoveToJobGoal(this, 0.9f, 1));
        this.f_21345_.m_25352_(12, (Goal)new MoveToGoal(this, 42.0, 1.0));
        this.f_21345_.m_25352_(13, (Goal)new FindJobBlockGoal(this, 0.85f, 6));
        this.f_21345_.m_25352_(14, (Goal)new FindStatueBlockGoal(this, 0.85f, 6));
        this.f_21345_.m_25352_(15, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(16, (Goal)new InteractGoal((Mob)this, AbstractTofunian.class, 4.0f, 0.25f){

            public void m_8056_() {
                super.m_8056_();
                Tofunian.this.setAction(Actions.WAVE);
            }
        });
        this.f_21345_.m_25352_(16, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f){

            public void m_8056_() {
                super.m_8056_();
                Tofunian.this.setAction(Actions.WAVE);
            }
        });
        this.f_21345_.m_25352_(17, (Goal)new ShareItemAndGossipGoal(this, 0.9f));
        this.f_21345_.m_25352_(18, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(19, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.24).m_22268_(Attributes.f_22276_, 20.0);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Tofunian tofunian = (Tofunian)((EntityType)TofuEntityTypes.TOFUNIAN.get()).m_20615_((Level)p_241840_1_);
        if (tofunian != null) {
            TofunianType variant = this.f_19796_.m_188499_() ? this.getTofunianType() : ((Tofunian)p_241840_2_).getTofunianType();
            tofunian.setTofunianType(variant);
        }
        return tofunian;
    }

    public boolean isMeeting() {
        long time = this.m_9236_().m_46468_();
        long day = time / 24000L;
        return day % 5L == 0L;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ROLE, (Object)Roles.TOFUNIAN.name());
        this.f_19804_.m_135372_(ACTION, (Object)Actions.NORMAL.name());
        this.f_19804_.m_135372_(TOFUNIAN_TYPE, (Object)TofunianType.NORMAL.name());
    }

    public void m_7350_(EntityDataAccessor<?> p_146754_) {
        if (ACTION.equals(p_146754_)) {
            this.actionAnimations(this.getAction(), false);
        }
        super.m_7350_(p_146754_);
    }

    public Actions getAction() {
        return Actions.get((String)this.f_19804_.m_135370_(ACTION));
    }

    public void setAction(Actions action) {
        this.f_19804_.m_135381_(ACTION, (Object)action.name());
        this.actionTick = 0;
    }

    public void setRole(Roles role) {
        this.f_19804_.m_135381_(ROLE, (Object)role.name());
    }

    public Roles getRole() {
        return Roles.get((String)this.f_19804_.m_135370_(ROLE));
    }

    public void setTofunianType(TofunianType type) {
        this.f_19804_.m_135381_(TOFUNIAN_TYPE, (Object)type.name());
    }

    public TofunianType getTofunianType() {
        return TofunianType.get((String)this.f_19804_.m_135370_(TOFUNIAN_TYPE));
    }

    public void setTofunianHome(@Nullable BlockPos pos) {
        this.tofunianHome = pos;
    }

    @Nullable
    public BlockPos getTofunianHome() {
        return this.tofunianHome;
    }

    public void setTofunianJobBlock(@Nullable BlockPos tofunianJobBlock) {
        this.tofunianJobBlock = tofunianJobBlock;
    }

    @Nullable
    public BlockPos getTofunianJobBlock() {
        return this.tofunianJobBlock;
    }

    public void setVillageCenter(@Nullable BlockPos villageCenter) {
        this.villageCenter = villageCenter;
    }

    @Nullable
    public BlockPos getVillageCenter() {
        return this.villageCenter;
    }

    @Override
    @Nullable
    public Entity changeDimension(ServerLevel server, ITeleporter teleporter) {
        this.setTofunianHome(null);
        if (this.xp != 0) {
            this.setTofunianJobBlock(null);
        }
        return super.changeDimension(server, teleporter);
    }

    protected void m_8024_() {
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.leveledUp) {
                    this.increaseMerchantCareer();
                    this.leveledUp = false;
                }
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 0));
            }
        }
        if (this.previousCustomer != null && this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8670_(ReputationEventType.f_26989_, (Entity)this.previousCustomer, (ReputationEventHandler)this);
            this.m_9236_().m_7605_((Entity)this, (byte)14);
            this.previousCustomer = null;
        }
        if (this.getRole() == Roles.TOFUNIAN && this.isTrading()) {
            this.stopTrading();
        }
        this.tofunianJobCheck();
        this.tofunianHomeCheck();
        super.m_8024_();
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
        this.actionTicks();
        if (this.m_9236_().f_46443_) {
            this.actionAnimations(this.getAction(), true);
            if (this.getAction() == Actions.CRY) {
                this.m_9236_().m_7106_((ParticleOptions)TofuParticleTypes.SOYMILK_SPLASH.get(), this.m_20185_(), this.m_20188_(), this.m_20189_(), (double)Mth.m_216267_((RandomSource)this.f_19796_, (float)-1.0f, (float)1.0f) * 0.15, 0.05, (double)Mth.m_216267_((RandomSource)this.f_19796_, (float)-1.0f, (float)1.0f) * 0.15);
            }
        }
    }

    public void actionTicks() {
        if (this.getAction().tick > -1) {
            if (this.getAction().tick <= this.actionTick) {
                this.actionTick = 0;
                this.setAction(Actions.NORMAL);
            } else {
                ++this.actionTick;
            }
        } else {
            this.actionTick = 0;
        }
    }

    public void actionAnimations(Actions actions, boolean loop) {
        if (loop && actions.loop || !loop && !actions.loop) {
            switch (actions) {
                case HAPPY: {
                    this.stopAnimations();
                    this.happyAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case EAT: {
                    if (!loop && !actions.loop) {
                        this.stopAnimations();
                    }
                    this.eatFoodAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case WAVE: {
                    this.stopAnimations();
                    this.eatFoodAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case NORMAL: {
                    this.stopAnimations();
                    break;
                }
                default: {
                    this.stopAnimations();
                }
            }
        }
    }

    public void stopAnimations() {
        this.eatFoodAnimationState.m_216973_();
        this.happyAnimationState.m_216973_();
    }

    public void tofunianJobCheck() {
        if ((this.m_9236_().m_46467_() + (long)this.m_19879_()) % 50L != 0L) {
            return;
        }
        if (this.getTofunianJobBlock() != null && this.getRole() != Roles.TOFUNIAN && !this.getRole().is(this.m_9236_().m_8055_(this.getTofunianJobBlock()))) {
            this.setTofunianJobBlock(null);
            if (this.getTofunianLevel() == 1 && this.m_7809_() == 0) {
                this.setOffers(null);
                this.setRole(Roles.TOFUNIAN);
            }
        }
        if (this.getVillageCenter() != null && this.m_9236_() instanceof ServerLevel) {
            PoiManager poimanager = ((ServerLevel)this.m_9236_()).m_8904_();
            if (poimanager.m_27091_(this.getVillageCenter(), p_217230_ -> true) && this.getVillageCenter().m_123333_((Vec3i)this.m_20183_()) > 128) {
                poimanager.m_27154_(this.getVillageCenter());
                this.setVillageCenter(null);
            } else if (!poimanager.m_27091_(this.getVillageCenter(), p_217230_ -> true)) {
                this.setVillageCenter(null);
            }
        }
    }

    private boolean findNearbyTofunianHadHome(Tofunian tofunian, BlockPos pos) {
        List list = tofunian.m_9236_().m_45976_(Tofunian.class, tofunian.m_20191_().m_82400_(32.0));
        return list.stream().anyMatch(p_34881_ -> p_34881_ != tofunian && pos.equals((Object)p_34881_.getTofunianHome()));
    }

    public void tofunianHomeCheck() {
        if ((this.m_9236_().m_46467_() + (long)this.m_19879_()) % 90L != 0L) {
            return;
        }
        boolean tryFind = false;
        if (this.getTofunianHome() == null) {
            tryFind = true;
        } else if (!this.m_9236_().m_8055_(this.getTofunianHome()).m_204336_(BlockTags.f_13038_)) {
            tryFind = true;
            this.setTofunianHome(null);
        }
        if (tryFind) {
            int range = 8;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range / 2; y <= range / 2; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos pos = this.m_20183_().m_7918_(x, y, z);
                        if (!this.m_9236_().m_8055_(pos).m_204336_(BlockTags.f_13038_) || this.findNearbyTofunianHadHome(this, pos)) continue;
                        this.setTofunianHome(pos);
                        return;
                    }
                }
            }
        }
    }

    @Override
    protected void rewardTradeXp(MerchantOffer offer) {
        int i = 3 + this.f_19796_.m_188503_(4);
        this.xp += offer.m_45379_();
        this.previousCustomer = this.m_7962_();
        if (this.canLevelUp()) {
            this.timeUntilReset = 40;
            this.leveledUp = true;
            i += 5;
        }
        if (offer.m_45383_()) {
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor p_35282_, DifficultyInstance p_35283_, MobSpawnType p_35284_, @org.jetbrains.annotations.Nullable SpawnGroupData p_35285_, @org.jetbrains.annotations.Nullable CompoundTag p_35286_) {
        if (p_35282_.m_204166_(this.m_20183_()).m_203565_(TofuBiomes.ZUNDA_FOREST)) {
            this.setTofunianType(TofunianType.ZUNDA);
        }
        return super.m_6518_(p_35282_, p_35283_, p_35284_, p_35285_, p_35286_);
    }

    public InteractionResult m_6071_(Player p_35472_, InteractionHand p_35473_) {
        ItemStack itemstack = p_35472_.m_21120_(p_35473_);
        if (itemstack.m_41720_() != TofuItems.TOFUNIAN_SPAWNEGG.get() && this.m_6084_() && !this.isTrading() && !this.m_5803_() && !p_35472_.m_36341_()) {
            if (p_35472_ instanceof ServerPlayer) {
                TofuAdvancements.MY_TOFU_CHILD.trigger((ServerPlayer)p_35472_);
            }
            if (this.m_6162_()) {
                this.setUnhappy();
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            boolean flag = this.m_6616_().isEmpty();
            if (this.getAction() == Actions.HAPPY || this.getAction() == Actions.EAT || this.getAction() == Actions.CRY) {
                return InteractionResult.CONSUME;
            }
            if (p_35473_ == InteractionHand.MAIN_HAND) {
                if (flag && !this.m_9236_().f_46443_) {
                    this.setUnhappy();
                }
                p_35472_.m_36220_(Stats.f_12940_);
            }
            if (flag) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_9236_().f_46443_ && !this.offers.isEmpty()) {
                this.startTrading(p_35472_);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(p_35472_, p_35473_);
    }

    private void setUnhappy() {
        this.setUnhappyCounter(40);
        if (!this.m_9236_().m_5776_()) {
            this.m_5496_((SoundEvent)TofuSounds.TOFUNIAN_NO.get(), this.m_6121_(), this.m_6100_());
        }
    }

    private void updateSpecialPrices(Player p_35541_) {
        int i = this.getPlayerReputation(p_35541_);
        if (i != 0) {
            for (MerchantOffer merchantoffer : this.m_6616_()) {
                merchantoffer.m_45353_(-Mth.m_14143_((float)((float)i * merchantoffer.m_45378_())));
            }
        }
        if (p_35541_.m_21023_(MobEffects.f_19595_)) {
            MobEffectInstance mobeffectinstance = p_35541_.m_21124_(MobEffects.f_19595_);
            int k = mobeffectinstance.m_19564_();
            for (MerchantOffer merchantoffer1 : this.m_6616_()) {
                double d0 = 0.3 + 0.0625 * (double)k;
                int j = (int)Math.floor(d0 * (double)merchantoffer1.m_45352_().m_41613_());
                merchantoffer1.m_45353_(-Math.max(j, 1));
            }
        }
    }

    private void startTrading(Player p_35537_) {
        this.updateSpecialPrices(p_35537_);
        this.m_7189_(p_35537_);
        this.m_45301_(p_35537_, this.m_5446_(), this.getTofunianLevel());
    }

    @Override
    public void m_7189_(@Nullable Player player) {
        boolean flag = this.m_7962_() != null && player == null;
        super.m_7189_(player);
        if (flag) {
            this.stopTrading();
        }
    }

    @Override
    protected void stopTrading() {
        super.stopTrading();
        this.resetSpecialPrices();
    }

    private void resetSpecialPrices() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45376_();
        }
    }

    public boolean m_7862_() {
        return true;
    }

    public void restock() {
        this.calculateDemandOfOffers();
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45372_();
        }
        this.lastRestock = this.m_9236_().m_46467_();
        ++this.restocksToday;
    }

    private boolean allowedToRestock() {
        return this.restocksToday == 0 || this.restocksToday < 2 && this.m_9236_().m_46467_() > this.lastRestock + 2400L;
    }

    public boolean canResetStock() {
        long i = this.lastRestock + 12000L;
        long j = this.m_9236_().m_46467_();
        boolean flag = j > i;
        long k = this.m_9236_().m_46468_();
        if (this.lastRestockDayTime > 0L) {
            long i1 = k / 24000L;
            long l = this.lastRestockDayTime / 24000L;
            flag |= i1 > l;
        }
        this.lastRestockDayTime = k;
        if (flag) {
            this.lastRestock = j;
            this.resetNumberOfRestocks();
        }
        return this.allowedToRestock() && this.hasUsedOffer();
    }

    private void resetNumberOfRestocks() {
        this.resetOffersAndAdjustForDemand();
        this.restocksToday = 0;
    }

    private void resetOffersAndAdjustForDemand() {
        int i = 2 - this.restocksToday;
        if (i > 0) {
            for (MerchantOffer merchantoffer : this.m_6616_()) {
                merchantoffer.m_45372_();
            }
        }
        for (int j = 0; j < i; ++j) {
            this.calculateDemandOfOffers();
        }
    }

    private boolean hasUsedOffer() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            if (!merchantoffer.m_45382_()) continue;
            return true;
        }
        return false;
    }

    private void calculateDemandOfOffers() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45369_();
        }
    }

    public void setOffers(MerchantOffers offersIn) {
        this.offers = offersIn;
    }

    private boolean canLevelUp() {
        int i = this.tofunianLevel;
        return VillagerData.m_35582_((int)i) && this.xp >= VillagerData.m_35577_((int)i);
    }

    private void increaseMerchantCareer() {
        this.setTofunianLevel(this.tofunianLevel + 1);
        this.updateTrades();
        this.setAction(Actions.HAPPY);
    }

    public void setTofunianLevel(int level) {
        this.tofunianLevel = level;
    }

    public int getTofunianLevel() {
        return this.tofunianLevel;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("FoodLevel", this.foodLevel);
        compound.m_128365_("Gossips", ((Tag)this.gossips.m_262795_((DynamicOps)NbtOps.f_128958_)).m_6426_());
        compound.m_128405_("Xp", this.xp);
        compound.m_128405_("Level", this.tofunianLevel);
        compound.m_128356_("LastRestock", this.lastRestock);
        compound.m_128356_("LastGossipDecay", this.lastGossipDecay);
        compound.m_128405_("RestocksToday", this.restocksToday);
        if (this.tofunianHome != null) {
            compound.m_128365_("TofunianHome", (Tag)NbtUtils.m_129224_((BlockPos)this.tofunianHome));
        }
        if (this.tofunianJobBlock != null) {
            compound.m_128365_("TofunianJobBlock", (Tag)NbtUtils.m_129224_((BlockPos)this.tofunianJobBlock));
        }
        if (this.villageCenter != null) {
            compound.m_128365_("VillageCenter", (Tag)NbtUtils.m_129224_((BlockPos)this.villageCenter));
        }
        compound.m_128359_("Roles", this.getRole().name());
        compound.m_128359_("TofunianType", this.getTofunianType().name());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("FoodLevel", 1)) {
            this.foodLevel = compound.m_128445_("FoodLevel");
        }
        ListTag listtag = compound.m_128437_("Gossips", 10);
        this.gossips.m_26177_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)listtag));
        if (compound.m_128425_("Xp", 3)) {
            this.xp = compound.m_128451_("Xp");
        }
        if (compound.m_128441_("Level")) {
            this.tofunianLevel = compound.m_128451_("Level");
        }
        this.lastGossipDecay = compound.m_128454_("LastGossipDecay");
        this.lastRestock = compound.m_128454_("LastRestock");
        this.restocksToday = compound.m_128451_("RestocksToday");
        if (compound.m_128441_("TofunianHome")) {
            this.tofunianHome = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("TofunianHome"));
        }
        if (compound.m_128441_("TofunianJobBlock")) {
            this.tofunianJobBlock = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("TofunianJobBlock"));
        }
        if (compound.m_128441_("VillageCenter")) {
            this.villageCenter = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("VillageCenter"));
        }
        if (compound.m_128441_("Roles")) {
            this.setRole(Roles.get(compound.m_128461_("Roles")));
        }
        if (compound.m_128441_("TofunianType")) {
            this.setTofunianType(TofunianType.get(compound.m_128461_("TofunianType")));
        }
        this.m_21553_(true);
    }

    @Override
    public int m_7809_() {
        return this.xp;
    }

    protected void m_7581_(ItemEntity p_175445_1_) {
        ItemStack itemstack = p_175445_1_.m_32055_();
        if (this.m_7243_(itemstack)) {
            SimpleContainer inventory = this.m_35311_();
            boolean flag = inventory.m_19183_(itemstack);
            if (!flag) {
                return;
            }
            this.m_21053_(p_175445_1_);
            this.m_7938_((Entity)p_175445_1_, itemstack.m_41613_());
            ItemStack itemstack1 = inventory.m_19173_(itemstack);
            if (itemstack1.m_41619_()) {
                p_175445_1_.m_146870_();
            } else {
                itemstack.m_41764_(itemstack1.m_41613_());
            }
        }
    }

    public boolean canMate() {
        return this.foodLevel + this.countFoodPointsInInventory() >= 42 && this.m_146764_() == 0;
    }

    private boolean hungry() {
        return this.foodLevel < 12;
    }

    public boolean m_7243_(ItemStack p_230293_1_) {
        Item item = p_230293_1_.m_41720_();
        return WANTED_ITEMS.contains(item) && this.m_35311_().m_19183_(p_230293_1_);
    }

    public boolean hasExcessFood() {
        return this.countFoodPointsInInventory() >= 42;
    }

    public boolean wantsMoreFood() {
        return this.countFoodPointsInInventory() < 42;
    }

    public boolean hasFarmSeeds() {
        return this.m_35311_().m_18949_((Set)ImmutableSet.of((Object)((Item)TofuItems.SEEDS_SOYBEANS.get())));
    }

    private int countFoodPointsInInventory() {
        SimpleContainer inventory = this.m_35311_();
        return FOOD_POINTS.entrySet().stream().mapToInt(p_226553_1_ -> inventory.m_18947_((Item)p_226553_1_.getKey()) * (Integer)p_226553_1_.getValue()).sum();
    }

    private void eatUntilFull() {
        if (this.hungry() && this.countFoodPointsInInventory() != 0) {
            for (int i = 0; i < this.m_35311_().m_6643_(); ++i) {
                int j;
                Integer integer;
                ItemStack itemstack = this.m_35311_().m_8020_(i);
                if (itemstack.m_41619_() || (integer = FOOD_POINTS.get(itemstack.m_41720_())) == null) continue;
                for (int k = j = itemstack.m_41613_(); k > 0; --k) {
                    this.foodLevel = (byte)(this.foodLevel + integer);
                    this.m_35311_().m_7407_(i, 1);
                    if (this.hungry()) continue;
                    return;
                }
            }
        }
    }

    private void digestFood(int p_35549_) {
        this.foodLevel = (byte)(this.foodLevel - p_35549_);
    }

    public void eatAndDigestFood() {
        this.eatUntilFull();
        this.digestFood(12);
    }

    public void cookingFood() {
        for (int i = 0; i < this.m_35311_().m_6643_(); ++i) {
            ItemStack itemstack = this.m_35311_().m_8020_(i);
            if (itemstack.m_41619_() || itemstack.m_41720_() != TofuItems.SEEDS_SOYBEANS.get()) continue;
            this.m_35311_().m_7407_(i, 1);
            this.cookResult();
        }
    }

    public boolean eatFood() {
        if (this.m_35311_().m_7983_()) {
            return false;
        }
        for (int i = 0; i < this.m_35311_().m_6643_(); ++i) {
            ItemStack itemstack = this.m_35311_().m_8020_(i);
            if (itemstack.m_41619_() || !FOOD_POINTS.containsKey(itemstack.m_41720_())) continue;
            this.m_21008_(InteractionHand.MAIN_HAND, itemstack.m_41620_(1));
            return true;
        }
        return false;
    }

    private void cookResult() {
        this.m_35311_().m_19173_(new ItemStack((ItemLike)TofuItems.TOFUGRILLED.get()));
    }

    public ItemStack m_5584_(Level level, ItemStack stack) {
        this.m_5634_(stack.getFoodProperties((LivingEntity)this).m_38744_());
        this.m_5496_(SoundEvents.f_12321_, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        return super.m_5584_(level, stack);
    }

    @Override
    public void updateTrades() {
        VillagerTrades.ItemListing[] avillagertrades$ItemListing;
        Int2ObjectMap<VillagerTrades.ItemListing[]> int2objectmap = TofuTrades.TOFUNIAN_TRADE.get((Object)this.getRole());
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades$ItemListing = (VillagerTrades.ItemListing[])int2objectmap.get(this.tofunianLevel)) != null) {
            MerchantOffers merchantoffers = this.m_6616_();
            this.addOffersFromItemListings(merchantoffers, avillagertrades$ItemListing, 2);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.maybeDecayGossip();
    }

    public void m_6703_(@Nullable LivingEntity p_70604_1_) {
        if (p_70604_1_ != null && this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8670_(ReputationEventType.f_26987_, (Entity)p_70604_1_, (ReputationEventHandler)this);
            if (this.m_6084_() && p_70604_1_ instanceof Player) {
                this.m_9236_().m_7605_((Entity)this, (byte)13);
            }
        }
        super.m_6703_(p_70604_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 12) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123750_);
        } else if (p_70103_1_ == 13) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123792_);
        } else if (p_70103_1_ == 14) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123748_);
        } else if (p_70103_1_ == 42) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123769_);
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    @Override
    public void m_6667_(DamageSource p_35419_) {
        PoiManager poimanager;
        Entity entity = p_35419_.m_7639_();
        if (this.getVillageCenter() != null && this.m_9236_() instanceof ServerLevel && (poimanager = ((ServerLevel)this.m_9236_()).m_8904_()).m_27091_(this.getVillageCenter(), p_217230_ -> true)) {
            poimanager.m_27154_(this.getVillageCenter());
        }
        super.m_6667_(p_35419_);
    }

    @Nullable
    public Entity m_5489_(ServerLevel serverLevel) {
        if (this.getVillageCenter() != null) {
            PoiManager poimanager = serverLevel.m_8904_();
            if (poimanager.m_27091_(this.getVillageCenter(), p_217230_ -> true)) {
                poimanager.m_27154_(this.getVillageCenter());
            }
            this.setVillageCenter(null);
        }
        this.setTofunianHome(null);
        return super.m_5489_(serverLevel);
    }

    public void m_6814_(ReputationEventType reputationEventType, Entity entity) {
        if (reputationEventType == ReputationEventType.f_26985_) {
            this.gossips.m_26191_(entity.m_20148_(), GossipType.MAJOR_POSITIVE, 20);
            this.gossips.m_26191_(entity.m_20148_(), GossipType.MINOR_POSITIVE, 25);
        } else if (reputationEventType == ReputationEventType.f_26989_) {
            this.gossips.m_26191_(entity.m_20148_(), GossipType.TRADING, 2);
        } else if (reputationEventType == ReputationEventType.f_26987_) {
            this.gossips.m_26191_(entity.m_20148_(), GossipType.MINOR_NEGATIVE, 25);
        } else if (reputationEventType == ReputationEventType.f_26988_) {
            this.gossips.m_26191_(entity.m_20148_(), GossipType.MAJOR_NEGATIVE, 25);
        }
    }

    public int getPlayerReputation(Player p_35533_) {
        return this.gossips.m_26195_(p_35533_.m_20148_(), p_35427_ -> true);
    }

    public void gossip(ServerLevel p_35412_, Tofunian p_35413_, long p_35414_) {
        if (!(p_35414_ >= this.lastGossipTime && p_35414_ < this.lastGossipTime + 1200L || p_35414_ >= p_35413_.lastGossipTime && p_35414_ < p_35413_.lastGossipTime + 1200L)) {
            this.gossips.m_217762_(p_35413_.gossips, this.f_19796_, 10);
            this.lastGossipTime = p_35414_;
            p_35413_.lastGossipTime = p_35414_;
            this.spawnGolemIfNeeded(p_35412_, p_35414_, 4);
        }
    }

    public void spawnGolemIfNeeded(ServerLevel p_35398_, long p_35399_, int p_35400_) {
        AABB aabb;
        List list;
        List list1;
        if (!this.wantsToSpawnGolem(p_35398_, p_35399_) || (list1 = (list = p_35398_.m_45976_(Tofunian.class, aabb = this.m_20191_().m_82377_(10.0, 10.0, 10.0))).stream().filter(p_186293_ -> p_186293_.wantsToSpawnGolem(p_35398_, p_35399_) && p_186293_.getTofunianHome() != null).limit(5L).collect(Collectors.toList())).size() < p_35400_ || SpawnUtil.m_216403_((EntityType)((EntityType)TofuEntityTypes.TOFU_GOLEM.get()), (MobSpawnType)MobSpawnType.MOB_SUMMONED, (ServerLevel)p_35398_, (BlockPos)this.m_20183_(), (int)10, (int)8, (int)6, (SpawnUtil.Strategy)SpawnUtil.Strategy.f_216412_).isPresent()) {
            // empty if block
        }
    }

    private boolean wantsToSpawnGolem(ServerLevel p_35398_, long p_35399_) {
        AABB aabb = this.m_20191_().m_82377_(14.0, 14.0, 14.0);
        List list = p_35398_.m_45976_(TofuGolem.class, aabb);
        return list.isEmpty();
    }

    private void maybeDecayGossip() {
        long i = this.m_9236_().m_46467_();
        if (this.lastGossipDecay == 0L) {
            this.lastGossipDecay = i;
        } else if (i >= this.lastGossipDecay + 24000L) {
            this.gossips.m_26198_();
            this.lastGossipDecay = i;
        }
    }

    public GossipContainer getGossips() {
        return this.gossips;
    }

    public void setGossips(Tag p_35456_) {
        this.gossips.m_26177_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_35456_));
    }

    public float m_5610_(BlockPos p_27573_, LevelReader p_27574_) {
        return p_27574_.m_8055_(p_27573_.m_7495_()).m_60713_(Blocks.f_50440_) ? 10.0f : p_27574_.m_220419_(p_27573_);
    }

    protected Component m_5677_() {
        return Component.m_237115_((String)("entity.tofucraft.tofunian." + this.getRole().name().toLowerCase(Locale.ROOT)));
    }

    class TofunianAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final Tofunian tofunian;

        public TofunianAvoidEntityGoal(Tofunian p_30454_, Class<T> p_30455_, float p_30456_, double p_30457_, double p_30458_) {
            super((PathfinderMob)p_30454_, p_30455_, p_30456_, p_30457_, p_30458_);
            this.tofunian = p_30454_;
        }

        public void m_8056_() {
            this.tofunian.setAction(Actions.AVOID);
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
            this.tofunian.setAction(Actions.NORMAL);
        }
    }

    public static class GetItemGoal<T extends Tofunian>
    extends Goal {
        private final T mob;
        final /* synthetic */ Tofunian this$0;

        public GetItemGoal(T p_i50572_2_) {
            this.this$0 = this$0;
            this.mob = p_i50572_2_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            List list = this.mob.m_9236_().m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(4.0, 4.0, 4.0), ALLOWED_ITEMS);
            if (!list.isEmpty() && this.mob.m_142582_((Entity)list.get(0))) {
                return this.mob.m_21573_().m_5624_((Entity)list.get(0), 1.0);
            }
            return false;
        }
    }

    class MoveToGoal
    extends Goal {
        final Tofunian tofunian;
        final double stopDistance;
        final double speedModifier;

        MoveToGoal(Tofunian p_i50459_2_, double p_i50459_3_, double p_i50459_5_) {
            this.tofunian = p_i50459_2_;
            this.stopDistance = p_i50459_3_;
            this.speedModifier = p_i50459_5_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public void m_8041_() {
            Tofunian.this.f_21344_.m_26573_();
        }

        public boolean m_8036_() {
            BlockPos blockpos = this.tofunian.getTofunianHome();
            double distance = this.tofunian.m_9236_().m_46461_() ? this.stopDistance : this.stopDistance / 4.0;
            return blockpos != null && this.isTooFarAway(blockpos, distance);
        }

        public void m_8037_() {
            BlockPos blockpos = this.tofunian.getTofunianHome();
            if (blockpos != null && Tofunian.this.f_21344_.m_26571_()) {
                if (this.isTooFarAway(blockpos, 10.0)) {
                    Vec3 vector3d = new Vec3((double)blockpos.m_123341_() - this.tofunian.m_20185_(), (double)blockpos.m_123342_() - this.tofunian.m_20186_(), (double)blockpos.m_123343_() - this.tofunian.m_20189_()).m_82541_();
                    Vec3 vector3d1 = vector3d.m_82490_(10.0).m_82520_(this.tofunian.m_20185_(), this.tofunian.m_20186_(), this.tofunian.m_20189_());
                    Tofunian.this.f_21344_.m_26519_(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, this.speedModifier);
                } else {
                    Tofunian.this.f_21344_.m_26519_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPos p_220846_1_, double p_220846_2_) {
            return !p_220846_1_.m_123314_((Vec3i)this.tofunian.m_20183_(), p_220846_2_);
        }
    }

    public static enum TofunianType implements IExtensibleEnum
    {
        NORMAL,
        ZUNDA;


        public static TofunianType get(String nameIn) {
            for (TofunianType role : TofunianType.values()) {
                if (!role.name().equals(nameIn)) continue;
                return role;
            }
            return NORMAL;
        }

        public static TofunianType create(String name) {
            throw new IllegalStateException("Enum not extended");
        }
    }

    public static enum Roles implements IExtensibleEnum
    {
        TOFUCOOK(Roles.getBlockStates(Blocks.f_50715_)),
        TOFUSMITH(Roles.getBlockStates(Blocks.f_50620_)),
        SOYWORKER((Set)ImmutableList.of((Object)Blocks.f_50256_, (Object)Blocks.f_152477_, (Object)Blocks.f_152476_, (Object)Blocks.f_152478_).stream().flatMap(p_218093_ -> p_218093_.m_49965_().m_61056_().stream()).collect(ImmutableSet.toImmutableSet())),
        TOFUNIAN(Set.of());

        private static final Map<String, Roles> lookup;
        private final Set<BlockState> matchingStates;

        private Roles(Set<BlockState> matchingStates) {
            matchingStates = Set.copyOf(matchingStates);
            this.matchingStates = matchingStates;
        }

        public static Roles create(String name, Set<BlockState> poitype) {
            throw new IllegalStateException("Enum not extended");
        }

        public boolean is(BlockState p_148693_) {
            return this.matchingStates.contains(p_148693_);
        }

        private static Set<BlockState> getBlockStates(Block p_218074_) {
            return ImmutableSet.copyOf((Collection)p_218074_.m_49965_().m_61056_());
        }

        public static Roles get(String nameIn) {
            for (Roles role : Roles.values()) {
                if (!role.name().equals(nameIn)) continue;
                return role;
            }
            return TOFUNIAN;
        }

        @Nullable
        public static Roles getJob(BlockState blockState) {
            for (Roles role : Roles.values()) {
                if (role == TOFUNIAN || !role.is(blockState)) continue;
                return role;
            }
            return null;
        }

        static {
            lookup = Arrays.stream(Roles.values()).collect(Collectors.toMap(Enum::name, p_220362_0_ -> p_220362_0_));
        }
    }

    public static enum Actions implements IExtensibleEnum
    {
        NORMAL(true, -1),
        CRY(true, 80),
        AVOID(true, -1),
        SIT(true, -1),
        HAPPY(false, 30),
        WAVE(false, 25),
        EAT(true, -1);

        private final boolean loop;
        private final int tick;

        private Actions(boolean loop, int tick) {
            this.loop = loop;
            this.tick = tick;
        }

        public static Actions get(String nameIn) {
            for (Actions role : Actions.values()) {
                if (!role.name().equals(nameIn)) continue;
                return role;
            }
            return NORMAL;
        }

        public static Actions create(String name, boolean loop, int tick) {
            throw new IllegalStateException("Enum not extended");
        }
    }
}

