/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity.projectile;

import baguchan.tofucraft.compat.CompatHandler;
import baguchan.tofucraft.registry.TofuEntityTypes;
import baguchan.tofucraft.registry.TofuItems;
import baguchan.tofucraft.registry.TofuSounds;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class FukumameEntity
extends ThrowableProjectile {
    public float damage = 1.0f;
    private int totalHits;
    private static final EntityDataAccessor<Integer> BOUNCE_LEVEL = SynchedEntityData.m_135353_(FukumameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public FukumameEntity(EntityType<? extends FukumameEntity> p_i50154_1_, Level p_i50154_2_) {
        super(p_i50154_1_, p_i50154_2_);
    }

    public FukumameEntity(Level worldIn, LivingEntity throwerIn) {
        super((EntityType)TofuEntityTypes.FUKUMAME.get(), throwerIn, worldIn);
    }

    public FukumameEntity(Level worldIn, LivingEntity throwerIn, ItemStack stack) {
        super((EntityType)TofuEntityTypes.FUKUMAME.get(), throwerIn, worldIn);
        Optional resourceKey = ForgeRegistries.ENCHANTMENTS.getHolder(CompatHandler.HUNTERILLAGER_BOUNCE);
        if (resourceKey.isPresent()) {
            this.f_19804_.m_135381_(BOUNCE_LEVEL, (Object)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)((Holder)resourceKey.get()).get()), (ItemStack)stack));
        }
    }

    public FukumameEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)TofuEntityTypes.FUKUMAME.get(), x, y, z, worldIn);
    }

    public FukumameEntity(EntityType<? extends FukumameEntity> p_i50154_1_, Level worldIn, double x, double y, double z) {
        super(p_i50154_1_, x, y, z, worldIn);
    }

    public FukumameEntity(EntityType<? extends FukumameEntity> entityType, LivingEntity throwerIn, Level worldIn) {
        super(entityType, throwerIn, worldIn);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BOUNCE_LEVEL, (Object)0);
    }

    public void setBounceLevel(int bounceLevel) {
        this.f_19804_.m_135381_(BOUNCE_LEVEL, (Object)bounceLevel);
    }

    public int getBounceLevel() {
        return (Integer)this.f_19804_.m_135370_(BOUNCE_LEVEL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3) {
            double d0 = 0.08;
            for (int i = 0; i < 6; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)TofuItems.SEEDS_SOYBEANS.get())), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08);
            }
        }
    }

    protected void m_5790_(EntityHitResult p_37404_) {
        super.m_5790_(p_37404_);
        Entity entity = p_37404_.m_82443_();
        int i = 2;
        entity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.damage);
        entity.f_19802_ = 5;
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult p_37406_) {
        super.m_6532_(p_37406_);
        this.m_5496_((SoundEvent)TofuSounds.SOYBEAN_CRACK.get(), 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        BlockPos pos = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        BlockState blockstate = this.m_9236_().m_8055_(result.m_82425_());
        if (!blockstate.m_60812_((BlockGetter)this.m_9236_(), result.m_82425_()).m_83281_()) {
            Direction face = result.m_82434_();
            Vec3 motion = this.m_20184_();
            double motionX = motion.f_82479_;
            double motionY = motion.f_82480_;
            double motionZ = motion.f_82481_;
            if (face == Direction.EAST) {
                motionX = -motionX;
            } else if (face == Direction.SOUTH) {
                motionZ = -motionZ;
            } else if (face == Direction.WEST) {
                motionX = -motionX;
            } else if (face == Direction.NORTH) {
                motionZ = -motionZ;
            } else if (face == Direction.UP) {
                motionY = -motionY;
            } else if (face == Direction.DOWN) {
                motionY = -motionY;
            }
            this.m_20334_(motionX, motionY, motionZ);
        }
        if (this.totalHits >= this.getBounceLevel()) {
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_7605_((Entity)this, (byte)3);
                this.m_146870_();
            }
        } else {
            ++this.totalHits;
        }
    }

    public void m_7380_(CompoundTag p_37222_) {
        super.m_7380_(p_37222_);
        p_37222_.m_128350_("Damage", (float)((byte)this.damage));
        p_37222_.m_128405_("TotalHits", this.totalHits);
        p_37222_.m_128405_("BounceLevel", this.getBounceLevel());
    }

    public void m_7378_(CompoundTag p_37220_) {
        super.m_7378_(p_37220_);
        if (p_37220_.m_128425_("Damage", 99)) {
            this.damage = p_37220_.m_128457_("Damage");
        }
        this.totalHits = p_37220_.m_128451_("TotalHits");
        this.setBounceLevel(p_37220_.m_128451_("BounceLevel"));
    }
}

