/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.fluidtype;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class SoymilkSoulFluidType
extends FluidType {
    public SoymilkSoulFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public boolean isVaporizedOnPlacement(Level level, BlockPos pos, FluidStack stack) {
        return false;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation TEXTURE_STILL = new ResourceLocation("tofucraft", "block/soymilk_soul");
            private static final ResourceLocation TEXTURE_FLOW = new ResourceLocation("tofucraft", "block/soymilk_soul_flow");
            private static final ResourceLocation TEXTURE_OVERLAY = new ResourceLocation("tofucraft", "textures/block/soymilk_soul_overlay.png");

            public ResourceLocation getStillTexture() {
                return TEXTURE_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return TEXTURE_FLOW;
            }

            @Nullable
            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return TEXTURE_OVERLAY;
            }

            public void renderOverlay(Minecraft mc, PoseStack stack) {
                ResourceLocation texture = this.getRenderOverlayTexture(mc);
                if (texture == null) {
                    return;
                }
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
                BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
                BlockPos playerEyePos = BlockPos.m_274561_((double)mc.f_91074_.m_20185_(), (double)mc.f_91074_.m_20188_(), (double)mc.f_91074_.m_20189_());
                float brightness = LightTexture.m_234316_((DimensionType)mc.f_91074_.m_9236_().m_6042_(), (int)mc.f_91074_.m_9236_().m_46803_(playerEyePos));
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)0.85f);
                float uOffset = -mc.f_91074_.m_146908_() / 64.0f;
                float vOffset = mc.f_91074_.m_146909_() / 64.0f;
                Matrix4f pose = stack.m_85850_().m_252922_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                buffer.m_252986_(pose, -1.0f, -1.0f, -0.5f).m_7421_(4.0f + uOffset, 4.0f + vOffset).m_5752_();
                buffer.m_252986_(pose, 1.0f, -1.0f, -0.5f).m_7421_(uOffset, 4.0f + vOffset).m_5752_();
                buffer.m_252986_(pose, 1.0f, 1.0f, -0.5f).m_7421_(uOffset, vOffset).m_5752_();
                buffer.m_252986_(pose, -1.0f, 1.0f, -0.5f).m_7421_(4.0f + uOffset, vOffset).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
                RenderSystem.disableBlend();
            }
        });
    }
}

