/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.extensions.IForgeFriendlyByteBuf;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidIngredient
implements Predicate<FluidStack> {
    private static final Set<FluidIngredient> INSTANCES = Collections.newSetFromMap(new WeakHashMap());
    public static final FluidIngredient EMPTY = new FluidIngredient(Stream.empty());
    private final Value[] values;
    private FluidStack[] fluidStacks;
    private IntList stackingIds;

    public static void invalidateAll() {
        INSTANCES.stream().filter(e -> e != null).forEach(i -> i.invalidate());
    }

    protected FluidIngredient(Stream<? extends Value> p_43907_) {
        this.values = (Value[])p_43907_.toArray(Value[]::new);
        INSTANCES.add(this);
    }

    public FluidStack[] getFluids() {
        this.dissolve();
        return this.fluidStacks;
    }

    private void dissolve() {
        if (this.fluidStacks == null) {
            this.fluidStacks = (FluidStack[])Arrays.stream(this.values).flatMap(p_43916_ -> p_43916_.getFluids().stream()).distinct().toArray(FluidStack[]::new);
        }
    }

    @Override
    public boolean test(@Nullable FluidStack p_43914_) {
        if (p_43914_ == null) {
            return false;
        }
        this.dissolve();
        if (this.fluidStacks.length == 0) {
            return p_43914_.isEmpty();
        }
        for (FluidStack fluidstack : this.fluidStacks) {
            if (!p_43914_.containsFluid(fluidstack)) continue;
            return true;
        }
        return false;
    }

    public final void toNetwork(FriendlyByteBuf p_43924_) {
        this.dissolve();
        p_43924_.m_236828_(Arrays.asList(this.fluidStacks), IForgeFriendlyByteBuf::writeFluidStack);
    }

    public JsonElement toJson() {
        if (this.values.length == 1) {
            return this.values[0].serialize();
        }
        JsonArray jsonarray = new JsonArray();
        for (Value Fluidingredient$value : this.values) {
            jsonarray.add((JsonElement)Fluidingredient$value.serialize());
        }
        return jsonarray;
    }

    public boolean isEmpty() {
        return !(this.values.length != 0 || this.fluidStacks != null && this.fluidStacks.length != 0 || this.stackingIds != null && !this.stackingIds.isEmpty());
    }

    protected void invalidate() {
        this.fluidStacks = null;
        this.stackingIds = null;
    }

    public boolean isSimple() {
        return this == EMPTY;
    }

    public static FluidIngredient fromValues(Stream<? extends Value> p_43939_) {
        FluidIngredient Fluidingredient = new FluidIngredient(p_43939_);
        return Fluidingredient.values.length == 0 ? EMPTY : Fluidingredient;
    }

    public static FluidIngredient of() {
        return EMPTY;
    }

    public static FluidIngredient of(FluidStack ... p_43928_) {
        return FluidIngredient.of(Arrays.stream(p_43928_));
    }

    public static FluidIngredient of(Stream<FluidStack> p_43922_) {
        return FluidIngredient.fromValues(p_43922_.filter(p_43944_ -> !p_43944_.isEmpty()).map(FluidValue::new));
    }

    public static FluidIngredient of(TagKey<Fluid> p_43912_) {
        return FluidIngredient.fromValues(Stream.of(new TagValue(p_43912_)));
    }

    public static FluidIngredient fromNetwork(FriendlyByteBuf p_43941_) {
        int size = p_43941_.m_130242_();
        return FluidIngredient.fromValues(Stream.generate(() -> new FluidValue(p_43941_.readFluidStack())).limit(size));
    }

    public static FluidIngredient fromJson(@Nullable JsonElement p_43918_) {
        if (p_43918_ != null && !p_43918_.isJsonNull()) {
            if (p_43918_.isJsonObject()) {
                return FluidIngredient.fromValues(Stream.of(FluidIngredient.valueFromJson(p_43918_.getAsJsonObject())));
            }
            if (p_43918_.isJsonArray()) {
                JsonArray jsonarray = p_43918_.getAsJsonArray();
                return FluidIngredient.fromValues(StreamSupport.stream(jsonarray.spliterator(), false).map(p_151264_ -> FluidIngredient.valueFromJson(GsonHelper.m_13918_((JsonElement)p_151264_, (String)"fluid"))));
            }
            throw new JsonSyntaxException("Expected fluid to be object or array of objects");
        }
        throw new JsonSyntaxException("Fluid cannot be null");
    }

    public static FluidStack getFluidStack(JsonObject json, boolean readNBT) {
        String fluidName = GsonHelper.m_13906_((JsonObject)json, (String)"fluid");
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
        if (fluid == null) {
            throw new JsonSyntaxException("Unknown fluid '" + fluidName + "'");
        }
        return new FluidStack(fluid, 1000);
    }

    public static Value valueFromJson(JsonObject p_43920_) {
        if (p_43920_.has("fluid") && p_43920_.has("tag")) {
            throw new JsonParseException("An Fluidingredient entry is either a tag or an fluid, not both");
        }
        if (p_43920_.has("fluid")) {
            Fluid fluid = FluidIngredient.fluidFromJson(p_43920_);
            return new FluidValue(new FluidStack(fluid, 1000));
        }
        if (p_43920_.has("tag")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)p_43920_, (String)"tag"));
            TagKey tagkey = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)resourcelocation);
            return new TagValue((TagKey<Fluid>)tagkey);
        }
        throw new JsonParseException("An Fluidingredient entry needs either a tag or an fluid");
    }

    public static Fluid fluidFromJson(JsonObject p_151279_) {
        String s = GsonHelper.m_13906_((JsonObject)p_151279_, (String)"fluid");
        Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_6612_(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown fluid '" + s + "'"));
        if (fluid == Fluids.f_76191_) {
            throw new JsonSyntaxException("Invalid fluid: " + s);
        }
        return fluid;
    }

    public static FluidIngredient merge(Collection<FluidIngredient> parts) {
        return FluidIngredient.fromValues(parts.stream().flatMap(i -> Arrays.stream(i.values)));
    }

    public static interface Value {
        public Collection<FluidStack> getFluids();

        public JsonObject serialize();
    }

    public static class TagValue
    implements Value {
        private final TagKey<Fluid> tag;

        public TagValue(TagKey<Fluid> p_43961_) {
            this.tag = p_43961_;
        }

        @Override
        public Collection<FluidStack> getFluids() {
            ArrayList list = Lists.newArrayList();
            for (Holder holder : BuiltInRegistries.f_257020_.m_206058_(this.tag)) {
                list.add(new FluidStack((Fluid)holder.m_203334_(), 1000));
            }
            return list;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", this.tag.f_203868_().toString());
            return jsonobject;
        }
    }

    public static class FluidValue
    implements Value {
        private final FluidStack fluid;

        public FluidValue(FluidStack p_43953_) {
            this.fluid = p_43953_;
        }

        @Override
        public Collection<FluidStack> getFluids() {
            return Collections.singleton(this.fluid);
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("fluid", BuiltInRegistries.f_257020_.m_7981_((Object)this.fluid.getFluid()).toString());
            return jsonobject;
        }
    }
}

