/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.recipe;

import baguchan.tofucraft.recipe.TFCraftingCategory;
import baguchan.tofucraft.recipe.TFCraftingRecipe;
import baguchan.tofucraft.registry.TofuRecipes;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;

public class TFShapedRecipe
implements TFCraftingRecipe {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    final int width;
    final int height;
    final NonNullList<Ingredient> recipeItems;
    final ItemStack result;
    private final ResourceLocation id;
    final String group;
    final TFCraftingCategory category;
    final boolean showNotification;
    private final int tfNeed;

    public TFShapedRecipe(ResourceLocation p_273203_, String p_272759_, TFCraftingCategory p_273506_, int p_272952_, int p_272920_, NonNullList<Ingredient> p_273650_, ItemStack p_272852_, boolean p_273122_, int tfNeed) {
        this.id = p_273203_;
        this.group = p_272759_;
        this.category = p_273506_;
        this.width = p_272952_;
        this.height = p_272920_;
        this.recipeItems = p_273650_;
        this.result = p_272852_;
        this.showNotification = p_273122_;
        this.tfNeed = tfNeed;
    }

    public TFShapedRecipe(ResourceLocation p_250963_, String p_250221_, TFCraftingCategory p_250716_, int p_251480_, int p_251980_, NonNullList<Ingredient> p_252150_, ItemStack p_248581_, int tfNeed) {
        this(p_250963_, p_250221_, p_250716_, p_251480_, p_251980_, p_252150_, p_248581_, true, tfNeed);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TofuRecipes.RECIPE_TF_CRAFT_SHAPED.get();
    }

    public String m_6076_() {
        return this.group;
    }

    @Override
    public TFCraftingCategory category() {
        return this.category;
    }

    @Override
    public int getNeedTF() {
        return this.tfNeed;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    public ItemStack m_8043_(RegistryAccess p_266881_) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public boolean m_271738_() {
        return this.showNotification;
    }

    public boolean m_5818_(Container p_44002_, Level p_44003_) {
        for (int i = 0; i <= 3 - this.width; ++i) {
            for (int j = 0; j <= 3 - this.height; ++j) {
                if (this.matches(p_44002_, i, j, true)) {
                    return true;
                }
                if (!this.matches(p_44002_, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_8004_(int p_44161_, int p_44162_) {
        return p_44161_ >= this.width && p_44162_ >= this.height;
    }

    private boolean matches(Container p_44171_, int p_44172_, int p_44173_, boolean p_44174_) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int k = i - p_44172_;
                int l = j - p_44173_;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = p_44174_ ? (Ingredient)this.recipeItems.get(this.width - k - 1 + l * this.width) : (Ingredient)this.recipeItems.get(k + l * this.width);
                }
                if (ingredient.test(p_44171_.m_8020_(i + j * 3))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack m_5874_(Container p_266686_, RegistryAccess p_266725_) {
        return this.m_8043_(p_266725_).m_41777_();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    static NonNullList<Ingredient> dissolvePattern(String[] p_44203_, Map<String, Ingredient> p_44204_, int p_44205_, int p_44206_) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(p_44205_ * p_44206_), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(p_44204_.keySet());
        set.remove(" ");
        for (int i = 0; i < p_44203_.length; ++i) {
            for (int j = 0; j < p_44203_[i].length(); ++j) {
                String s = p_44203_[i].substring(j, j + 1);
                Ingredient ingredient = p_44204_.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + p_44205_ * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] shrink(String ... p_44187_) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < p_44187_.length; ++i1) {
            String s = p_44187_[i1];
            i = Math.min(i, TFShapedRecipe.firstNonSpace(s));
            int j1 = TFShapedRecipe.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (p_44187_.length == l) {
            return new String[0];
        }
        String[] astring = new String[p_44187_.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = p_44187_[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> nonnulllist = this.m_7527_();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(p_151277_ -> !p_151277_.m_43947_()).anyMatch(p_151273_ -> ForgeHooks.hasNoElements((Ingredient)p_151273_));
    }

    private static int firstNonSpace(String p_44185_) {
        int i;
        for (i = 0; i < p_44185_.length() && p_44185_.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String p_44201_) {
        int i;
        for (i = p_44201_.length() - 1; i >= 0 && p_44201_.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] patternFromJson(JsonArray p_44197_) {
        String[] astring = new String[p_44197_.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)p_44197_.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    static Map<String, Ingredient> keyFromJson(JsonObject p_44211_) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : p_44211_.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_288218_((JsonElement)((JsonElement)entry.getValue()), (boolean)false));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static ItemStack itemStackFromJson(JsonObject p_151275_) {
        return CraftingHelper.getItemStack((JsonObject)p_151275_, (boolean)true, (boolean)true);
    }

    public static Item itemFromJson(JsonObject p_151279_) {
        String s = GsonHelper.m_13906_((JsonObject)p_151279_, (String)"item");
        Item item = (Item)BuiltInRegistries.f_257033_.m_6612_(ResourceLocation.m_135820_((String)s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'"));
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Empty ingredient not allowed here");
        }
        return item;
    }

    public static class Serializer
    implements RecipeSerializer<TFShapedRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("minecraft", "crafting_shaped");

        public TFShapedRecipe fromJson(ResourceLocation p_44236_, JsonObject p_44237_) {
            String s = GsonHelper.m_13851_((JsonObject)p_44237_, (String)"group", (String)"");
            TFCraftingCategory craftingbookcategory = (TFCraftingCategory)TFCraftingCategory.CODEC.m_262792_(GsonHelper.m_13851_((JsonObject)p_44237_, (String)"category", (String)null), (Enum)TFCraftingCategory.MISC);
            Map<String, Ingredient> map = TFShapedRecipe.keyFromJson(GsonHelper.m_13930_((JsonObject)p_44237_, (String)"key"));
            String[] astring = TFShapedRecipe.shrink(TFShapedRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)p_44237_, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList<Ingredient> nonnulllist = TFShapedRecipe.dissolvePattern(astring, map, i, j);
            ItemStack itemstack = TFShapedRecipe.itemStackFromJson(GsonHelper.m_13930_((JsonObject)p_44237_, (String)"result"));
            boolean flag = GsonHelper.m_13855_((JsonObject)p_44237_, (String)"show_notification", (boolean)true);
            int tf = GsonHelper.m_13824_((JsonObject)p_44237_, (String)"tf", (int)0);
            return new TFShapedRecipe(p_44236_, s, craftingbookcategory, i, j, nonnulllist, itemstack, flag, tf);
        }

        public TFShapedRecipe fromNetwork(ResourceLocation p_44239_, FriendlyByteBuf p_44240_) {
            int i = p_44240_.m_130242_();
            int j = p_44240_.m_130242_();
            String s = p_44240_.m_130277_();
            TFCraftingCategory craftingbookcategory = (TFCraftingCategory)p_44240_.m_130066_(TFCraftingCategory.class);
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)p_44240_));
            }
            ItemStack itemstack = p_44240_.m_130267_();
            boolean flag = p_44240_.readBoolean();
            int tf = p_44240_.readInt();
            return new TFShapedRecipe(p_44239_, s, craftingbookcategory, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack, flag, tf);
        }

        public void toNetwork(FriendlyByteBuf p_44227_, TFShapedRecipe p_44228_) {
            p_44227_.m_130130_(p_44228_.width);
            p_44227_.m_130130_(p_44228_.height);
            p_44227_.m_130070_(p_44228_.group);
            p_44227_.m_130068_((Enum)p_44228_.category);
            for (Ingredient ingredient : p_44228_.recipeItems) {
                ingredient.m_43923_(p_44227_);
            }
            p_44227_.m_130055_(p_44228_.result);
            p_44227_.writeBoolean(p_44228_.showNotification);
            p_44227_.writeInt(p_44228_.tfNeed);
        }
    }
}

