/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.recipe;

import baguchan.tofucraft.recipe.IWorkRecipe;
import baguchan.tofucraft.registry.TofuRecipes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.Nullable;

public class TofuWorkStationRecipe
implements IWorkRecipe {
    protected final ResourceLocation id;
    protected Ingredient baseIngredient;
    protected Ingredient ingredient;
    protected Ingredient subIngredient;
    final ItemStack result;

    public TofuWorkStationRecipe(ResourceLocation id, Ingredient baseIngredient, Ingredient ingredient, Ingredient subIngredient, ItemStack results) {
        this.id = id;
        this.baseIngredient = baseIngredient;
        this.ingredient = ingredient;
        this.subIngredient = subIngredient;
        this.result = results;
    }

    public boolean m_5818_(Container p_266855_, Level p_266781_) {
        return this.hasAnyMatching(p_266855_);
    }

    private boolean hasAnyMatching(Container container) {
        boolean flag = false;
        boolean flag2 = false;
        boolean flag3 = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemstack = container.m_8020_(i);
            if (this.baseIngredient.test(itemstack)) {
                flag = true;
            }
            if (this.ingredient.test(itemstack)) {
                flag2 = true;
            }
            if (!this.subIngredient.test(itemstack)) continue;
            flag3 = true;
        }
        return flag && flag2 && flag3;
    }

    public ItemStack m_5874_(Container p_267036_, RegistryAccess p_266699_) {
        ItemStack itemstack = this.result.m_41777_();
        CompoundTag compoundtag = p_267036_.m_8020_(0).m_41783_();
        if (compoundtag != null) {
            itemstack.m_41751_(compoundtag.m_6426_());
        }
        return itemstack;
    }

    @Override
    public boolean isIngredient(ItemStack p_266982_) {
        return this.ingredient.test(p_266982_);
    }

    @Override
    public boolean isBaseIngredient(ItemStack p_266962_) {
        return this.baseIngredient.test(p_266962_);
    }

    @Override
    public boolean isSubIngredient(ItemStack p_267132_) {
        return this.subIngredient.test(p_267132_);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public Ingredient getSubIngredient() {
        return this.subIngredient;
    }

    public Ingredient getBaseIngredient() {
        return this.baseIngredient;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TofuRecipes.RECIPE_TOFU_WORK_STATION.get();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public RecipeType<?> m_6671_() {
        return (RecipeType)TofuRecipes.RECIPETYPE_TOFU_WORK_STATION.get();
    }

    public static class Serializer
    implements RecipeSerializer<TofuWorkStationRecipe> {
        public TofuWorkStationRecipe fromJson(ResourceLocation p_44103_, JsonObject p_44104_) {
            Ingredient base = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)p_44104_, (String)"base"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)p_44104_, (String)"ingredient"));
            Ingredient sub = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)p_44104_, (String)"sub"));
            ItemStack results = Serializer.itemStackFromJson(GsonHelper.m_13930_((JsonObject)p_44104_, (String)"result"));
            return new TofuWorkStationRecipe(p_44103_, base, ingredient1, sub, results);
        }

        public static ItemStack itemStackFromJson(JsonObject p_151275_) {
            return CraftingHelper.getItemStack((JsonObject)p_151275_, (boolean)false, (boolean)true);
        }

        @Nullable
        public TofuWorkStationRecipe fromNetwork(ResourceLocation p_44105_, FriendlyByteBuf p_44106_) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)p_44106_);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)p_44106_);
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)p_44106_);
            ItemStack itemstack = p_44106_.m_130267_();
            return new TofuWorkStationRecipe(p_44105_, ingredient, ingredient1, ingredient2, itemstack);
        }

        public void toNetwork(FriendlyByteBuf p_266746_, TofuWorkStationRecipe p_266927_) {
            p_266927_.baseIngredient.m_43923_(p_266746_);
            p_266927_.ingredient.m_43923_(p_266746_);
            p_266927_.subIngredient.m_43923_(p_266746_);
            p_266746_.m_130055_(p_266927_.result);
        }
    }
}

