/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.utils;

import baguchan.tofucraft.registry.TofuEnchantments;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;

public class TofuDiamondToolUtil {
    protected static BlockHitResult rayTrace(Level level, Player playerIn, boolean useLiquids) {
        float f = playerIn.m_146909_();
        float f1 = playerIn.m_146908_();
        double d0 = playerIn.m_20185_();
        double d1 = playerIn.m_20186_() + (double)playerIn.m_20192_();
        double d2 = playerIn.m_20189_();
        Vec3 vec3d = new Vec3(d0, d1, d2);
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = playerIn.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
        Vec3 vec3d1 = vec3d.m_82520_((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return level.m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.COLLIDER, !useLiquids ? ClipContext.Fluid.NONE : ClipContext.Fluid.ANY, (Entity)playerIn));
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(ItemStack stack, Level world, Player player, BlockPos origin, int width, int height, int depth) {
        return TofuDiamondToolUtil.calcAOEBlocks(stack, world, player, origin, width, height, depth, -1);
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(ItemStack stack, Level world, Player player, BlockPos origin, int width, int height, int depth, int distance) {
        int z;
        int y;
        int x;
        if (stack.m_41619_()) {
            return ImmutableList.of();
        }
        BlockState state = world.m_8055_(origin);
        if (state.m_60795_()) {
            return ImmutableList.of();
        }
        BlockHitResult mop = TofuDiamondToolUtil.rayTrace(world, player, true);
        if (!(mop != null && origin.equals((Object)mop.m_82425_()) || (mop = TofuDiamondToolUtil.rayTrace(world, player, false)) != null && origin.equals((Object)mop.m_82425_()))) {
            return ImmutableList.of();
        }
        BlockPos start = origin;
        switch (mop.m_82434_()) {
            case DOWN: 
            case UP: {
                Vec3i vec = player.m_6350_().m_122436_();
                x = vec.m_123341_() * height + vec.m_123343_() * width;
                y = mop.m_82434_().m_122421_().m_122540_() * -depth;
                z = vec.m_123341_() * width + vec.m_123343_() * height;
                start = start.m_7918_(-x / 2, 0, -z / 2);
                if (x % 2 == 0) {
                    if (x > 0 && mop.m_82450_().f_82479_ - (double)mop.m_82425_().m_123341_() > 0.5) {
                        start = start.m_7918_(1, 0, 0);
                    } else if (x < 0 && mop.m_82450_().f_82479_ - (double)mop.m_82425_().m_123341_() < 0.5) {
                        start = start.m_7918_(-1, 0, 0);
                    }
                }
                if (z % 2 != 0) break;
                if (z > 0 && mop.m_82450_().f_82481_ - (double)mop.m_82425_().m_123343_() > 0.5) {
                    start = start.m_7918_(0, 0, 1);
                    break;
                }
                if (z >= 0 || !(mop.m_82450_().f_82481_ - (double)mop.m_82425_().m_123343_() < 0.5)) break;
                start = start.m_7918_(0, 0, -1);
                break;
            }
            case NORTH: 
            case SOUTH: {
                x = width;
                y = height;
                z = mop.m_82434_().m_122421_().m_122540_() * -depth;
                start = start.m_7918_(-x / 2, -y / 2, 0);
                if (x % 2 == 0 && mop.m_82450_().f_82479_ - (double)mop.m_82425_().m_123341_() > 0.5) {
                    start = start.m_7918_(1, 0, 0);
                }
                if (y % 2 != 0 || !(mop.m_82450_().f_82480_ - (double)mop.m_82425_().m_123342_() > 0.5)) break;
                start = start.m_7918_(0, 1, 0);
                break;
            }
            case WEST: 
            case EAST: {
                x = mop.m_82434_().m_122421_().m_122540_() * -depth;
                y = height;
                z = width;
                start = start.m_7918_(0, -y / 2, -z / 2);
                if (y % 2 == 0 && mop.m_82450_().f_82480_ - (double)mop.m_82425_().m_123342_() > 0.5) {
                    start = start.m_7918_(0, 1, 0);
                }
                if (z % 2 != 0 || !(mop.m_82450_().f_82481_ - (double)mop.m_82425_().m_123343_() > 0.5)) break;
                start = start.m_7918_(0, 0, 1);
                break;
            }
            default: {
                z = 0;
                y = 0;
                x = 0;
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int xp = start.m_123341_(); xp != start.m_123341_() + x; xp += x / Mth.m_14040_((int)x)) {
            for (int yp = start.m_123342_(); yp != start.m_123342_() + y; yp += y / Mth.m_14040_((int)y)) {
                for (int zp = start.m_123343_(); zp != start.m_123343_() + z; zp += z / Mth.m_14040_((int)z)) {
                    if (xp == origin.m_123341_() && yp == origin.m_123342_() && zp == origin.m_123343_() || distance > 0 && Mth.m_14040_((int)(xp - origin.m_123341_())) + Mth.m_14040_((int)(yp - origin.m_123342_())) + Mth.m_14040_((int)(zp - origin.m_123343_())) > distance) continue;
                    builder.add((Object)new BlockPos(xp, yp, zp));
                }
            }
        }
        return builder.build();
    }

    public static void onBlockStartBreak(ItemStack stack, Level level, Block blockDestroyed, BlockPos pos, Player owner) {
        int lvl = EnchantmentHelper.m_44836_((Enchantment)TofuEnchantments.BATCH.get(), (LivingEntity)owner);
        if (lvl > 0) {
            ImmutableList<BlockPos> poses = TofuDiamondToolUtil.calcAOEBlocks(stack, level, owner, pos, 1 + lvl * 2, 1 + lvl * 2, lvl);
            for (BlockPos extraPos : poses) {
                TofuDiamondToolUtil.breakExtraBlock(stack, owner.m_9236_(), owner, extraPos, pos);
            }
        }
    }

    private static boolean canBreakExtraBlock(ItemStack stack, Level world, Player player, BlockPos pos, BlockPos refPos) {
        if (world.m_46859_(pos)) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (stack.m_41691_(state) <= 1.0f) {
            return false;
        }
        BlockState refState = world.m_8055_(refPos);
        FluidState fluidState = world.m_6425_(refPos);
        float refStrength = refState.m_60800_((BlockGetter)world, refPos);
        float strength = state.m_60800_((BlockGetter)world, pos);
        if (!ForgeHooks.canEntityDestroy((Level)world, (BlockPos)pos, (LivingEntity)player) || refStrength / strength > 10.0f) {
            return false;
        }
        if (player.m_7500_()) {
            block.m_5707_(world, pos, state, player);
            if (block.onDestroyedByPlayer(state, world, pos, player, false, fluidState)) {
                block.m_6786_((LevelAccessor)world, pos, state);
            }
            if (!world.m_5776_() && player instanceof ServerPlayer && ((ServerPlayer)player).f_8906_ != null) {
                ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
            }
            return false;
        }
        return true;
    }

    public static void breakExtraBlock(ItemStack stack, Level level, Player player, BlockPos pos, BlockPos refPos) {
        if (!TofuDiamondToolUtil.canBreakExtraBlock(stack, level, player, pos, refPos) || level.m_8055_(pos).m_60734_() != level.m_8055_(refPos).m_60734_()) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        FluidState fluidState = level.m_6425_(refPos);
        Block block = state.m_60734_();
        stack.m_41686_(level, state, pos, player);
        if (!level.m_5776_()) {
            int xp = ForgeHooks.onBlockBreakEvent((Level)level, (GameType)((ServerPlayer)player).f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos);
            if (xp == -1) {
                return;
            }
            BlockEntity tileEntity = level.m_7702_(pos);
            if (block.onDestroyedByPlayer(state, level, pos, player, true, fluidState)) {
                block.m_6786_((LevelAccessor)level, pos, state);
                block.m_6240_(level, player, pos, state, tileEntity, stack);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    block.m_49805_(serverLevel, pos, xp);
                }
            }
            if (((ServerPlayer)player).f_8906_ != null) {
                ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            }
        } else {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            if (block.onDestroyedByPlayer(state, level, pos, player, true, fluidState)) {
                block.m_6786_((LevelAccessor)level, pos, state);
            }
            stack.m_41686_(level, state, pos, player);
            if (stack.m_41613_() == 0 && stack == player.m_21205_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)stack, (InteractionHand)InteractionHand.MAIN_HAND);
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
            ClientPacketListener netHandlerPlayClient = Minecraft.m_91087_().m_91403_();
            assert (netHandlerPlayClient != null);
            netHandlerPlayClient.m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, pos, Minecraft.m_91087_().f_91075_.m_6350_()));
        }
    }
}

