/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.world;

import baguchan.tofucraft.TofuCraftReload;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.apache.logging.log4j.Logger;

public class TofuData
extends SavedData {
    private static final String IDENTIFIER = "tofucraft_world_data";
    private int travelerSpawnDelay;
    private float travelerSpawnChance;
    private UUID travelerUUID;
    private static Map<Level, TofuData> dataMap = new HashMap<Level, TofuData>();
    public final List<BoundingBox> beatenDungeons = new ArrayList<BoundingBox>();

    public static TofuData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            TofuData fromMap = dataMap.get(serverLevel);
            if (fromMap == null) {
                DimensionDataStorage storage = serverLevel.m_8895_();
                TofuData data = (TofuData)storage.m_164861_(TofuData::load, TofuData::new, IDENTIFIER);
                if (data != null) {
                    data.m_77762_();
                }
                dataMap.put(world, data);
                return data;
            }
            return fromMap;
        }
        return null;
    }

    public static TofuData load(CompoundTag nbt) {
        TofuData data = new TofuData();
        if (nbt.m_128425_("TravelerSpawnDelay", 99)) {
            data.travelerSpawnDelay = nbt.m_128451_("TravelerSpawnDelay");
        }
        if (nbt.m_128425_("TravelerSpawnChance", 99)) {
            data.travelerSpawnChance = nbt.m_128457_("TravelerSpawnChance");
        }
        if (nbt.m_128425_("TravelerUUID", 8)) {
            data.travelerUUID = UUID.fromString(nbt.m_128461_("TravelerUUID"));
        }
        if (nbt.m_128441_("DungeonsBoxes")) {
            data.beatenDungeons.add((BoundingBox)BoundingBox.f_162354_.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("DungeonsBoxes")).resultOrPartial(arg_0 -> ((Logger)TofuCraftReload.LOGGER).error(arg_0)).orElseThrow(() -> new IllegalArgumentException("Invalid saved Dungeons boundingbox")));
        }
        return data;
    }

    public int getTravelerSpawnDelay() {
        return this.travelerSpawnDelay;
    }

    public void setTravelerSpawnDelay(int delay) {
        this.travelerSpawnDelay = delay;
    }

    public float getTravelerSpawnChance() {
        return this.travelerSpawnChance;
    }

    public void setTravelerSpawnChance(float chance) {
        this.travelerSpawnChance = chance;
    }

    public void setTravelerUUID(UUID id) {
        this.travelerUUID = id;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128405_("TravelerSpawnDelay", this.travelerSpawnDelay);
        compound.m_128350_("TravelerSpawnChance", this.travelerSpawnChance);
        if (this.travelerUUID != null) {
            compound.m_128359_("TravelerUUID", this.travelerUUID.toString());
        }
        if (!this.beatenDungeons.isEmpty()) {
            for (BoundingBox box : this.beatenDungeons) {
                BoundingBox.f_162354_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)box).resultOrPartial(arg_0 -> ((Logger)TofuCraftReload.LOGGER).error(arg_0)).ifPresent(p_163579_ -> compound.m_128365_("DungeonsBoxes", p_163579_));
            }
        }
        return compound;
    }

    public void addBeatenDungeons(BoundingBox box) {
        this.beatenDungeons.add(box);
        this.m_77762_();
    }

    public List<BoundingBox> getBeatenDungeons() {
        return this.beatenDungeons;
    }
}

