/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft;

import baguchi.tofucraft.attachment.SoyHealthAttachment;
import baguchi.tofucraft.attachment.TofuLivingAttachment;
import baguchi.tofucraft.attachment.TofuPlayerAttachment;
import baguchi.tofucraft.block.utils.SoymilkCauldronBlock;
import baguchi.tofucraft.entity.OageCube;
import baguchi.tofucraft.entity.ShuDofuSpiderPart;
import baguchi.tofucraft.entity.projectile.UnstableZundamaEntity;
import baguchi.tofucraft.item.TofuBookItem;
import baguchi.tofucraft.item.armor.BreakableTofuBootsItem;
import baguchi.tofucraft.network.AddLearningPacket;
import baguchi.tofucraft.registry.TofuAdvancements;
import baguchi.tofucraft.registry.TofuAttachments;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuDamageTypes;
import baguchi.tofucraft.registry.TofuDataComponents;
import baguchi.tofucraft.registry.TofuDimensions;
import baguchi.tofucraft.registry.TofuEffects;
import baguchi.tofucraft.registry.TofuEnchantments;
import baguchi.tofucraft.registry.TofuItems;
import baguchi.tofucraft.registry.TofuParticleTypes;
import baguchi.tofucraft.registry.TofuPoiTypes;
import baguchi.tofucraft.registry.TofuRecipes;
import baguchi.tofucraft.registry.TofuStructures;
import baguchi.tofucraft.registry.TofuTags;
import baguchi.tofucraft.utils.ContainerUtils;
import baguchi.tofucraft.utils.JigsawHelper;
import baguchi.tofucraft.utils.RecipeHelper;
import baguchi.tofucraft.utils.TofuDiamondToolUtil;
import baguchi.tofucraft.world.TofuData;
import baguchi.tofucraft.world.TofuLevelData;
import baguchi.tofucraft.world.TravelerTofunianSpawner;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.equine.AbstractHorse;
import net.minecraft.world.entity.animal.fox.Fox;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMobGriefingEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDestroyBlockEvent;
import net.neoforged.neoforge.event.entity.living.LivingUseTotemEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.SweepAttackEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.village.VillageSiegeEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="tofucraft")
public class CommonEvents {
    private static final Map<ServerLevel, TravelerTofunianSpawner> TRAVELER_TOFUNIAN_SPAWNER_MAP = new HashMap<ServerLevel, TravelerTofunianSpawner>();

    @SubscribeEvent
    public static void handleQuestSyncing(OnDatapackSyncEvent event) {
        event.sendRecipes(new RecipeType[]{TofuRecipes.RECIPETYPE_TF_CRAFT.get()});
        event.sendRecipes(new RecipeType[]{TofuRecipes.RECIPETYPE_TOFU_POT.get()});
        event.sendRecipes(new RecipeType[]{TofuRecipes.RECIPETYPE_BITTERN.get()});
        event.sendRecipes(new RecipeType[]{TofuRecipes.RECIPETYPE_HARDER.get()});
    }

    @SubscribeEvent
    public static void progressAdvancement(AdvancementEvent.AdvancementProgressEvent event) {
        Player player = event.getEntity();
        TofuPlayerAttachment attachment2 = (TofuPlayerAttachment)player.getData(TofuAttachments.TOFU_PLAYER);
        attachment2.trackDiscoveries(player, event.getAdvancement());
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        TofuPlayerAttachment attachment = (TofuPlayerAttachment)player.getData(TofuAttachments.TOFU_PLAYER);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            attachment.getLearning().forEach(learning -> PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new AddLearningPacket(serverPlayer.getId(), ((ResourceKey)learning.unwrap().left().get()).identifier(), false), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    @SubscribeEvent
    public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        TofuPlayerAttachment attachment = (TofuPlayerAttachment)player.getData(TofuAttachments.TOFU_PLAYER);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            attachment.getLearning().forEach(learning -> PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new AddLearningPacket(serverPlayer.getId(), ((ResourceKey)learning.unwrap().left().get()).identifier(), false), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    @SubscribeEvent
    public static void onRespawnDimension(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        TofuPlayerAttachment attachment = (TofuPlayerAttachment)player.getData(TofuAttachments.TOFU_PLAYER);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            attachment.getLearning().forEach(learning -> PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new AddLearningPacket(serverPlayer.getId(), ((ResourceKey)learning.unwrap().left().get()).identifier(), false), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    @SubscribeEvent
    public static void onSweep(SweepAttackEvent event) {
        Entity target = event.getTarget();
        Player player = event.getEntity();
        if ((player.getWeaponItem().is(TofuItems.TOFU_KINU_SWORD) || player.getWeaponItem().is(TofuItems.TOFU_MOMEN_SWORD)) && event.isSweeping()) {
            DamageSource damagesource = Optional.ofNullable(player.getWeaponItem().getItem().getItemDamageSource((LivingEntity)player)).orElse(player.damageSources().playerAttack(player));
            float f = (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE);
            float f2 = player.getAttackStrengthScale(0.5f);
            f += player.getWeaponItem().getItem().getAttackDamageBonus(target, f, damagesource);
            float f6 = 0.1f + (float)player.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) * f;
            for (LivingEntity livingentity2 : player.level().getEntitiesOfClass(LivingEntity.class, player.getWeaponItem().getSweepHitBox(player, target))) {
                ServerLevel serverlevel;
                Level level;
                ArmorStand armorstand;
                float f3;
                Level level2 = player.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    f3 = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)player.getWeaponItem(), (Entity)livingentity2, (DamageSource)damagesource, (float)f);
                } else {
                    f3 = f;
                }
                float f1 = f3;
                f += f1;
                f *= 0.2f + f2 * f2 * 0.8f;
                double entityReachSq = Mth.square((double)player.entityInteractionRange());
                if (livingentity2 == player || livingentity2 == target || player.isAlliedTo((Entity)livingentity2) || livingentity2 instanceof ArmorStand && (armorstand = (ArmorStand)livingentity2).isMarker() || !(player.distanceToSqr((Entity)livingentity2) < entityReachSq) || !((level = player.level()) instanceof ServerLevel) || !livingentity2.hurtServer(serverlevel = (ServerLevel)level, damagesource, f6)) continue;
                livingentity2.knockback((double)0.4f, (double)Mth.sin((double)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((double)(player.getYRot() * ((float)Math.PI / 180)))));
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)livingentity2, (DamageSource)damagesource);
            }
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
            double d0 = -Mth.sin((double)(player.getYRot() * ((float)Math.PI / 180)));
            double d1 = Mth.cos((double)(player.getYRot() * ((float)Math.PI / 180)));
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, player.getX() + d0, player.getY(0.5), player.getZ() + d1, 0, d0, 0.0, d1, 0.0);
            }
            event.setSweeping(false);
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingDamageEvent.Post event) {
        TofuLivingAttachment attachment = (TofuLivingAttachment)event.getEntity().getData(TofuAttachments.TOFU_LIVING.get());
        if (event.getEntity().hasEffect(TofuEffects.HEART_RECOVER) && attachment.getRecoverHealth() <= event.getNewDamage()) {
            attachment.setRecoverHealth((Entity)event.getEntity(), event.getNewDamage());
        }
    }

    @SubscribeEvent
    public static void onUpdate(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        SoyHealthAttachment soyHealth = (SoyHealthAttachment)entity.getData(TofuAttachments.SOY_HEALTH);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!entity.level().isClientSide()) {
                soyHealth.tick(livingEntity);
            }
        }
        TofuLivingAttachment tofuLivingAttachment = (TofuLivingAttachment)entity.getData(TofuAttachments.TOFU_LIVING);
        tofuLivingAttachment.tick(entity);
    }

    protected static BlockHitResult getPlayerPOVHitResult(Level p_41436_, Player p_41437_, ClipContext.Fluid p_41438_) {
        Vec3 vec3 = p_41437_.getEyePosition();
        Vec3 vec31 = vec3.add(p_41437_.calculateViewVector(p_41437_.getXRot(), p_41437_.getYRot()).scale(p_41437_.blockInteractionRange()));
        return p_41436_.clip(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, p_41438_, (Entity)p_41437_));
    }

    @SubscribeEvent
    public static void onUsedEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        Entity entity = event.getTarget();
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            if (stack.is((Item)TofuItems.SALT.get())) {
                horse.addEffect(new MobEffectInstance(TofuEffects.SALT_BOOST, 3600));
                if (!event.getEntity().isCreative()) {
                    stack.shrink(1);
                }
                horse.eating();
                horse.gameEvent((Holder)GameEvent.EAT);
                horse.playSound(SoundEvents.HORSE_EAT);
                event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onUsed(PlayerInteractEvent.RightClickItem event) {
        InteractionHand handIn;
        Level level = event.getLevel();
        Player playerIn = event.getEntity();
        ItemStack itemstack = playerIn.getItemInHand(handIn = event.getHand());
        if (itemstack.is(TofuTags.Items.BITTERN)) {
            BlockHitResult blockraytraceresult = CommonEvents.getPlayerPOVHitResult(level, playerIn, ClipContext.Fluid.SOURCE_ONLY);
            BlockHitResult blockraytraceresult1 = blockraytraceresult.withPosition(blockraytraceresult.getBlockPos());
            if (level instanceof ServerLevel) {
                FluidState fluidState;
                ItemStack result;
                ServerLevel serverLevel = (ServerLevel)level;
                if (blockraytraceresult.getType() == HitResult.Type.BLOCK && (result = RecipeHelper.getBitternResult(serverLevel, (fluidState = level.getFluidState(blockraytraceresult1.getBlockPos())).getType(), itemstack.copyWithCount(1))) != null) {
                    if (playerIn instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                        CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, blockraytraceresult1.getBlockPos(), itemstack);
                    }
                    level.setBlock(blockraytraceresult1.getBlockPos(), Block.byItem((Item)result.getItem()).defaultBlockState(), 11);
                    level.levelEvent(2001, blockraytraceresult1.getBlockPos(), Block.getId((BlockState)level.getBlockState(blockraytraceresult1.getBlockPos())));
                    level.playSound(null, blockraytraceresult1.getBlockPos(), SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    ContainerUtils.addWithContainer(playerIn, handIn, itemstack, new ItemStack((ItemLike)Items.GLASS_BOTTLE), false);
                    playerIn.swing(handIn);
                    event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockUsed(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemstack2;
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        if (stack.is((Item)TofuItems.BUCKET_SOYMILK.get()) && stack.is((Item)TofuItems.BUCKET_SOYMILK.get()) && level.getBlockState(event.getPos()).is(Blocks.CAULDRON)) {
            level.setBlock(event.getPos(), ((SoymilkCauldronBlock)((Object)TofuBlocks.SOYMILK_CAULDRON.get())).defaultBlockState(), 2);
            event.getEntity().playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
            itemstack2 = new ItemStack((ItemLike)Items.BUCKET);
            if (!event.getEntity().isCreative()) {
                stack.shrink(1);
            }
            if (stack.isEmpty()) {
                event.getEntity().setItemInHand(event.getHand(), itemstack2);
            } else if (!event.getEntity().isCreative() && !event.getEntity().getInventory().add(itemstack2)) {
                event.getEntity().drop(itemstack2, false);
            }
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        if (stack.is((Item)TofuItems.BUCKET_SOYMILK_NETHER.get()) && level.getBlockState(event.getPos()).is(Blocks.CAULDRON)) {
            level.setBlock(event.getPos(), ((SoymilkCauldronBlock)((Object)TofuBlocks.SOYMILK_NETHER_CAULDRON.get())).defaultBlockState(), 2);
            event.getEntity().playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
            itemstack2 = new ItemStack((ItemLike)Items.BUCKET);
            if (!event.getEntity().isCreative()) {
                stack.shrink(1);
            }
            if (stack.isEmpty()) {
                event.getEntity().setItemInHand(event.getHand(), itemstack2);
            } else if (!event.getEntity().isCreative() && !event.getEntity().getInventory().add(itemstack2)) {
                event.getEntity().drop(itemstack2, false);
            }
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        if (stack.is((Item)TofuItems.BUCKET_SOYMILK_SOUL.get()) && level.getBlockState(event.getPos()).is(Blocks.CAULDRON)) {
            level.setBlock(event.getPos(), ((SoymilkCauldronBlock)((Object)TofuBlocks.SOYMILK_SOUL_CAULDRON.get())).defaultBlockState(), 2);
            event.getEntity().playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
            itemstack2 = new ItemStack((ItemLike)Items.BUCKET);
            if (!event.getEntity().isCreative()) {
                stack.shrink(1);
            }
            if (stack.isEmpty()) {
                event.getEntity().setItemInHand(event.getHand(), itemstack2);
            } else if (!event.getEntity().isCreative() && !event.getEntity().getInventory().add(itemstack2)) {
                event.getEntity().drop(itemstack2, false);
            }
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
        TofuBookItem.interactWithBlock(event);
    }

    @SubscribeEvent
    public static void onBreakingSpeed(PlayerEvent.BreakSpeed event) {
        ItemEnchantments enchantments;
        ItemStack stack = event.getEntity().getMainHandItem();
        if (stack.is(TofuTags.Items.TOFU_DIAMOND_MINEABLE_ENCHANTABLE) && (enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)) != null) {
            event.setNewSpeed(event.getOriginalSpeed() / ((float)enchantments.getLevel((Holder)event.getEntity().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(TofuEnchantments.BATCH)) + 1.25f));
        }
    }

    @SubscribeEvent
    public static void onBlockDestroyByEntity(LivingDestroyBlockEvent event) {
        ServerLevel serverLevel;
        Structure structure;
        Level world = event.getEntity().level();
        if (world instanceof ServerLevel && (structure = (Structure)(serverLevel = (ServerLevel)world).registryAccess().lookupOrThrow(Registries.STRUCTURE).getValueOrThrow(TofuStructures.TOFU_CASTLE)) != null) {
            TofuData data = TofuData.get((Level)serverLevel);
            Vec3 center = event.getEntity().position();
            StructureStart structureStart = serverLevel.structureManager().getStructureAt(new BlockPos((int)center.x, (int)center.y, (int)center.z), structure);
            if (structureStart.isValid() && !data.getBeatenDungeons().contains(structureStart.getBoundingBox())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockGriefing(EntityMobGriefingEvent event) {
        ServerLevel serverLevel;
        Structure structure;
        Entity entity = event.getEntity();
        Level world = event.getEntity().level();
        if (world instanceof ServerLevel && (structure = (Structure)(serverLevel = (ServerLevel)world).registryAccess().lookupOrThrow(Registries.STRUCTURE).getValueOrThrow(TofuStructures.TOFU_CASTLE)) != null) {
            TofuData data = TofuData.get((Level)serverLevel);
            Vec3 center = event.getEntity().position();
            StructureStart structureStart = serverLevel.structureManager().getStructureAt(new BlockPos((int)center.x, (int)center.y, (int)center.z), structure);
            if (structureStart.isValid() && !data.getBeatenDungeons().contains(structureStart.getBoundingBox())) {
                event.setCanGrief(false);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreaked(BlockEvent.BreakEvent event) {
        ServerLevel serverLevel;
        Structure structure;
        Level world;
        if (event.getPlayer() instanceof ServerPlayer && (world = event.getPlayer().level()) instanceof ServerLevel && (structure = (Structure)(serverLevel = (ServerLevel)world).registryAccess().lookupOrThrow(Registries.STRUCTURE).getValueOrThrow(TofuStructures.TOFU_CASTLE)) != null) {
            ServerPlayer player;
            TofuData data = TofuData.get((Level)serverLevel);
            StructureStart structureStart = serverLevel.structureManager().getStructureAt(event.getPos(), structure);
            if (structureStart.isValid() && !data.getBeatenDungeons().contains(structureStart.getBoundingBox()) && !(player = (ServerPlayer)event.getPlayer()).isCreative() && !(event.getState().getBlock() instanceof TorchBlock)) {
                player.displayClientMessage((Component)Component.translatable((String)"tofucraft.need_defeat_boss"), true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        ServerLevel serverLevel;
        Structure structure;
        Level world;
        if (event.getEntity() instanceof ServerPlayer && (world = event.getEntity().level()) instanceof ServerLevel && (structure = (Structure)(serverLevel = (ServerLevel)world).registryAccess().lookupOrThrow(Registries.STRUCTURE).getValueOrThrow(TofuStructures.TOFU_CASTLE)) != null) {
            ServerPlayer player;
            TofuData data = TofuData.get((Level)serverLevel);
            StructureStart structureStart = serverLevel.structureManager().getStructureAt(event.getPos(), structure);
            if (structureStart.isValid() && !data.getBeatenDungeons().contains(structureStart.getBoundingBox()) && !(player = (ServerPlayer)event.getEntity()).isCreative() && !(event.getState().getBlock() instanceof TorchBlock)) {
                player.displayClientMessage((Component)Component.translatable((String)"tofucraft.need_defeat_boss"), true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onCheckSpawn(FinalizeSpawnEvent event) {
        Optional optional;
        Mob livingEntity = event.getEntity();
        ServerLevelAccessor level = event.getLevel();
        if (livingEntity instanceof Enemy && event.getSpawnType() != EntitySpawnReason.SPAWNER && event.getSpawnType() != EntitySpawnReason.TRIAL_SPAWNER && event.getSpawnType() != EntitySpawnReason.EVENT && event.getSpawnType() != EntitySpawnReason.BREEDING && event.getSpawnType() != EntitySpawnReason.PATROL && level instanceof ServerLevel && (optional = ((ServerLevel)level).getPoiManager().findClosest(p_184069_ -> p_184069_.is(TofuPoiTypes.MORIJIO), p_184055_ -> true, livingEntity.blockPosition(), 32, PoiManager.Occupancy.ANY)).isPresent()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCheckZombieSiege(VillageSiegeEvent event) {
        Optional optional;
        Vec3 vec3 = event.getAttemptedSpawnPos();
        Level level = event.getLevel();
        if (level instanceof ServerLevel && (optional = ((ServerLevel)level).getPoiManager().findClosest(p_184069_ -> p_184069_.is(TofuPoiTypes.MORIJIO), p_184055_ -> true, BlockPos.containing((Position)vec3), 32, PoiManager.Occupancy.ANY)).isPresent()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).dimensionTypeRegistration().is(TofuDimensions.tofu_world.identifier())) {
            TofuLevelData levelData = new TofuLevelData(level.getServer().getWorldData(), level.getServer().getWorldData().overworldData());
            level.serverLevelData = levelData;
            level.levelData = levelData;
        }
    }

    @SubscribeEvent
    public static void onServerTick(LevelTickEvent.Post tick) {
        Level level;
        if (!tick.getLevel().isClientSide() && (level = tick.getLevel()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            TRAVELER_TOFUNIAN_SPAWNER_MAP.computeIfAbsent(serverWorld, k -> new TravelerTofunianSpawner(serverWorld));
            TravelerTofunianSpawner spawner = TRAVELER_TOFUNIAN_SPAWNER_MAP.get(serverWorld);
            spawner.tick();
        }
    }

    @SubscribeEvent
    public static void onServerAboutToStartEvent(ServerStartedEvent event) {
        JigsawHelper.registerJigsaw(event.getServer(), Identifier.parse((String)"minecraft:village/plains/houses"), Identifier.parse((String)"tofucraft:village/tofu_craftsman_house_plains_1"), 10);
        JigsawHelper.registerJigsaw(event.getServer(), Identifier.parse((String)"minecraft:village/taiga/houses"), Identifier.parse((String)"tofucraft:village/tofu_craftsman_house_taiga_1"), 10);
        JigsawHelper.registerJigsaw(event.getServer(), Identifier.parse((String)"minecraft:village/savanna/houses"), Identifier.parse((String)"tofucraft:village/tofu_craftsman_house_savanna_1"), 10);
        JigsawHelper.registerJigsaw(event.getServer(), Identifier.parse((String)"minecraft:village/snowy/houses"), Identifier.parse((String)"tofucraft:village/tofu_craftsman_house_snowy_1"), 10);
        JigsawHelper.registerJigsaw(event.getServer(), Identifier.parse((String)"minecraft:village/desert/houses"), Identifier.parse((String)"tofucraft:village/tofu_craftsman_house_desert_1"), 10);
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player playerEntity = event.getEntity();
        if (!playerEntity.level().isClientSide()) {
            playerEntity.syncData(TofuAttachments.TOFU_LIVING);
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!entity.level().isClientSide()) {
                livingEntity.syncData(TofuAttachments.TOFU_LIVING);
            }
        }
        if (entity instanceof Fox) {
            Fox fox = (Fox)entity;
            if (!entity.level().isClientSide()) {
                fox.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)fox, OageCube.class, 10, false, false, (p_393134_, p_393135_) -> true));
            }
        }
    }

    @SubscribeEvent
    public static void onTotem(LivingUseTotemEvent event) {
        if (event.getTotem().is(TofuItems.ZUNDA_TOTEM)) {
            event.getEntity().setHealth(2.0f);
            ((TofuLivingAttachment)event.getEntity().getData(TofuAttachments.TOFU_LIVING.get())).setRecoverHealth((Entity)event.getEntity(), 20.0f);
            event.getEntity().level().explode((Entity)event.getEntity(), event.getEntity().damageSources().source(TofuDamageTypes.ZUNDA_EXPLOSION, (Entity)event.getEntity()), UnstableZundamaEntity.EXPLOSION_DAMAGE_CALCULATOR, event.getEntity().position().x(), event.getEntity().position().y(), event.getEntity().position().z(), 3.0f, false, Level.ExplosionInteraction.MOB, (ParticleOptions)TofuParticleTypes.ZUNDA_EXPLOSION.get(), (ParticleOptions)TofuParticleTypes.ZUNDA_EMIT.get(), WeightedList.builder().add((Object)new ExplosionParticleInfo((ParticleOptions)TofuParticleTypes.ZUNDA_CLOUD.get(), 4.0f, 1.0f)).build(), (Holder)SoundEvents.GENERIC_EXPLODE);
        }
    }

    @SubscribeEvent
    public static void onFall(LivingDamageEvent.Post event) {
        Item item;
        float damage = event.getNewDamage();
        LivingEntity entity = event.getEntity();
        ItemStack feet = entity.getItemBySlot(EquipmentSlot.FEET);
        if (event.getSource().is(DamageTypeTags.IS_FALL) && (item = feet.getItem()) instanceof BreakableTofuBootsItem) {
            BreakableTofuBootsItem bootsItem = (BreakableTofuBootsItem)item;
            int unstability = (Integer)feet.getOrDefault((DataComponentType)TofuDataComponents.UNSTABILITY.get(), (Object)0);
            if (damage + (float)unstability < (float)((Integer)feet.getOrDefault((DataComponentType)TofuDataComponents.MAX_FALL_DURABILITY.get(), (Object)0)).intValue()) {
                feet.set((DataComponentType)TofuDataComponents.UNSTABILITY.get(), (Object)(Mth.ceil((float)(damage + 1.0f)) + unstability));
            } else {
                feet.hurtAndBreak(10, entity, EquipmentSlot.FEET);
                entity.playSound(SoundEvents.SLIME_BLOCK_FALL);
            }
            if (entity.isAlive() && damage >= 10.0f && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                TofuAdvancements.NARROW_ESCAPE_TRIGGER.get().trigger(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockModificationEvent(PlayerInteractEvent.RightClickBlock event) {
        boolean shroomlight;
        InteractionHand hand = event.getHand();
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (player != null && stack.is(Items.GLASS_BOTTLE) && (shroomlight = level.getBlockState(pos).is(Blocks.SHROOMLIGHT))) {
            if (!level.isClientSide()) {
                level.levelEvent(2001, pos, Block.getId((BlockState)Blocks.SHROOMLIGHT.defaultBlockState()));
            }
            player.playSound(SoundEvents.BOTTLE_FILL);
            ContainerUtils.addWithContainer(player, hand, stack, ((Item)TofuItems.SHROOM_BOTTLE.get()).getDefaultInstance(), true);
            level.removeBlock(pos, false);
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        if (event.getExplosion().getDamageSource().is(TofuDamageTypes.ZUNDA)) {
            event.getAffectedEntities().forEach(entity -> {
                Vec3 p = event.getExplosion().center();
                float f = event.getExplosion().radius() * 2.0f;
                double dist = entity.distanceToSqr(p) / (double)f;
                if (dist <= 1.0) {
                    float f2 = ServerExplosion.getSeenPercent((Vec3)p, (Entity)entity);
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        livingEntity.addEffect(new MobEffectInstance(TofuEffects.ZUNDAFIED, (int)(CommonEvents.getEntityDamageAmount((Explosion)event.getExplosion(), entity, f2) * 40.0f)));
                        if (!entity.getType().is(TofuTags.EntityTypes.EXTRA_DAMAGE_ZUNDA)) {
                            livingEntity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, (int)(CommonEvents.getEntityDamageAmount((Explosion)event.getExplosion(), entity, f2) * 40.0f)));
                        }
                    }
                }
            });
        }
    }

    public static float getEntityDamageAmount(Explosion p_311793_, Entity p_311929_, float p_364677_) {
        float f = p_311793_.radius() * 2.0f;
        Vec3 vec3 = p_311793_.center();
        double d0 = Math.sqrt(p_311929_.distanceToSqr(vec3)) / (double)f;
        double d1 = (1.0 - d0) * (double)p_364677_;
        return (float)((d1 * d1 + d1) / 2.0 * 7.0 * (double)f + 1.0);
    }

    @SubscribeEvent
    public static void onPotionEffectAdd(MobEffectEvent.Added event) {
        if (event.getEffectInstance().is(TofuEffects.ZUNDAFIED)) {
            ((TofuLivingAttachment)event.getEntity().getData(TofuAttachments.TOFU_LIVING.get())).setZundafied((Entity)event.getEntity(), true);
        }
    }

    @SubscribeEvent
    public static void onPotionEffectRemove(MobEffectEvent.Remove event) {
        if (event.getEffect().is(TofuEffects.ZUNDAFIED)) {
            ((TofuLivingAttachment)event.getEntity().getData(TofuAttachments.TOFU_LIVING.get())).setZundafied((Entity)event.getEntity(), false);
        }
        if (event.getEffect().is(TofuEffects.HEART_RECOVER)) {
            ((TofuLivingAttachment)event.getEntity().getData(TofuAttachments.TOFU_LIVING.get())).setRecoverHealth((Entity)event.getEntity(), 0.0f);
        }
    }

    @SubscribeEvent
    public static void onPotionEffectRemove(MobEffectEvent.Expired event) {
        if (event.getEffectInstance() != null) {
            if (event.getEffectInstance().is(TofuEffects.ZUNDAFIED)) {
                ((TofuLivingAttachment)event.getEntity().getData(TofuAttachments.TOFU_LIVING.get())).setZundafied((Entity)event.getEntity(), false);
            }
            if (event.getEffectInstance().is(TofuEffects.HEART_RECOVER)) {
                ((TofuLivingAttachment)event.getEntity().getData(TofuAttachments.TOFU_LIVING.get())).setRecoverHealth((Entity)event.getEntity(), 0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPotionEffectApplied(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().value() == MobEffects.BLINDNESS && EnchantmentHelper.getEnchantmentLevel((Holder)event.getEntity().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(TofuEnchantments.EFFECT_PROTECTION), (LivingEntity)event.getEntity()) > 0) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
        if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().value() == MobEffects.OOZING && EnchantmentHelper.getEnchantmentLevel((Holder)event.getEntity().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(TofuEnchantments.EFFECT_PROTECTION), (LivingEntity)event.getEntity()) > 0) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
        if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().value() == MobEffects.SLOWNESS.value() && EnchantmentHelper.getEnchantmentLevel((Holder)event.getEntity().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(TofuEnchantments.EFFECT_PROTECTION), (LivingEntity)event.getEntity()) > 0) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
        if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().value() == MobEffects.INFESTED && EnchantmentHelper.getEnchantmentLevel((Holder)event.getEntity().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(TofuEnchantments.EFFECT_PROTECTION), (LivingEntity)event.getEntity()) > 0) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
        if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().value() == MobEffects.HUNGER && event.getEntity().hasEffect(TofuEffects.MISO_BOOST)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
        if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().value() == MobEffects.NAUSEA.value() && event.getEntity().hasEffect(TofuEffects.MISO_BOOST)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    @SubscribeEvent
    public static boolean onBlockStartBreak(BlockEvent.BreakEvent event) {
        ItemStack hand = event.getPlayer().getItemInHand(InteractionHand.MAIN_HAND);
        if (hand.has(DataComponents.TOOL)) {
            Block blockDestroyed = event.getLevel().getBlockState(event.getPos()).getBlock();
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)levelAccessor;
                TofuDiamondToolUtil.onBlockStartBreak(hand, level, blockDestroyed, event.getPos(), event.getPlayer());
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onCrit(CriticalHitEvent event) {
        Player player = event.getEntity();
        Entity target = event.getTarget();
        if (target instanceof ShuDofuSpiderPart) {
            boolean flag1;
            ShuDofuSpiderPart part = (ShuDofuSpiderPart)target;
            float f2 = player.getAttackStrengthScale(0.5f);
            boolean flag3 = f2 > 0.9f;
            boolean bl = flag1 = flag3 && player.fallDistance > 0.0 && !player.onGround() && !player.onClimbable() && !player.isInWater() && !player.isMobilityRestricted() && !player.isPassenger() && target.isAttackable() && !player.isSprinting();
            if (flag1) {
                event.setCriticalHit(true);
                player.crit(part.getParent());
            }
        }
    }
}

