/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.attachment;

import baguchi.tofucraft.network.SoyMilkDrinkedPacket;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.network.PacketDistributor;

public class SoyHealthAttachment
implements ValueIOSerializable {
    private int soyHealthLevel;
    private int soyHealthBaseLevel;
    private long lastTick = -12000L;
    private long lastChangedTick = -12000L;

    public void setSoyHealthLevel(LivingEntity entity, int level, boolean canUpdate) {
        if (canUpdate) {
            this.lastTick = entity.level().getGameTime();
            this.lastChangedTick = entity.level().getGameTime();
            if (entity instanceof Player) {
                ((Player)entity).displayClientMessage((Component)Component.translatable((String)"item.tofucraft.soymilk.drink_day", (Object[])new Object[]{level}), true);
            }
        }
        if (!entity.level().isClientSide()) {
            SoyMilkDrinkedPacket message = new SoyMilkDrinkedPacket(entity, level, canUpdate);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.soyHealthLevel = Mth.clamp((int)level, (int)0, (int)20);
    }

    public void setSoyHealthBaseLevel(int level) {
        this.soyHealthBaseLevel = Mth.clamp((int)level, (int)0, (int)100);
    }

    public void removeAllSoyHealth(LivingEntity entity) {
        this.soyHealthLevel = 0;
        if (!entity.level().isClientSide()) {
            SoyMilkDrinkedPacket message = new SoyMilkDrinkedPacket(entity, this.soyHealthLevel, true);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public long getRemainTick() {
        return this.lastTick;
    }

    public int getSoyHealthLevel() {
        return this.soyHealthLevel;
    }

    public int getSoyHealthBaseLevel() {
        return this.soyHealthBaseLevel;
    }

    public void tick(LivingEntity livingEntity) {
        if (!livingEntity.level().isClientSide() && livingEntity.level().getGameTime() > this.lastChangedTick + 24000L && this.soyHealthLevel > 1) {
            this.setSoyHealthLevel(livingEntity, this.soyHealthLevel - 2, false);
            this.lastChangedTick = livingEntity.level().getGameTime();
        }
    }

    public void serialize(ValueOutput output) {
        output.putLong("RemainTick", this.lastTick);
        output.putLong("RemainChangedTick", this.lastChangedTick);
        output.putInt("SoyHealthLevel", this.soyHealthLevel);
        output.putInt("SoyHealthBaseLevel", this.soyHealthBaseLevel);
    }

    public void deserialize(ValueInput nbt) {
        this.lastTick = nbt.getLongOr("RemainTick", 0L);
        this.lastChangedTick = nbt.getLongOr("RemainChangedTick", 0L);
        this.soyHealthLevel = nbt.getIntOr("SoyHealthLevel", 0);
        this.soyHealthBaseLevel = nbt.getIntOr("SoyHealthBaseLevel", 0);
    }
}

