/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.block;

import baguchi.tofucraft.blockentity.TofuPotBlockEntity;
import baguchi.tofucraft.registry.TofuBlockEntitys;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;

public class TofuPotBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<TofuPotBlock> CODEC = TofuPotBlock.simpleCodec(TofuPotBlock::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_WITH_TRAY = Shapes.or((VoxelShape)SHAPE, (VoxelShape)Block.box((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));

    public TofuPotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public InteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        boolean flag = false;
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof TofuPotBlockEntity && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)pos, null)) {
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide()) {
            if (tileEntity instanceof TofuPotBlockEntity) {
                TofuPotBlockEntity cookingPotEntity = (TofuPotBlockEntity)tileEntity;
                player.openMenu((MenuProvider)cookingPotEntity, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        FluidState fluid = level.getFluidState(context.getClickedPos());
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
        return state;
    }

    protected BlockState updateShape(BlockState p_53160_, LevelReader p_374322_, ScheduledTickAccess p_374149_, BlockPos p_53164_, Direction p_53161_, BlockPos p_53165_, BlockState p_53162_, RandomSource p_374199_) {
        if (((Boolean)p_53160_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_374149_.scheduleTick(p_53164_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_374322_));
        }
        return super.updateShape(p_53160_, p_374322_, p_374149_, p_53164_, p_53161_, p_53165_, p_53162_, p_374199_);
    }

    protected void affectNeighborsAfterRemoval(BlockState p_394424_, ServerLevel p_394241_, BlockPos p_393520_, boolean p_394545_) {
        super.affectNeighborsAfterRemoval(p_394424_, p_394241_, p_393520_, p_394545_);
        BlockEntity blockentity = p_394241_.getBlockEntity(p_393520_);
        if (blockentity instanceof TofuPotBlockEntity) {
            TofuPotBlockEntity tofuPotBlockEntity = (TofuPotBlockEntity)blockentity;
            if (p_394241_ instanceof ServerLevel) {
                tofuPotBlockEntity.getUsedRecipesAndPopExperience(p_394241_, Vec3.atCenterOf((Vec3i)p_393520_));
            }
            p_394241_.updateNeighbourForOutputSignal(p_393520_, (Block)this);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        TofuPotBlockEntity cookingPotEntity;
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof TofuPotBlockEntity && (cookingPotEntity = (TofuPotBlockEntity)tileEntity).isHeated()) {
            SoundEvent boilSound = !cookingPotEntity.getItem(12).isEmpty() ? SoundEvents.LAVA_POP : SoundEvents.BUBBLE_COLUMN_BUBBLE_POP;
            double x = (double)pos.getX() + 0.5;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.5;
            if (random.nextInt(10) == 0) {
                level.playLocalSound(x, y, z, boilSound, SoundSource.BLOCKS, 0.5f, random.nextFloat() * 0.2f + 0.9f, false);
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)TofuBlockEntitys.TOFU_POT.get()).create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        if (level.isClientSide()) {
            return TofuPotBlock.createTickerHelper(blockEntity, (BlockEntityType)((BlockEntityType)TofuBlockEntitys.TOFU_POT.get()), TofuPotBlockEntity::animationTick);
        }
        return TofuPotBlock.createTickerHelper(blockEntity, (BlockEntityType)((BlockEntityType)TofuBlockEntitys.TOFU_POT.get()), TofuPotBlockEntity::cookingTick);
    }
}

