/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.block;

import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;

public class YubaBlock
extends Block {
    private static final VoxelShape STABLE_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public YubaBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        return new ItemStack((ItemLike)TofuItems.YUBA.get());
    }

    public VoxelShape getShape(BlockState p_56057_, BlockGetter p_56058_, BlockPos p_56059_, CollisionContext p_56060_) {
        return STABLE_SHAPE;
    }

    public VoxelShape getInteractionShape(BlockState p_56053_, BlockGetter p_56054_, BlockPos p_56055_) {
        return STABLE_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState p_56068_, BlockGetter p_56069_, BlockPos p_56070_, CollisionContext p_56071_) {
        if (p_56071_.isAbove(STABLE_SHAPE, p_56070_, true)) {
            return STABLE_SHAPE;
        }
        return Shapes.empty();
    }

    public boolean canSurvive(BlockState p_152289_, LevelReader p_152290_, BlockPos p_152291_) {
        BlockPos blockpos = p_152291_.below();
        BlockState blockstate = p_152290_.getBlockState(blockpos);
        return blockstate.is((Block)TofuBlocks.SOYMILK.get()) || blockstate.isFaceSturdy((BlockGetter)p_152290_, blockpos, Direction.UP);
    }

    protected BlockState updateShape(BlockState p_60541_, LevelReader p_374332_, ScheduledTickAccess p_374457_, BlockPos p_60545_, Direction p_60542_, BlockPos p_60546_, BlockState p_60543_, RandomSource p_374120_) {
        if (!p_374332_.isClientSide()) {
            p_374457_.scheduleTick(p_60545_, (Block)this, 5);
        }
        return p_60541_;
    }

    protected void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity, InsideBlockEffectApplier p_405359_, boolean p_451772_) {
        super.entityInside(blockState, level, blockPos, entity, p_405359_, p_451772_);
        if (!level.isClientSide() && YubaBlock.canEntityTilt(blockPos, entity)) {
            level.scheduleTick(blockPos, (Block)this, 5);
        }
    }

    private static boolean canEntityTilt(BlockPos p_152302_, Entity p_152303_) {
        return p_152303_.onGround() && p_152303_.position().y > (double)p_152302_.getY() + 0.0625 && p_152303_.position().y <= (double)p_152302_.getY() + 0.125;
    }

    public void tick(BlockState p_222945_, ServerLevel p_222946_, BlockPos p_222947_, RandomSource p_222948_) {
        super.tick(p_222945_, p_222946_, p_222947_, p_222948_);
        if (!this.canSurvive(p_222945_, (LevelReader)p_222946_, p_222947_)) {
            FallingBlockEntity.fall((Level)p_222946_, (BlockPos)p_222947_, (BlockState)p_222945_);
        } else if (!p_222945_.isFaceSturdy((BlockGetter)p_222946_, p_222947_, Direction.UP) && p_222945_.is((Block)TofuBlocks.SOYMILK.get())) {
            p_222946_.levelEvent(2001, p_222947_, Block.getId((BlockState)p_222946_.getBlockState(p_222947_)));
            p_222946_.removeBlock(p_222947_, false);
        }
    }

    protected InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_316140_) {
        if (itemstack.is(Tags.Items.RODS_WOODEN)) {
            if (!worldIn.isClientSide()) {
                ItemStack salt = new ItemStack((ItemLike)TofuItems.YUBA.get(), 1);
                float f = 0.7f;
                double d0 = (double)(worldIn.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(worldIn.random.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.2;
                double d2 = (double)(worldIn.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                ItemEntity itemEntity = new ItemEntity(worldIn, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, salt);
                itemEntity.setPickUpDelay(10);
                worldIn.addFreshEntity((Entity)itemEntity);
                worldIn.removeBlock(pos, false);
            }
            player.playSound(SoundEvents.BOAT_PADDLE_WATER, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }
}

