/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.block.utils;

import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuItems;
import baguchi.tofucraft.utils.TileScanner;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SproutsJarBlock
extends Block
implements SimpleWaterloggedBlock {
    public static VoxelShape SPROUTSJAR_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final EnumProperty<Stat> STAT = EnumProperty.create((String)"stat", Stat.class);
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public SproutsJarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.FALSE)).setValue((Property)EAST, (Comparable)Boolean.FALSE)).setValue((Property)SOUTH, (Comparable)Boolean.FALSE)).setValue((Property)WEST, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected BlockState updateShape(BlockState stateIn, LevelReader levelReader, ScheduledTickAccess access, BlockPos currentPos, Direction direction, BlockPos facingPos, BlockState facingState, RandomSource randomSource) {
        if (!stateIn.canSurvive(levelReader, currentPos) && !access.getBlockTicks().hasScheduledTick(currentPos, (Object)this)) {
            access.scheduleTick(currentPos, (Block)this, 1);
        }
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            access.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
            Stat stat = this.getStat(stateIn);
            if (stat == Stat.EMPTY) {
                return (BlockState)stateIn.setValue(STAT, (Comparable)((Object)Stat.WATER));
            }
            if (stat == Stat.SPROUTS_3) {
                ItemStack sprouts = new ItemStack((ItemLike)TofuItems.SPROUTS.get(), 1);
                return (BlockState)stateIn.setValue(STAT, (Comparable)((Object)Stat.WATER));
            }
        }
        return direction.getAxis().isHorizontal() ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(levelReader, currentPos.north())))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(levelReader, currentPos.east())))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(levelReader, currentPos.south())))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(levelReader, currentPos.west()))) : super.updateShape(stateIn, levelReader, access, currentPos, direction, facingPos, facingState, randomSource);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        return blockstate.getBlock() == this ? (BlockState)((BlockState)((BlockState)((BlockState)context.getLevel().getBlockState(context.getClickedPos()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo((LevelReader)context.getLevel(), context.getClickedPos().north())))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo((LevelReader)context.getLevel(), context.getClickedPos().east())))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo((LevelReader)context.getLevel(), context.getClickedPos().south())))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo((LevelReader)context.getLevel(), context.getClickedPos().west()))) : super.getStateForPlacement(context);
    }

    public boolean canSurvive(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        return p_196260_2_.getBlockState(p_196260_3_.below()).isSolid();
    }

    protected InteractionResult useItemOn(ItemStack itemHeld, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_316140_) {
        Stat stat = this.getStat(state);
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            if (stat == Stat.EMPTY && itemHeld != null && itemHeld.getItem() == Items.WATER_BUCKET) {
                if (!player.isCreative()) {
                    player.setItemInHand(handIn, new ItemStack((ItemLike)Items.BUCKET));
                }
                worldIn.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                TileScanner tileScanner = new TileScanner(worldIn, pos);
                tileScanner.scan(1, TileScanner.Method.fullSimply, new TileScanner.Impl<Object>(){

                    @Override
                    public void apply(Level world, BlockPos pos) {
                        if (SproutsJarBlock.this.getStat(world.getBlockState(pos)) == Stat.EMPTY) {
                            world.setBlock(pos, (BlockState)((Block)TofuBlocks.SPROUTSJAR.get()).defaultBlockState().setValue(STAT, (Comparable)((Object)Stat.WATER)), 3);
                        }
                    }
                });
                worldIn.setBlock(pos, (BlockState)state.setValue(STAT, (Comparable)((Object)Stat.WATER)), 3);
                return InteractionResult.SUCCESS;
            }
            if (stat == Stat.WATER && itemHeld != null && itemHeld.getItem() == Items.BUCKET) {
                ItemStack water = new ItemStack((ItemLike)Items.WATER_BUCKET);
                worldIn.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (itemHeld.getCount() == 1) {
                    player.setItemInHand(handIn, water);
                } else {
                    if (player.getInventory().add(water)) {
                        worldIn.addFreshEntity((Entity)new ItemEntity(worldIn, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, water));
                    }
                    itemHeld.shrink(1);
                }
                worldIn.setBlock(pos, (BlockState)state.setValue(STAT, (Comparable)((Object)Stat.EMPTY)), 3);
                return InteractionResult.SUCCESS;
            }
            if (stat == Stat.WATER && itemHeld != null && itemHeld.getItem() == TofuItems.SEEDS_SOYBEANS.get()) {
                if (!player.isCreative()) {
                    itemHeld.shrink(1);
                }
                worldIn.playSound(null, pos, SoundEvents.CORAL_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                worldIn.setBlock(pos, (BlockState)state.setValue(STAT, (Comparable)((Object)Stat.SPROUTS_0)), 3);
                return InteractionResult.SUCCESS;
            }
            if (stat == Stat.SPROUTS_3) {
                ItemStack salt = new ItemStack((ItemLike)TofuItems.SPROUTS.get(), 1);
                float f = 0.7f;
                double d0 = (double)(worldIn.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(worldIn.random.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.6;
                double d2 = (double)(worldIn.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                ItemEntity itemEntity = new ItemEntity(worldIn, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, salt);
                itemEntity.setPickUpDelay(10);
                worldIn.addFreshEntity((Entity)itemEntity);
                worldIn.setBlock(pos, (BlockState)state.setValue(STAT, (Comparable)((Object)Stat.WATER)), 3);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)worldIn, pos)) {
            worldIn.destroyBlock(pos, true);
        }
        Stat stat = this.getStat(state);
        int l = stat.getMeta();
        if (stat == Stat.SPROUTS_0 && this.canGrowing((Level)worldIn, pos)) {
            worldIn.setBlock(pos, (BlockState)state.setValue(STAT, (Comparable)((Object)Stat.SPROUTS_1)), 3);
        }
        if (stat == Stat.SPROUTS_1 && this.canGrowing((Level)worldIn, pos)) {
            worldIn.setBlock(pos, (BlockState)state.setValue(STAT, (Comparable)((Object)Stat.SPROUTS_2)), 3);
        }
        if (stat == Stat.SPROUTS_2 && this.canGrowing((Level)worldIn, pos)) {
            worldIn.setBlock(pos, (BlockState)state.setValue(STAT, (Comparable)((Object)Stat.SPROUTS_3)), 3);
        }
    }

    public Stat getStat(BlockState meta) {
        if (meta.getBlock() == this) {
            return (Stat)((Object)meta.getValue(STAT));
        }
        return Stat.NA;
    }

    public boolean canConnectTo(LevelReader worldIn, BlockPos pos) {
        Block block = worldIn.getBlockState(pos).getBlock();
        return block instanceof SproutsJarBlock;
    }

    public boolean canGrowing(Level world, BlockPos pos) {
        return true;
    }

    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SPROUTSJAR_AABB;
    }

    public RenderShape getRenderShape(BlockState p_60550_) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STAT, NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_204507_1_);
    }

    public static enum Stat implements StringRepresentable
    {
        EMPTY(0, "empty"),
        WATER(1, "water"),
        SPROUTS_0(2, "sprouts_0"),
        SPROUTS_1(3, "sprouts_1"),
        SPROUTS_2(4, "sprouts_2"),
        SPROUTS_3(5, "sprouts_3"),
        NA(6, "na");

        private static final Stat[] META_LOOKUP;
        private final int meta;
        private final String name;

        private Stat(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            META_LOOKUP = new Stat[Stat.values().length];
            Stat[] statArray = Stat.values();
            int n = statArray.length;
            for (int i = 0; i < n; ++i) {
                Stat enumtype;
                Stat.META_LOOKUP[enumtype.getMeta()] = enumtype = statArray[i];
            }
        }
    }
}

