/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client;

import baguchi.bagus_lib.animation.BaguAnimationController;
import baguchi.bagus_lib.animation.client.BaguKeyFrameController;
import baguchi.bagus_lib.client.event.BagusModelEvent;
import baguchi.tofucraft.client.sound.TofuMusicManager;
import baguchi.tofucraft.entity.TofuGandlem;
import baguchi.tofucraft.registry.TofuAnimations;
import baguchi.tofucraft.registry.TofuItems;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Mob;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="tofucraft", value={Dist.CLIENT})
public class TofuClientEvents {
    public static Map<UUID, Mob> BOSS_BARS = new HashMap<UUID, Mob>();
    public static final Identifier GANDLEM_BOSS_BAR = Identifier.fromNamespaceAndPath((String)"tofucraft", (String)"boss_bar/tofu_gandlem_progress");
    public static final Identifier GANDLEM_BOSS_BAR_BACKGROUND = Identifier.fromNamespaceAndPath((String)"tofucraft", (String)"boss_bar/tofu_gandlem_background");

    @SubscribeEvent
    public static void onClientTickEvent(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && !Minecraft.getInstance().isPaused()) {
            TofuMusicManager.tick();
        }
    }

    @SubscribeEvent
    public static void onBossOverlay(CustomizeGuiOverlayEvent.BossEventProgress event) {
        Minecraft minecraft = Minecraft.getInstance();
        int i = minecraft.getWindow().getGuiScaledWidth();
        if (BOSS_BARS.containsKey(event.getBossEvent().getId())) {
            Mob boss = BOSS_BARS.get(event.getBossEvent().getId());
            if (!(boss instanceof TofuGandlem)) {
                return;
            }
            TofuGandlem tofuGandlem = (TofuGandlem)boss;
            event.setCanceled(true);
            int k = i / 2 - 91;
            TofuClientEvents.drawBar(event.getGuiGraphics(), k, event.getY(), (BossEvent)event.getBossEvent(), boss);
            Component itextcomponent = boss.getDisplayName();
            int l = minecraft.font.width((FormattedText)itextcomponent);
            int i1 = i / 2 - l / 2;
            event.getGuiGraphics().drawString(minecraft.font, itextcomponent, i1, event.getY() - 9, 0xFFFFFF);
            if (event.getY() >= minecraft.getWindow().getGuiScaledHeight() / 3) {
                return;
            }
        }
    }

    private static void drawBar(GuiGraphics p_283672_, int p_283570_, int p_283306_, BossEvent p_283156_, Mob mob) {
        if (mob instanceof TofuGandlem) {
            TofuClientEvents.drawBar(p_283672_, p_283570_, p_283306_, p_283156_, 182, GANDLEM_BOSS_BAR_BACKGROUND);
            int i = Mth.lerpDiscrete((float)p_283156_.getProgress(), (int)0, (int)182);
            if (i > 0) {
                TofuClientEvents.drawBar(p_283672_, p_283570_, p_283306_, p_283156_, i, GANDLEM_BOSS_BAR);
            }
        }
    }

    private static void drawBar(GuiGraphics p_281657_, int p_283675_, int p_282498_, BossEvent p_281288_, int p_283619_, Identifier p_296156_) {
        p_281657_.blitSprite(RenderPipelines.GUI_TEXTURED, p_296156_, 182, 9, 0, 0, p_283675_, p_282498_, p_283619_, 9);
    }

    public static void addBossBar(UUID id, Mob mob) {
        BOSS_BARS.put(id, mob);
    }

    public static void removeBossBar(UUID id, Mob mob) {
        BOSS_BARS.remove(id, mob);
    }

    @SubscribeEvent
    public static void onAnimateModelEvent(BagusModelEvent.PostAnimate event) {
        BaguAnimationController animations = event.getBaguAnimationController();
        @Nullable BaguKeyFrameController keyFrames = event.getBaguKeyframeController();
        if (keyFrames != null) {
            KeyframeAnimation cough = keyFrames.getKeyframe(TofuAnimations.COUGH);
            KeyframeAnimation thrownRight = keyFrames.getKeyframe(TofuAnimations.THROWN_RIGHT);
            KeyframeAnimation thrownLeft = keyFrames.getKeyframe(TofuAnimations.THROWN_LEFT);
            KeyframeAnimation busterRight = keyFrames.getKeyframe(TofuAnimations.BUSTER_RIGHT);
            KeyframeAnimation busterLeft = keyFrames.getKeyframe(TofuAnimations.BUSTER_LEFT);
            if (animations != null && cough != null) {
                cough.apply(animations.getAnimationState(TofuAnimations.COUGH), event.getEntityRenderState().ageInTicks);
            }
            if (animations != null) {
                if (thrownRight != null && thrownLeft != null && (animations.getAnimationState(TofuAnimations.THROWN_RIGHT).isStarted() || animations.getAnimationState(TofuAnimations.THROWN_LEFT).isStarted())) {
                    event.getModel().root().getChild("right_arm").resetPose();
                    event.getModel().root().getChild("left_arm").resetPose();
                    thrownRight.apply(animations.getAnimationState(TofuAnimations.THROWN_RIGHT), event.getEntityRenderState().ageInTicks);
                    thrownLeft.apply(animations.getAnimationState(TofuAnimations.THROWN_LEFT), event.getEntityRenderState().ageInTicks);
                }
                if (busterRight != null && busterLeft != null && (animations.getAnimationState(TofuAnimations.BUSTER_RIGHT).isStarted() || animations.getAnimationState(TofuAnimations.BUSTER_LEFT).isStarted())) {
                    event.getModel().root().getChild("right_arm").resetPose();
                    event.getModel().root().getChild("left_arm").resetPose();
                    event.getModel().root().getChild("right_leg").resetPose();
                    event.getModel().root().getChild("left_leg").resetPose();
                    event.getModel().root().getChild("body").resetPose();
                    event.getModel().root().getChild("head").resetPose();
                    event.getModel().root().getChild((String)"head").xRot = event.getEntityRenderState().xRot * ((float)Math.PI / 180);
                    event.getModel().root().getChild((String)"head").yRot = event.getEntityRenderState().yRot * ((float)Math.PI / 180);
                    busterRight.apply(animations.getAnimationState(TofuAnimations.BUSTER_RIGHT), event.getEntityRenderState().ageInTicks);
                    busterLeft.apply(animations.getAnimationState(TofuAnimations.BUSTER_LEFT), event.getEntityRenderState().ageInTicks);
                }
            }
        }
    }

    @SubscribeEvent
    public static void fov(ComputeFovModifierEvent event) {
        float f = 1.0f;
        if (event.getPlayer().isUsingItem() && event.getPlayer().getUseItem().is(TofuItems.ZUNDA_BOW)) {
            float f3 = Math.min((float)event.getPlayer().getTicksUsingItem() / 20.0f, 1.0f);
            event.setNewFovModifier(f *= 1.0f - Mth.square((float)f3) * 0.15f);
        }
    }
}

