/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.model;

import baguchi.tofucraft.client.animation.definitions.ShuDofuSpiderAnimation;
import baguchi.tofucraft.client.render.state.ShuDofuSpiderRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.rendertype.RenderTypes;

public class ShuDofuSpiderModel
extends EntityModel<ShuDofuSpiderRenderState> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart neck;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;
    private final ModelPart leg5;
    private final ModelPart leg6;
    private final ModelPart bone;
    private final ModelPart bone13;
    private final ModelPart bone23;
    private final ModelPart bone8;
    private final ModelPart bone18;
    private final ModelPart bone28;
    private final KeyframeAnimation walkAnimation;
    private final KeyframeAnimation attackAnimation;
    private final KeyframeAnimation deathAnimation;
    private final KeyframeAnimation jumpAnimation;
    private final KeyframeAnimation idleAnimation;
    private final KeyframeAnimation graspAnimation;
    private final KeyframeAnimation graspPreAnimation;

    public ShuDofuSpiderModel(ModelPart root) {
        super(root, RenderTypes::entityTranslucent);
        this.root = root.getChild("root");
        this.neck = this.root.getChild("neck");
        this.head = this.neck.getChild("head");
        this.leg1 = this.neck.getChild("leg1");
        this.leg2 = this.neck.getChild("leg2");
        this.leg3 = this.neck.getChild("leg3");
        this.leg4 = this.neck.getChild("leg4");
        this.leg5 = this.neck.getChild("leg5");
        this.leg6 = this.neck.getChild("leg6");
        this.bone = this.leg1.getChild("bone");
        this.bone13 = this.leg3.getChild("bone13");
        this.bone23 = this.leg5.getChild("bone23");
        this.bone8 = this.leg2.getChild("bone8");
        this.bone18 = this.leg4.getChild("bone18");
        this.bone28 = this.leg6.getChild("bone28");
        this.walkAnimation = ShuDofuSpiderAnimation.WALK.bake(root);
        this.attackAnimation = ShuDofuSpiderAnimation.SWIPE.bake(root);
        this.deathAnimation = ShuDofuSpiderAnimation.DEATH.bake(root);
        this.jumpAnimation = ShuDofuSpiderAnimation.JUMP_ATTACK.bake(root);
        this.idleAnimation = ShuDofuSpiderAnimation.IDLE.bake(root);
        this.graspAnimation = ShuDofuSpiderAnimation.GRASP.bake(root);
        this.graspPreAnimation = ShuDofuSpiderAnimation.GRASP_PRE.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition neck = root.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.02f, (float)-17.54f, (float)-3.52f));
        PartDefinition neck_front_r1 = neck.addOrReplaceChild("neck_front_r1", CubeListBuilder.create().texOffs(106, 61).addBox(-8.0f, -8.5f, -8.5f, 16.0f, 13.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition bone6 = neck.addOrReplaceChild("bone6", CubeListBuilder.create().texOffs(0, 61).addBox(-13.0f, -10.2693f, -1.4327f, 26.0f, 21.0f, 27.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.26f, (float)-1.22f, (float)4.66f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition bone46 = bone6.addOrReplaceChild("bone46", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-2.2606f, (float)16.0174f));
        PartDefinition neck_back_r1 = bone46.addOrReplaceChild("neck_back_r1", CubeListBuilder.create().texOffs(88, 91).addBox(-11.0f, -12.0f, -10.5f, 22.0f, 16.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.9913f, (float)8.0499f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition body = bone46.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.24f, (float)0.0913f, (float)-2.2901f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition bone7 = body.addOrReplaceChild("bone7", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.7532f, (float)17.9781f));
        PartDefinition body_r1 = bone7.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-16.5f, -16.5f, -18.5f, 33.0f, 26.0f, 35.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.8923f, (float)10.3301f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition bone33 = bone6.addOrReplaceChild("bone33", CubeListBuilder.create().texOffs(136, 50).addBox(-5.8247f, -0.6409f, 0.7162f, 11.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.75f, (float)-16.0193f, (float)8.5673f, (float)-0.519f, (float)0.4801f, (float)0.0085f));
        PartDefinition bone34 = bone6.addOrReplaceChild("bone34", CubeListBuilder.create().texOffs(60, 109).addBox(-5.1753f, -0.6409f, 0.7162f, 11.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.73f, (float)-16.0193f, (float)8.5673f, (float)-0.519f, (float)-0.4801f, (float)-0.0085f));
        PartDefinition bone35 = bone6.addOrReplaceChild("bone35", CubeListBuilder.create().texOffs(99, 61).addBox(-5.8247f, 1.3591f, 0.7162f, 10.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.75f, (float)-16.0193f, (float)3.5673f, (float)-0.519f, (float)0.4801f, (float)0.0085f));
        PartDefinition bone36 = bone6.addOrReplaceChild("bone36", CubeListBuilder.create().texOffs(0, 30).addBox(-4.1753f, 1.3591f, 0.7162f, 10.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.23f, (float)-16.0193f, (float)3.5673f, (float)-0.519f, (float)-0.4801f, (float)-0.0085f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(101, 0).addBox(-10.0f, -8.0f, -16.0f, 20.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.18f, (float)-6.14f, (float)-4.4f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tooth_left = head.addOrReplaceChild("tooth_left", CubeListBuilder.create().texOffs(0, 0).addBox(-1.8214f, -2.3333f, -12.1785f, 4.0f, 4.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 3).addBox(-4.8714f, -2.0033f, -11.8985f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.9835f, (float)5.6019f, (float)-13.0492f, (float)0.2618f, (float)-0.3927f, (float)0.0f));
        PartDefinition tooth_right = head.addOrReplaceChild("tooth_right", CubeListBuilder.create().texOffs(0, 15).addBox(-1.6602f, -2.5401f, -11.5281f, 4.0f, 4.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(2.2898f, -2.2101f, -11.2481f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.27f, (float)5.97f, (float)-13.42f, (float)0.2618f, (float)0.3927f, (float)0.0f));
        PartDefinition leg1 = neck.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(150, 89).addBox(-17.1765f, -3.8397f, -3.9965f, 19.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(179, 191).addBox(-24.1765f, -2.8397f, -2.9965f, 7.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.4355f, (float)0.1509f, (float)-1.4883f, (float)-0.2058f, (float)-0.284f, (float)0.6404f));
        PartDefinition bone = leg1.addOrReplaceChild("bone", CubeListBuilder.create().texOffs(60, 143).addBox(-21.5f, -3.0f, -5.0f, 25.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-28.5269f, (float)-2.891f, (float)-0.6806f, (float)0.0f, (float)0.0f, (float)-1.9199f));
        PartDefinition bone5 = bone.addOrReplaceChild("bone5", CubeListBuilder.create(), PartPose.offset((float)-18.2696f, (float)1.0113f, (float)-0.116f));
        PartDefinition bone40 = bone5.addOrReplaceChild("bone40", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.9659f, (float)-0.2588f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition bone4 = bone40.addOrReplaceChild("bone4", CubeListBuilder.create().texOffs(162, 170).addBox(-62.02f, -38.8f, -11.3f, 19.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)42.7896f, (float)35.7887f, (float)8.416f));
        PartDefinition bone2 = bone40.addOrReplaceChild("bone2", CubeListBuilder.create().texOffs(133, 191).addBox(-9.0f, -2.4993f, -2.4999f, 18.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.385f, (float)-0.4477f, (float)-1.3183f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition bone3 = bone40.addOrReplaceChild("bone3", CubeListBuilder.create().texOffs(190, 116).addBox(-7.1272f, -2.9364f, -2.5897f, 18.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.2304f, (float)-0.0113f, (float)1.616f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition leg2 = neck.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(130, 143).addBox(-0.6763f, -5.478f, -3.9965f, 19.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(90, 161).addBox(18.3237f, -4.478f, -2.9965f, 7.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.3955f, (float)2.1509f, (float)-1.4883f, (float)-0.2058f, (float)0.284f, (float)-0.6404f));
        PartDefinition bone8 = leg2.addOrReplaceChild("bone8", CubeListBuilder.create().texOffs(136, 32).addBox(-3.5f, -3.0f, -5.0f, 25.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)29.6741f, (float)-4.5293f, (float)-0.6806f, (float)0.0f, (float)0.0f, (float)1.9199f));
        PartDefinition bone9 = bone8.addOrReplaceChild("bone9", CubeListBuilder.create(), PartPose.offset((float)18.2696f, (float)1.0113f, (float)-0.116f));
        PartDefinition bone37 = bone9.addOrReplaceChild("bone37", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.9659f, (float)-0.2588f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition bone10 = bone37.addOrReplaceChild("bone10", CubeListBuilder.create().texOffs(168, 159).addBox(-9.5f, -2.5f, -3.0f, 19.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)9.7304f, (float)-0.5113f, (float)0.116f));
        PartDefinition bone11 = bone37.addOrReplaceChild("bone11", CubeListBuilder.create().texOffs(92, 186).addBox(-9.0f, -2.4993f, -2.4999f, 18.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.385f, (float)-0.4477f, (float)-1.3183f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition bone12 = bone37.addOrReplaceChild("bone12", CubeListBuilder.create().texOffs(184, 143).addBox(-10.8728f, -2.9364f, -2.5897f, 18.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.2304f, (float)-0.0113f, (float)1.616f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition leg3 = neck.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(157, 0).addBox(-15.41f, -2.28f, -4.1f, 15.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(79, 61).addBox(-22.41f, -1.28f, -3.1f, 7.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.99f, (float)-2.14f, (float)6.42f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition bone13 = leg3.addOrReplaceChild("bone13", CubeListBuilder.create().texOffs(130, 125).addBox(-21.5f, -3.0f, -5.0f, 25.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-26.7604f, (float)-1.3313f, (float)-0.784f, (float)0.0f, (float)0.0f, (float)-1.9199f));
        PartDefinition bone14 = bone13.addOrReplaceChild("bone14", CubeListBuilder.create(), PartPose.offset((float)-18.2696f, (float)1.0113f, (float)-0.116f));
        PartDefinition bone41 = bone14.addOrReplaceChild("bone41", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.9659f, (float)-0.2588f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition bone15 = bone41.addOrReplaceChild("bone15", CubeListBuilder.create().texOffs(168, 77).addBox(-62.02f, -38.8f, -11.3f, 19.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)42.7896f, (float)35.7887f, (float)8.416f));
        PartDefinition bone16 = bone41.addOrReplaceChild("bone16", CubeListBuilder.create().texOffs(179, 181).addBox(-9.0f, -2.4993f, -2.4999f, 18.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.385f, (float)-0.4477f, (float)-1.3183f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition bone17 = bone41.addOrReplaceChild("bone17", CubeListBuilder.create().texOffs(133, 181).addBox(-7.1272f, -2.9364f, -2.5897f, 18.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.2304f, (float)-0.0113f, (float)1.616f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition bone44 = bone14.addOrReplaceChild("bone44", CubeListBuilder.create(), PartPose.offset((float)20.2696f, (float)-0.7253f, (float)-7.2116f));
        PartDefinition bone45 = bone14.addOrReplaceChild("bone45", CubeListBuilder.create(), PartPose.offset((float)21.2653f, (float)6.7637f, (float)7.3263f));
        PartDefinition leg4 = neck.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(122, 159).addBox(0.41f, -2.28f, -4.1f, 15.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(79, 73).addBox(15.41f, -1.28f, -3.1f, 7.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.95f, (float)-2.14f, (float)6.42f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition bone18 = leg4.addOrReplaceChild("bone18", CubeListBuilder.create().texOffs(0, 133).addBox(-4.8961f, -3.5751f, -5.0f, 25.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)25.7425f, (float)-0.2161f, (float)-0.784f, (float)0.0f, (float)0.0f, (float)1.9199f));
        PartDefinition bone42 = bone18.addOrReplaceChild("bone42", CubeListBuilder.create(), PartPose.offset((float)7.6039f, (float)-1.3751f, (float)7.2104f));
        PartDefinition bone43 = bone18.addOrReplaceChild("bone43", CubeListBuilder.create(), PartPose.offset((float)8.5996f, (float)-8.8641f, (float)-7.3276f));
        PartDefinition bone19 = bone18.addOrReplaceChild("bone19", CubeListBuilder.create(), PartPose.offset((float)16.8735f, (float)0.4363f, (float)-0.116f));
        PartDefinition bone38 = bone19.addOrReplaceChild("bone38", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.9659f, (float)-0.2588f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition bone20 = bone38.addOrReplaceChild("bone20", CubeListBuilder.create().texOffs(168, 105).addBox(43.02f, -38.8f, -11.3f, 19.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-42.7896f, (float)35.7887f, (float)8.416f));
        PartDefinition bone22 = bone38.addOrReplaceChild("bone22", CubeListBuilder.create().texOffs(0, 182).addBox(-10.8728f, -2.9364f, -2.5897f, 18.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.2304f, (float)-0.0113f, (float)1.616f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition bone21 = bone38.addOrReplaceChild("bone21", CubeListBuilder.create().texOffs(46, 182).addBox(-9.0f, -2.4993f, -2.4999f, 18.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.385f, (float)-0.4477f, (float)-1.3183f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition leg5 = neck.addOrReplaceChild("leg5", CubeListBuilder.create().texOffs(153, 50).addBox(-14.7741f, -2.3802f, -4.4466f, 15.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 73).addBox(-21.7741f, -1.3802f, -3.4466f, 7.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.4374f, (float)-2.4227f, (float)14.9245f, (float)0.1789f, (float)0.2489f, (float)0.6333f));
        PartDefinition bone23 = leg5.addOrReplaceChild("bone23", CubeListBuilder.create().texOffs(60, 125).addBox(-21.5f, -3.0f, -5.0f, 25.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-26.1245f, (float)-1.4315f, (float)-1.1307f, (float)0.0f, (float)0.0f, (float)-1.9199f));
        PartDefinition bone24 = bone23.addOrReplaceChild("bone24", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-17.3037f, (float)0.7525f, (float)-0.116f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition bone25 = bone24.addOrReplaceChild("bone25", CubeListBuilder.create().texOffs(168, 66).addBox(-62.02f, -38.8f, -11.3f, 19.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)42.7896f, (float)35.7887f, (float)8.416f));
        PartDefinition bone26 = bone24.addOrReplaceChild("bone26", CubeListBuilder.create().texOffs(92, 175).addBox(-9.0f, -2.4993f, -2.4999f, 18.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.385f, (float)-0.4477f, (float)-1.3183f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition bone27 = bone24.addOrReplaceChild("bone27", CubeListBuilder.create().texOffs(173, 16).addBox(-7.1272f, -2.9364f, -2.5897f, 18.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.2304f, (float)-0.0113f, (float)1.616f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition leg6 = neck.addOrReplaceChild("leg6", CubeListBuilder.create().texOffs(0, 151).addBox(0.41f, -2.28f, -4.1f, 15.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 61).addBox(15.41f, -1.28f, -3.1f, 7.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.95f, (float)-2.14f, (float)14.42f, (float)0.1789f, (float)-0.2489f, (float)-0.6333f));
        PartDefinition bone28 = leg6.addOrReplaceChild("bone28", CubeListBuilder.create().texOffs(0, 109).addBox(-3.5f, -3.0f, -5.0f, 25.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)26.7604f, (float)-1.3313f, (float)-0.784f, (float)0.0f, (float)0.0f, (float)1.9199f));
        PartDefinition bone29 = bone28.addOrReplaceChild("bone29", CubeListBuilder.create(), PartPose.offset((float)18.2696f, (float)1.0113f, (float)-0.116f));
        PartDefinition bone39 = bone29.addOrReplaceChild("bone39", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.9659f, (float)-0.2588f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition bone30 = bone39.addOrReplaceChild("bone30", CubeListBuilder.create().texOffs(40, 161).addBox(43.02f, -38.8f, -11.3f, 19.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-42.7896f, (float)35.7887f, (float)8.416f));
        PartDefinition bone31 = bone39.addOrReplaceChild("bone31", CubeListBuilder.create().texOffs(46, 172).addBox(-9.0f, -2.4993f, -2.4999f, 18.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.385f, (float)-0.4477f, (float)-1.3183f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition bone32 = bone39.addOrReplaceChild("bone32", CubeListBuilder.create().texOffs(0, 172).addBox(-10.8728f, -2.9364f, -2.5897f, 18.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.2304f, (float)-0.0113f, (float)1.616f, (float)0.0f, (float)0.0873f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(ShuDofuSpiderRenderState entity) {
        super.setupAnim((Object)entity);
        this.head.xRot = entity.xRot * ((float)Math.PI / 180);
        this.head.yRot = entity.yRot * ((float)Math.PI / 180);
        float f = entity.partialTick;
        if (!entity.jump) {
            this.leg2.zRot += 0.5204f * entity.rightLegAnimation;
            this.leg4.zRot += 0.5204f * entity.rightLegAnimation;
            this.leg6.zRot += 0.5204f * entity.rightLegAnimation;
            this.bone8.zRot -= 0.7198999f * entity.rightLegAnimation;
            this.bone18.zRot -= 0.7198999f * entity.rightLegAnimation;
            this.bone28.zRot -= 0.7198999f * entity.rightLegAnimation;
            this.leg1.zRot -= 0.5204f * entity.leftLegAnimation;
            this.leg3.zRot -= 0.5204f * entity.leftLegAnimation;
            this.leg5.zRot -= 0.5204f * entity.leftLegAnimation;
            this.bone.zRot += 0.7198999f * entity.leftLegAnimation;
            this.bone13.zRot += 0.7198999f * entity.leftLegAnimation;
            this.bone23.zRot += 0.7198999f * entity.leftLegAnimation;
        }
        this.idleAnimation.apply(entity.idleAnimationState, entity.ageInTicks);
        this.walkAnimation.applyWalk(entity.walkAnimationPos, entity.walkAnimationSpeed, 1.0f, 2.5f);
        this.attackAnimation.apply(entity.attackAnimationState, entity.ageInTicks);
        this.deathAnimation.apply(entity.deathAnimationState, entity.ageInTicks);
        this.jumpAnimation.apply(entity.jumpAnimationState, entity.ageInTicks);
        this.graspAnimation.apply(entity.graspAnimationState, entity.ageInTicks);
        this.graspPreAnimation.apply(entity.graspPreAnimationState, entity.ageInTicks);
    }
}

