/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.render.entity;

import baguchi.bagus_lib.client.layer.CustomArmorLayer;
import baguchi.tofucraft.client.TofuModelLayers;
import baguchi.tofucraft.client.model.TofunianModel;
import baguchi.tofucraft.client.render.layer.TofunianClothLayer;
import baguchi.tofucraft.client.render.layer.TofunianEyeLayer;
import baguchi.tofucraft.client.render.layer.TofunianRoleLayer;
import baguchi.tofucraft.client.render.state.TofunianRenderState;
import baguchi.tofucraft.entity.Tofunian;
import com.mojang.blaze3d.vertex.PoseStack;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.LivingEntity;

public class TofunianRender
extends MobRenderer<Tofunian, TofunianRenderState, TofunianModel<TofunianRenderState>> {
    private static final Identifier LOCATION = Identifier.fromNamespaceAndPath((String)"tofucraft", (String)"textures/entity/tofunian/tofunian.png");
    public static final Identifier BAGU_LOCATION = Identifier.fromNamespaceAndPath((String)"tofucraft", (String)"textures/entity/tofunian/secret/bagunian.png");

    public TofunianRender(EntityRendererProvider.Context context) {
        super(context, new TofunianModel(context.bakeLayer(TofuModelLayers.TOFUNIAN)), 0.5f);
        this.addLayer(new TofunianEyeLayer(this));
        this.addLayer(new TofunianClothLayer(this));
        this.addLayer(new TofunianRoleLayer((RenderLayerParent<TofunianRenderState, TofunianModel<TofunianRenderState>>)this));
        this.addLayer((RenderLayer)new CustomArmorLayer((RenderLayerParent)this, context));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getPlayerSkinRenderCache()));
        this.addLayer((RenderLayer)new ItemInHandLayer<TofunianRenderState, TofunianModel<TofunianRenderState>>(this, (RenderLayerParent)this){

            public void submit(PoseStack p_433803_, SubmitNodeCollector p_434482_, int p_433450_, TofunianRenderState p_434546_, float p_433047_, float p_433527_) {
                if (!p_434546_.isBaby) {
                    super.submit(p_433803_, p_434482_, p_433450_, (ArmedEntityRenderState)p_434546_, p_433047_, p_433527_);
                }
            }
        });
    }

    protected void scale(TofunianRenderState p_362272_, PoseStack p_115315_) {
        super.scale((LivingEntityRenderState)p_362272_, p_115315_);
        float var4 = p_362272_.scale;
        this.shadowRadius = p_362272_.isBaby ? 0.25f : 0.5f;
        p_115315_.scale(var4, var4, var4);
    }

    public Identifier getTextureLocation(TofunianRenderState entity) {
        String s;
        if (entity.nameTag != null && (s = ChatFormatting.stripFormatting((String)entity.nameTag.getString())) != null && "bagu_chan".equals(s)) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 || j == 12 && i == 15) {
                return BAGU_LOCATION;
            }
        }
        if (entity.texture != null) {
            return entity.texture;
        }
        return LOCATION;
    }

    public TofunianRenderState createRenderState() {
        return new TofunianRenderState();
    }

    public void extractRenderState(Tofunian tofunian, TofunianRenderState renderState, float partialTick) {
        super.extractRenderState((LivingEntity)tofunian, (LivingEntityRenderState)renderState, partialTick);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)tofunian, (HumanoidRenderState)renderState, (float)partialTick, (ItemModelResolver)this.itemModelResolver);
        renderState.id = tofunian.getId();
        renderState.isPassenger = tofunian.isPassenger() && tofunian.getVehicle() != null && tofunian.getVehicle().shouldRiderSit();
        renderState.unhappyCounter = tofunian.getUnhappyCounter();
        renderState.attackTime = tofunian.attackAnim;
        renderState.eatFoodAnimationState.copyFrom(tofunian.eatFoodAnimationState);
        renderState.happyAnimationState.copyFrom(tofunian.happyAnimationState);
        renderState.waveAnimationState.copyFrom(tofunian.waveAnimationState);
        renderState.actions = tofunian.getAction();
        renderState.roles = tofunian.getRole();
        renderState.clothTexture = tofunian.getClothTexture();
        renderState.texture = tofunian.getTexture();
    }
}

