/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.render.entity.effect;

import baguchi.tofucraft.client.render.state.NattoCobWebRenderState;
import baguchi.tofucraft.entity.effect.NattoCobWebEntity;
import baguchi.tofucraft.registry.TofuItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Quaternionfc;

public class NattoCobWebRender
extends EntityRenderer<NattoCobWebEntity, NattoCobWebRenderState> {
    private final ItemModelResolver itemModelResolver;

    public NattoCobWebRender(EntityRendererProvider.Context context) {
        super(context);
        this.itemModelResolver = context.getItemModelResolver();
    }

    public void submit(NattoCobWebRenderState entity, PoseStack stack, SubmitNodeCollector buffer, CameraRenderState cameraRenderState) {
        float scale;
        boolean isSpawing = entity.isSpawning;
        float f = scale = entity.isSmall ? 0.5f : 1.0f;
        if (isSpawing) {
            stack.pushPose();
            stack.scale(5.5f * scale, 6.0f * scale, 5.5f * scale);
            stack.mulPose((Quaternionfc)entity.direction.getOpposite().getRotation());
            stack.translate(0.0f, 0.0f, -0.125f);
            stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            entity.item.submit(stack, buffer, entity.lightCoords, OverlayTexture.NO_OVERLAY, entity.outlineColor);
            stack.popPose();
        } else {
            stack.pushPose();
            stack.scale(6.0f * scale, 6.0f * scale, 6.0f * scale);
            stack.mulPose((Quaternionfc)entity.direction.getRotation());
            stack.translate(0.0f, 0.0f, -0.125f);
            stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            entity.item.submit(stack, buffer, entity.lightCoords, OverlayTexture.NO_OVERLAY, entity.outlineColor);
            stack.popPose();
        }
        super.submit((EntityRenderState)entity, stack, buffer, cameraRenderState);
    }

    public NattoCobWebRenderState createRenderState() {
        return new NattoCobWebRenderState();
    }

    public void extractRenderState(NattoCobWebEntity p_362104_, NattoCobWebRenderState p_361028_, float p_362204_) {
        super.extractRenderState((Entity)p_362104_, (EntityRenderState)p_361028_, p_362204_);
        p_361028_.direction = p_362104_.getAttachFace();
        p_361028_.isSpawning = p_362104_.isSpawing();
        p_361028_.isSmall = p_362104_.isSmall();
        this.itemModelResolver.updateForNonLiving(p_361028_.item, ((Item)TofuItems.NATTO_COBWEB.get()).getDefaultInstance(), ItemDisplayContext.GROUND, (Entity)p_362104_);
    }
}

