/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.screen;

import baguchi.tofucraft.blockentity.fluid.FluidContainer;
import baguchi.tofucraft.client.recipe.TofuPotRecipeBookComponent;
import baguchi.tofucraft.inventory.TofuPotMenu;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.data.AtlasIds;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import org.joml.Matrix3x2fStack;

public class TofuPotScreen
extends AbstractRecipeBookScreen<TofuPotMenu> {
    private static final WidgetSprites RECIPE_BUTTON = new WidgetSprites(Identifier.withDefaultNamespace((String)"recipe_book/button"), Identifier.withDefaultNamespace((String)"recipe_book/button"));
    private static final Identifier BACKGROUND_TEXTURE = Identifier.fromNamespaceAndPath((String)"tofucraft", (String)"textures/gui/tofu_pot.png");
    private static final Rectangle HEAT_ICON = new Rectangle(14, 43, 14, 14);
    private static final Rectangle PROGRESS_ARROW = new Rectangle(103, 38, 24, 17);
    private int tick;

    public TofuPotScreen(TofuPotMenu screenContainer, Inventory inv, Component titleIn) {
        super((RecipeBookMenu)screenContainer, (RecipeBookComponent)new TofuPotRecipeBookComponent(screenContainer), inv, titleIn);
    }

    public void init() {
        super.init();
        this.imageHeight = 177;
        this.titleLabelX = 100;
        this.inventoryLabelY = this.imageHeight - 96 + 2;
    }

    public void containerTick() {
        super.containerTick();
        ++this.tick;
    }

    protected ScreenPosition getRecipeBookButtonPosition() {
        return new ScreenPosition(this.leftPos + 5, this.height / 2 - 19);
    }

    protected void renderLabels(GuiGraphics gui, int mouseX, int mouseY) {
        super.renderLabels(gui, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        FluidContainer fluidTank;
        int heightInd;
        if (this.minecraft == null) {
            return;
        }
        gui.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        if (((TofuPotMenu)this.menu).isHeated()) {
            gui.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_TEXTURE, this.leftPos + TofuPotScreen.HEAT_ICON.x, this.topPos + TofuPotScreen.HEAT_ICON.y, 176.0f, 0.0f, TofuPotScreen.HEAT_ICON.width, TofuPotScreen.HEAT_ICON.height, 256, 256);
        }
        if ((heightInd = (int)(44.0f * (float)(fluidTank = ((TofuPotMenu)this.menu).blockEntity.fluidTank).getAmountAsInt(0) / (float)fluidTank.getCapacityAsInt(0, (Resource)((FluidResource)fluidTank.getResource(0))))) > 0) {
            TofuPotScreen.renderFluidStack(gui, gui.pose(), this.leftPos + 158, this.topPos + 69, 10, heightInd, ((FluidResource)fluidTank.getResource(0)).getFluid());
        }
        int l = ((TofuPotMenu)this.menu).getCookProgressionScaled();
        gui.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_TEXTURE, this.leftPos + TofuPotScreen.PROGRESS_ARROW.x, this.topPos + TofuPotScreen.PROGRESS_ARROW.y, 176.0f, 15.0f, l + 1, TofuPotScreen.PROGRESS_ARROW.height, 256, 256);
    }

    public static void renderFluidStack(GuiGraphics guiGraphics, Matrix3x2fStack stack, int xPosition, int yPosition, int desiredWidth, int desiredHeight, Fluid fluid) {
        TextureAtlasSprite sprite = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS).getSprite(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture());
        int color = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int xTileCount = desiredWidth / 16;
        int xRemainder = desiredWidth - xTileCount * 16;
        int yTileCount = desiredHeight / 16;
        int yRemainder = desiredHeight - yTileCount * 16;
        float uMin = sprite.getU0();
        float uMax = sprite.getU1();
        float vMin = sprite.getV0();
        float vMax = sprite.getV1();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, xPosition, yPosition - desiredHeight, desiredWidth, desiredHeight, color);
    }
}

