/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.toast;

import baguchi.tofucraft.registry.TofuItems;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;

public class LearningToast
implements Toast {
    private static final Identifier BACKGROUND_SPRITE = Identifier.withDefaultNamespace((String)"toast/recipe");
    private final Component description;
    private long lastChanged;
    private boolean changed;
    private boolean playedSound;
    private Toast.Visibility wantedVisibility = Toast.Visibility.HIDE;

    public LearningToast(Component description) {
        this.description = description;
    }

    public Toast.Visibility getWantedVisibility() {
        return this.wantedVisibility;
    }

    public void update(ToastManager p_363415_, long p_363939_) {
        if (!this.playedSound && p_363939_ > 0L) {
            this.playedSound = true;
            p_363415_.getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f, (float)1.0f));
        }
        this.wantedVisibility = (double)p_363939_ >= 5000.0 * p_363415_.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public void render(GuiGraphics guiGraphics, Font font, long timeSinceLastVisible) {
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        List list = font.split((FormattedText)this.description, 125);
        int i = 0xFFFF00;
        if (list.size() == 1) {
            guiGraphics.drawString(font, this.description, 32, 18, -1, false);
            guiGraphics.renderFakeItem(((Item)TofuItems.TOFU_CRAFTERS_BOOK.get()).getDefaultInstance(), 8, 8);
        } else {
            int l = this.height() / 2 - list.size() * 9 / 2;
            for (FormattedCharSequence formattedcharsequence : list) {
                guiGraphics.drawString(font, formattedcharsequence, 30, l, -1, false);
                l += 9;
            }
            guiGraphics.renderFakeItem(((Item)TofuItems.TOFU_CRAFTERS_BOOK.get()).getDefaultInstance(), 8, 8);
        }
    }
}

