/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.data.generator.recipe.builder;

import baguchi.tofucraft.recipe.TofuPotCategory;
import baguchi.tofucraft.recipe.TofuPotShapelessRecipe;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class TofuPotShapelessRecipeBuilder
implements RecipeBuilder {
    private final HolderGetter<Item> items;
    private final TofuPotCategory category;
    private final Item result;
    private final int count;
    private final ItemStack resultStack;
    private final NonNullList<Ingredient> ingredients = NonNullList.create();
    private final Optional<SizedFluidIngredient> fluidIngredient;
    private final int cookTime;
    private final float experience;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;

    public TofuPotShapelessRecipeBuilder(HolderGetter<Item> items, TofuPotCategory category, ItemLike result, Optional<SizedFluidIngredient> fluidIngredient, int count, int cookTime, float experience) {
        this(items, category, new ItemStack(result, count), fluidIngredient, cookTime, experience);
    }

    public TofuPotShapelessRecipeBuilder(HolderGetter<Item> items, TofuPotCategory p_250837_, ItemStack result, Optional<SizedFluidIngredient> fluidIngredient, int cookTime, float experience) {
        this.items = items;
        this.category = p_250837_;
        this.result = result.getItem();
        this.count = result.getCount();
        this.resultStack = result;
        this.fluidIngredient = fluidIngredient;
        this.cookTime = cookTime;
        this.experience = experience;
    }

    public static TofuPotShapelessRecipeBuilder shapeless(HolderGetter<Item> holderGetter, TofuPotCategory category, Optional<SizedFluidIngredient> fluidIngredient, ItemLike result, int cookTime, float experience) {
        return new TofuPotShapelessRecipeBuilder(holderGetter, category, result, fluidIngredient, 1, cookTime, experience);
    }

    public static TofuPotShapelessRecipeBuilder shapeless(HolderGetter<Item> holderGetter, TofuPotCategory category, Optional<SizedFluidIngredient> fluidIngredient, ItemLike result, int count, int cookTime, float experience) {
        return new TofuPotShapelessRecipeBuilder(holderGetter, category, result, fluidIngredient, count, cookTime, experience);
    }

    public static TofuPotShapelessRecipeBuilder shapeless(HolderGetter<Item> holderGetter, TofuPotCategory p_252339_, Optional<SizedFluidIngredient> fluidIngredient, ItemStack result, int cookTime, float experience) {
        return new TofuPotShapelessRecipeBuilder(holderGetter, p_252339_, result, fluidIngredient, cookTime, experience);
    }

    public static TofuPotShapelessRecipeBuilder shapeless(HolderGetter<Item> holderGetter, TofuPotCategory p_252339_, Optional<SizedFluidIngredient> fluidIngredient, ItemStack result, int cookTime) {
        return new TofuPotShapelessRecipeBuilder(holderGetter, p_252339_, result, fluidIngredient, cookTime, 0.1f);
    }

    public static TofuPotShapelessRecipeBuilder shapeless(HolderGetter<Item> holderGetter, TofuPotCategory p_252339_, Optional<SizedFluidIngredient> fluidIngredient, ItemStack result) {
        return new TofuPotShapelessRecipeBuilder(holderGetter, p_252339_, result, fluidIngredient, 300, 0.1f);
    }

    public static TofuPotShapelessRecipeBuilder shapeless(HolderGetter<Item> holderGetter, TofuPotCategory p_252339_, ItemStack result) {
        return new TofuPotShapelessRecipeBuilder(holderGetter, p_252339_, result, Optional.empty(), 300, 0.1f);
    }

    public static TofuPotShapelessRecipeBuilder shapeless(HolderGetter<Item> holderGetter, TofuPotCategory p_252339_, Item result) {
        return new TofuPotShapelessRecipeBuilder(holderGetter, p_252339_, new ItemStack((ItemLike)result), Optional.empty(), 300, 0.1f);
    }

    public TofuPotShapelessRecipeBuilder requires(TagKey<Item> p_206420_) {
        return this.requires(Ingredient.of((HolderSet)this.items.getOrThrow(p_206420_)));
    }

    public TofuPotShapelessRecipeBuilder requires(ItemLike item) {
        return this.requires(item, 1);
    }

    public TofuPotShapelessRecipeBuilder requires(ItemLike item, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.requires(Ingredient.of((ItemLike)item));
        }
        return this;
    }

    public TofuPotShapelessRecipeBuilder requires(Ingredient ingredient) {
        return this.requires(ingredient, 1);
    }

    public TofuPotShapelessRecipeBuilder requires(Ingredient ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add((Object)ingredient);
        }
        return this;
    }

    public TofuPotShapelessRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public TofuPotShapelessRecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput recipeOutput, ResourceKey<Recipe<?>> resourceKey) {
        this.ensureValid(resourceKey.identifier());
        Advancement.Builder advancement$builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(resourceKey)).rewards(AdvancementRewards.Builder.recipe(resourceKey)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        TofuPotShapelessRecipe shapelessrecipe = new TofuPotShapelessRecipe(Objects.requireNonNullElse(this.group, ""), this.category, this.resultStack, (List<Ingredient>)this.ingredients, this.fluidIngredient, this.cookTime, this.experience);
        recipeOutput.accept(resourceKey, (Recipe)shapelessrecipe, advancement$builder.build(resourceKey.identifier().withPrefix("recipes/" + this.category.getSerializedName() + "/")));
    }

    private void ensureValid(Identifier id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
        }
    }
}

