/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.data.resources.registries;

import baguchi.tofucraft.TofuCraftReload;
import baguchi.tofucraft.api.entity.TofunianVariant;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;

public class TofunianVariants {
    public static final ResourceKey<Registry<TofunianVariant>> TOFUNIAN_VARIANT_REGISTRY_KEY = ResourceKey.createRegistryKey((Identifier)Identifier.fromNamespaceAndPath((String)"tofucraft", (String)"tofunian_variant"));
    public static final ResourceKey<TofunianVariant> PLAIN = TofunianVariants.createKey("plain");
    public static final ResourceKey<TofunianVariant> ZUNDA = TofunianVariants.createKey("zunda");
    public static final ResourceKey<TofunianVariant> STRAWBERRY = TofunianVariants.createKey("strawberry");
    public static final ResourceKey<TofunianVariant> EGG = TofunianVariants.createKey("egg");
    public static final ResourceKey<TofunianVariant> MISO = TofunianVariants.createKey("miso");
    public static final ResourceKey<TofunianVariant> DEFAULT = PLAIN;

    private static ResourceKey<TofunianVariant> createKey(String name) {
        return ResourceKey.create(TOFUNIAN_VARIANT_REGISTRY_KEY, (Identifier)Identifier.fromNamespaceAndPath((String)"tofucraft", (String)name));
    }

    static void register(BootstrapContext<TofunianVariant> context, ResourceKey<TofunianVariant> key, String name) {
        Identifier resourcelocation = TofuCraftReload.prefix("entity/tofunian/variant/" + name);
        context.register(key, (Object)new TofunianVariant(resourcelocation));
    }

    public static Holder<TofunianVariant> getRandomVariant(RegistryAccess p_332694_, RandomSource randomSource) {
        Registry registry = p_332694_.lookupOrThrow(TOFUNIAN_VARIANT_REGISTRY_KEY);
        return (Holder)registry.getRandom(randomSource).orElse(registry.getOrThrow(DEFAULT));
    }

    public static void bootstrap(BootstrapContext<TofunianVariant> context) {
        TofunianVariants.register(context, PLAIN, "tofunian_plain");
        TofunianVariants.register(context, ZUNDA, "tofunian_zunda");
        TofunianVariants.register(context, STRAWBERRY, "tofunian_strawberry");
        TofunianVariants.register(context, EGG, "tofunian_egg");
        TofunianVariants.register(context, MISO, "tofunian_miso");
    }
}

