/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity.projectile;

import baguchi.tofucraft.registry.TofuEntityTypes;
import baguchi.tofucraft.registry.TofuParticleTypes;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class NattoBallEntity
extends ThrowableProjectile {
    protected static final EntityDataAccessor<Boolean> DATA_SMALL = SynchedEntityData.defineId(NattoBallEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public NattoBallEntity(EntityType<? extends NattoBallEntity> p_36892_, Level p_36893_) {
        super(p_36892_, p_36893_);
    }

    public NattoBallEntity(Level worldIn, LivingEntity throwerIn) {
        super(TofuEntityTypes.NATTO_BALL.get(), throwerIn.getX(), throwerIn.getEyeY(), throwerIn.getZ(), worldIn);
        this.setOwner((Entity)throwerIn);
    }

    public boolean isSmall() {
        return (Boolean)this.entityData.get(DATA_SMALL);
    }

    public void setSmall(boolean p_149789_) {
        this.entityData.set(DATA_SMALL, (Object)p_149789_);
    }

    public void readAdditionalSaveData(ValueInput p_33432_) {
        super.readAdditionalSaveData(p_33432_);
        this.setSmall(p_33432_.getBooleanOr("Small", false));
    }

    public void addAdditionalSaveData(ValueOutput p_33443_) {
        super.addAdditionalSaveData(p_33443_);
        p_33443_.putBoolean("Small", this.isSmall());
    }

    protected boolean canHitEntity(Entity p_37250_) {
        return false;
    }

    protected void onHit(HitResult p_36913_) {
        super.onHit(p_36913_);
        if (!(p_36913_.getType() == HitResult.Type.ENTITY && this.ownedBy(((EntityHitResult)p_36913_).getEntity()) || this.level().isClientSide())) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                float scale = this.isSmall() ? 0.5f : 1.0f;
                for (int i = 0; i < 8; ++i) {
                    double d3 = this.random.nextGaussian() * 0.04 * (double)scale;
                    double d1 = this.random.nextGaussian() * 0.04 * (double)scale;
                    double d2 = this.random.nextGaussian() * 0.04 * (double)scale;
                    serverLevel.sendParticles((ParticleOptions)TofuParticleTypes.SIMPLE_STINKE.get(), this.position().x, this.position().y, this.position().z, 1, d3, d1, d2, (double)0.15f);
                }
            }
            this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.0f, 1.0f);
            List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(4.0, 2.0, 4.0));
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                areaeffectcloud.setOwner((LivingEntity)entity);
            }
            areaeffectcloud.setCustomParticle((ParticleOptions)TofuParticleTypes.SIMPLE_STINKE.get());
            areaeffectcloud.setRadius(this.isSmall() ? 1.25f : 3.0f);
            areaeffectcloud.setDuration(this.isSmall() ? 80 : 200);
            areaeffectcloud.addEffect(new MobEffectInstance(MobEffects.INSTANT_DAMAGE, 1, 1));
            if (!list.isEmpty()) {
                for (LivingEntity livingentity : list) {
                    double d0 = this.distanceToSqr((Entity)livingentity);
                    if (!(d0 < 16.0)) continue;
                    areaeffectcloud.setPos(livingentity.getX(), livingentity.getY(), livingentity.getZ());
                    break;
                }
            }
            this.level().addFreshEntity((Entity)areaeffectcloud);
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_SMALL, (Object)false);
    }

    public boolean isPickable() {
        return false;
    }
}

