/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.item;

import baguchi.tofucraft.attachment.TofuLivingAttachment;
import baguchi.tofucraft.registry.TofuAdvancements;
import baguchi.tofucraft.registry.TofuAttachments;
import baguchi.tofucraft.registry.TofuEffects;
import baguchi.tofucraft.registry.TofuItems;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.happyghast.HappyGhast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.UseRemainder;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class GhastFoodItem
extends Item {
    public GhastFoodItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, TooltipDisplay p_399753_, Consumer<Component> p_399884_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_399753_, p_399884_, p_41424_);
        if (p_41421_.is(TofuItems.SOUL_HIYAYAKKO_GLASS)) {
            p_399884_.accept((Component)Component.translatable((String)"tofucraft.has_soul_for_happy_ghast").withStyle(ChatFormatting.AQUA));
        }
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        HappyGhast wolf;
        if (target instanceof HappyGhast && (wolf = (HappyGhast)target).isAlive()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @EventBusSubscriber(modid="tofucraft")
    public static class SoyFoodEvent {
        @SubscribeEvent
        public static void onSoyFoodForHappyGhast(PlayerInteractEvent.EntityInteract event) {
            Player player = event.getEntity();
            Entity target = event.getTarget();
            ItemStack itemStack = event.getItemStack();
            if (target instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)target;
                if (target instanceof HappyGhast) {
                    HappyGhast happyGhast = (HappyGhast)target;
                    if (entity.isAlive() && itemStack.is(TofuItems.SOUL_HIYAYAKKO_GLASS)) {
                        if (!((TofuLivingAttachment)happyGhast.getData(TofuAttachments.TOFU_LIVING)).isEatCooldown()) {
                            Player player2;
                            entity.heal(3.0f);
                            entity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 3200, 3));
                            entity.addEffect(new MobEffectInstance(TofuEffects.SOY_HEALTHY, 3200, 1));
                            ((TofuLivingAttachment)happyGhast.getData(TofuAttachments.TOFU_LIVING)).setEatCooldown(3200);
                            entity.level().playSound(null, target.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EAT.value(), SoundSource.PLAYERS, 0.8f, 0.8f);
                            if (itemStack.has(DataComponents.USE_REMAINDER) && !player.isCreative()) {
                                player.addItem(((UseRemainder)itemStack.get(DataComponents.USE_REMAINDER)).convertInto());
                                itemStack.shrink(1);
                            }
                            if ((player2 = event.getEntity()) instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player2;
                                TofuAdvancements.TOO_COLD.get().trigger(serverPlayer);
                            }
                            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                            event.setCanceled(true);
                        } else {
                            player.displayClientMessage((Component)Component.translatable((String)"tofucraft.soy_food.cannot_give_on_wolf", (Object[])new Object[]{happyGhast.getName()}), true);
                            event.setCancellationResult((InteractionResult)InteractionResult.FAIL);
                            event.setCanceled(true);
                        }
                    }
                }
            }
        }
    }
}

