/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.item;

import baguchi.tofucraft.client.ClientProxy;
import baguchi.tofucraft.network.OpenTofuBookPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class TofuBookItem
extends Item {
    public TofuBookItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        if (p_41432_.isClientSide()) {
            ClientProxy.handleOpenPageTest(p_41433_);
        }
        return super.use(p_41432_, p_41433_, p_41434_);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if (state.is(Blocks.LECTERN) && LecternBlock.tryPlaceBook((LivingEntity)context.getPlayer(), (Level)level, (BlockPos)pos, (BlockState)state, (ItemStack)context.getItemInHand())) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void interactWithBlock(PlayerInteractEvent.RightClickBlock event) {
        LecternBlockEntity lectern;
        ItemStack book;
        BlockEntity blockEntity;
        Level world = event.getLevel();
        if (world.isClientSide()) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = world.getBlockState(pos);
        if (state.is(Blocks.LECTERN) && (blockEntity = world.getBlockEntity(pos)) instanceof LecternBlockEntity && !(book = (lectern = (LecternBlockEntity)blockEntity).getBook()).isEmpty() && book.getItem() instanceof TofuBookItem) {
            OpenTofuBookPacket message = new OpenTofuBookPacket((LivingEntity)event.getEntity());
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)event.getEntity(), (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
            event.setCanceled(true);
        }
    }
}

