/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.item.armor;

import baguchi.tofucraft.item.armor.BreakableTofuArmorItem;
import baguchi.tofucraft.registry.TofuDataComponents;
import com.google.common.base.Suppliers;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;

public class BreakableTofuBootsItem
extends BreakableTofuArmorItem {
    private final Supplier<ItemAttributeModifiers> defaultModifiers = Suppliers.memoize(() -> {
        ItemAttributeModifiers.Builder itemattributemodifiers$builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup equipmentslotgroup = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        Identifier resourcelocation = Identifier.withDefaultNamespace((String)("armor." + type.getName()));
        itemattributemodifiers$builder.add(Attributes.FALL_DAMAGE_MULTIPLIER, new AttributeModifier(resourcelocation, (double)reduceFallDamage, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), equipmentslotgroup);
        return itemattributemodifiers$builder.build();
    });

    public BreakableTofuBootsItem(ArmorMaterial tofuArmorMaterial, ArmorType type, float reduceFallDamage, Item.Properties properties) {
        super(tofuArmorMaterial, type, properties);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return this.defaultModifiers.get();
    }

    public int getUnstability(ItemStack inst) {
        return inst.get(TofuDataComponents.UNSTABILITY) != null ? (Integer)inst.get(TofuDataComponents.UNSTABILITY) : 0;
    }

    public int getFallDurability(ItemStack inst) {
        return inst.get(TofuDataComponents.MAX_FALL_DURABILITY) != null ? (Integer)inst.get(TofuDataComponents.MAX_FALL_DURABILITY) : 1;
    }

    private boolean getShowState(ItemStack stack) {
        return this.getUnstability(stack) != 0;
    }

    public boolean isBarVisible(ItemStack p_150899_) {
        return this.getShowState(p_150899_) || super.isBarVisible(p_150899_);
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f - (float)this.getUnstability(stack) * 13.0f / (float)this.getFallDurability(stack));
    }

    public int getBarColor(ItemStack p_150901_) {
        return this.getShowState(p_150901_) ? Color.white.getRGB() : super.getBarColor(p_150901_);
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, TooltipDisplay p_399753_, Consumer<Component> p_399884_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_399753_, p_399884_, p_41424_);
        p_399884_.accept((Component)Component.translatable((String)"tooltip.tofucraft.tofu_boots", (Object[])new Object[]{this.getUnstability(p_41421_), this.getFallDurability(p_41421_)}));
    }
}

