/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.item.tool;

import baguchi.tofucraft.api.tfenergy.IEnergyContained;
import baguchi.tofucraft.api.tfenergy.IEnergyInsertable;
import baguchi.tofucraft.api.tfenergy.TFEnergyData;
import baguchi.tofucraft.attachment.TofuLivingAttachment;
import baguchi.tofucraft.registry.TofuAttachments;
import baguchi.tofucraft.registry.TofuDataComponents;
import baguchi.tofucraft.registry.TofuToolMaterials;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class ZundaAlloySwordItem
extends Item
implements IEnergyInsertable,
IEnergyContained {
    public ZundaAlloySwordItem(Item.Properties p_43089_) {
        super(p_43089_.sword(TofuToolMaterials.ZUNDA_ALLOY, 3.0f, -2.3f));
    }

    public InteractionResult use(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (playerIn.isShiftKeyDown() && this.getEnergy(itemstack) >= 100) {
            playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
            playerIn.getCooldowns().addCooldown(itemstack, 120);
            this.drain(itemstack, 100, false);
            ((TofuLivingAttachment)playerIn.getData(TofuAttachments.TOFU_LIVING.get())).busterAnimation((Entity)playerIn, handIn);
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.use(levelIn, playerIn, handIn);
    }

    public int drain(ItemStack inst, int amount, boolean simulate) {
        if (!simulate) {
            int calculated2 = Math.min(this.getEnergy(inst), amount);
            this.setEnergy(inst, this.getEnergy(inst) - calculated2);
            return calculated2;
        }
        return 0;
    }

    @Override
    public int fill(ItemStack inst, int energy, boolean simulate) {
        int calculated = Math.min(energy, inst.getDamageValue());
        if (!simulate) {
            if (inst.getDamageValue() > 0) {
                inst.setDamageValue(Mth.clamp((int)(inst.getDamageValue() - calculated), (int)0, (int)inst.getMaxDamage()));
                return calculated * 5;
            }
            int calculated2 = Math.min(energy, this.getEnergyMax(inst) - this.getEnergy(inst));
            this.setEnergy(inst, this.getEnergy(inst) + calculated2);
            return calculated2;
        }
        return 0;
    }

    @Override
    public int getEnergy(ItemStack inst) {
        return inst.get(TofuDataComponents.TF_ENERGY_DATA) != null ? ((TFEnergyData)inst.get(TofuDataComponents.TF_ENERGY_DATA)).storeTF() : 0;
    }

    @Override
    public int getEnergyMax(ItemStack inst) {
        return inst.get(TofuDataComponents.TF_ENERGY_DATA) != null ? ((TFEnergyData)inst.get(TofuDataComponents.TF_ENERGY_DATA)).maxTF() : 5000;
    }

    @Override
    public void setEnergy(ItemStack inst, int amount) {
        inst.set(TofuDataComponents.TF_ENERGY_DATA, (Object)new TFEnergyData(amount, this.getEnergyMax(inst)));
    }

    @Override
    public void setEnergyMax(ItemStack inst, int amount) {
        inst.set(TofuDataComponents.TF_ENERGY_DATA, (Object)new TFEnergyData(this.getEnergy(inst), amount));
    }

    private boolean getShowState(ItemStack stack) {
        return this.getEnergy(stack) != 0 && Minecraft.getInstance().player != null && Minecraft.getInstance().player.isShiftKeyDown();
    }

    public boolean isBarVisible(ItemStack p_150899_) {
        return this.getShowState(p_150899_) || super.isBarVisible(p_150899_);
    }

    public int getBarWidth(ItemStack stack) {
        return this.getShowState(stack) ? Math.round((float)this.getEnergy(stack) / (float)this.getEnergyMax(stack) * 13.0f) : super.getBarWidth(stack);
    }

    public int getBarColor(ItemStack p_150901_) {
        return this.getShowState(p_150901_) ? Color.white.getRGB() : super.getBarColor(p_150901_);
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, TooltipDisplay p_399753_, Consumer<Component> p_399884_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_399753_, p_399884_, p_41424_);
        p_399884_.accept((Component)Component.translatable((String)"tooltip.tofucraft.energy", (Object[])new Object[]{this.getEnergy(p_41421_), this.getEnergyMax(p_41421_)}));
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) || enchantment.is(Enchantments.POWER);
    }
}

