/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.utils;

import baguchi.tofucraft.registry.TofuEnchantments;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;

public class TofuDiamondToolUtil {
    protected static BlockHitResult rayTrace(Level level, Player playerIn, boolean useLiquids) {
        float f = playerIn.getXRot();
        float f1 = playerIn.getYRot();
        double d0 = playerIn.getX();
        double d1 = playerIn.getY() + (double)playerIn.getEyeHeight();
        double d2 = playerIn.getZ();
        Vec3 vec3d = new Vec3(d0, d1, d2);
        float f2 = Mth.cos((double)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((double)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((double)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((double)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = playerIn.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        Vec3 vec3d1 = vec3d.add((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return level.clip(new ClipContext(vec3d, vec3d1, ClipContext.Block.COLLIDER, !useLiquids ? ClipContext.Fluid.NONE : ClipContext.Fluid.ANY, (Entity)playerIn));
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(ItemStack stack, Level world, Player player, BlockPos origin, int width, int height, int depth) {
        return TofuDiamondToolUtil.calcAOEBlocks(stack, world, player, origin, width, height, depth, -1);
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(ItemStack stack, Level world, Player player, BlockPos origin, int width, int height, int depth, int distance) {
        int z;
        int y;
        int x;
        if (stack.isEmpty()) {
            return ImmutableList.of();
        }
        BlockState state = world.getBlockState(origin);
        if (state.isAir()) {
            return ImmutableList.of();
        }
        BlockHitResult mop = TofuDiamondToolUtil.rayTrace(world, player, true);
        if (!(mop != null && origin.equals((Object)mop.getBlockPos()) || (mop = TofuDiamondToolUtil.rayTrace(world, player, false)) != null && origin.equals((Object)mop.getBlockPos()))) {
            return ImmutableList.of();
        }
        BlockPos start = origin;
        switch (mop.getDirection()) {
            case DOWN: 
            case UP: {
                Vec3i vec = player.getDirection().getUnitVec3i();
                x = vec.getX() * height + vec.getZ() * width;
                y = mop.getDirection().getAxisDirection().getStep() * -depth;
                z = vec.getX() * width + vec.getZ() * height;
                start = start.offset(-x / 2, 0, -z / 2);
                if (x % 2 == 0) {
                    if (x > 0 && mop.getLocation().x - (double)mop.getBlockPos().getX() > 0.5) {
                        start = start.offset(1, 0, 0);
                    } else if (x < 0 && mop.getLocation().x - (double)mop.getBlockPos().getX() < 0.5) {
                        start = start.offset(-1, 0, 0);
                    }
                }
                if (z % 2 != 0) break;
                if (z > 0 && mop.getLocation().z - (double)mop.getBlockPos().getZ() > 0.5) {
                    start = start.offset(0, 0, 1);
                    break;
                }
                if (z >= 0 || !(mop.getLocation().z - (double)mop.getBlockPos().getZ() < 0.5)) break;
                start = start.offset(0, 0, -1);
                break;
            }
            case NORTH: 
            case SOUTH: {
                x = width;
                y = height;
                z = mop.getDirection().getAxisDirection().getStep() * -depth;
                start = start.offset(-x / 2, -y / 2, 0);
                if (x % 2 == 0 && mop.getLocation().x - (double)mop.getBlockPos().getX() > 0.5) {
                    start = start.offset(1, 0, 0);
                }
                if (y % 2 != 0 || !(mop.getLocation().y - (double)mop.getBlockPos().getY() > 0.5)) break;
                start = start.offset(0, 1, 0);
                break;
            }
            case WEST: 
            case EAST: {
                x = mop.getDirection().getAxisDirection().getStep() * -depth;
                y = height;
                z = width;
                start = start.offset(0, -y / 2, -z / 2);
                if (y % 2 == 0 && mop.getLocation().y - (double)mop.getBlockPos().getY() > 0.5) {
                    start = start.offset(0, 1, 0);
                }
                if (z % 2 != 0 || !(mop.getLocation().z - (double)mop.getBlockPos().getZ() > 0.5)) break;
                start = start.offset(0, 0, 1);
                break;
            }
            default: {
                z = 0;
                y = 0;
                x = 0;
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int xp = start.getX(); xp != start.getX() + x; xp += x / Mth.abs((int)x)) {
            for (int yp = start.getY(); yp != start.getY() + y; yp += y / Mth.abs((int)y)) {
                for (int zp = start.getZ(); zp != start.getZ() + z; zp += z / Mth.abs((int)z)) {
                    if (xp == origin.getX() && yp == origin.getY() && zp == origin.getZ() || distance > 0 && Mth.abs((int)(xp - origin.getX())) + Mth.abs((int)(yp - origin.getY())) + Mth.abs((int)(zp - origin.getZ())) > distance) continue;
                    builder.add((Object)new BlockPos(xp, yp, zp));
                }
            }
        }
        return builder.build();
    }

    public static void onBlockStartBreak(ItemStack stack, ServerLevel level, Block blockDestroyed, BlockPos pos, Player owner) {
        int lvl = EnchantmentHelper.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(TofuEnchantments.BATCH), (LivingEntity)owner);
        if (lvl > 0) {
            ImmutableList<BlockPos> poses = TofuDiamondToolUtil.calcAOEBlocks(stack, (Level)level, owner, pos, 3, 3, lvl);
            for (BlockPos extraPos : poses) {
                TofuDiamondToolUtil.breakExtraBlock(stack, level, owner, extraPos, pos);
            }
        }
    }

    public static boolean canBreakExtraBlock(ItemStack stack, ServerLevel world, Player player, BlockPos pos, BlockPos refPos) {
        if (world.isEmptyBlock(pos)) {
            return false;
        }
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (stack.getDestroySpeed(state) <= 1.0f) {
            return false;
        }
        BlockState refState = world.getBlockState(refPos);
        FluidState fluidState = world.getFluidState(refPos);
        float refStrength = refState.getDestroySpeed((BlockGetter)world, refPos);
        float strength = state.getDestroySpeed((BlockGetter)world, pos);
        if (!CommonHooks.canEntityDestroy((ServerLevel)world, (BlockPos)pos, (LivingEntity)player) || refStrength / strength > 10.0f) {
            return false;
        }
        if (player.isCreative()) {
            block.playerWillDestroy((Level)world, pos, state, player);
            if (block.onDestroyedByPlayer(state, (Level)world, pos, player, stack, false, fluidState)) {
                block.destroy((LevelAccessor)world, pos, state);
            }
            if (!world.isClientSide() && player instanceof ServerPlayer && ((ServerPlayer)player).connection != null) {
                ((ServerPlayer)player).connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
            }
            return false;
        }
        return true;
    }

    public static void breakExtraBlock(ItemStack stack, ServerLevel level, Player player, BlockPos pos, BlockPos refPos) {
        if (!TofuDiamondToolUtil.canBreakExtraBlock(stack, level, player, pos, refPos) || level.getBlockState(pos).getBlock() != level.getBlockState(refPos).getBlock()) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        FluidState fluidState = level.getFluidState(refPos);
        Block block = state.getBlock();
        stack.mineBlock((Level)level, state, pos, player);
        if (!level.isClientSide()) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (block.onDestroyedByPlayer(state, (Level)level, pos, player, stack, true, fluidState)) {
                block.destroy((LevelAccessor)level, pos, state);
                block.playerDestroy((Level)level, player, pos, state, tileEntity, stack);
            }
            if (((ServerPlayer)player).connection != null) {
                ((ServerPlayer)player).connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            }
        } else {
            level.levelEvent(2001, pos, Block.getId((BlockState)state));
            if (block.onDestroyedByPlayer(state, (Level)level, pos, player, stack, true, fluidState)) {
                block.destroy((LevelAccessor)level, pos, state);
            }
            stack.mineBlock((Level)level, state, pos, player);
            if (stack.getCount() == 0 && stack == player.getMainHandItem()) {
                EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)stack, (InteractionHand)InteractionHand.MAIN_HAND);
                player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            }
            ClientPacketListener netHandlerPlayClient = Minecraft.getInstance().getConnection();
            assert (netHandlerPlayClient != null);
            netHandlerPlayClient.send((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, pos, Minecraft.getInstance().player.getDirection()));
        }
    }
}

