/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.world.gen.features;

import baguchi.tofucraft.TofuCraftReload;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.world.gen.foliage.MushroomFoliagePlacer;
import baguchi.tofucraft.world.gen.foliage.TofuFoliagePlacer;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;

public class ModTreeFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> TOFU_TREE = ModTreeFeatures.registerKey("tofu_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TOFU_TREE_BIG = ModTreeFeatures.registerKey("tofu_tree_big");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ZUNDA_MUSHROOM = ModTreeFeatures.registerKey("zunda_mushroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ZUNDA_MUSHROOM_BIG = ModTreeFeatures.registerKey("zunda_mushroom_big");
    public static final ResourceKey<ConfiguredFeature<?, ?>> APRICOT_TREE = ModTreeFeatures.registerKey("apricot_tree");

    private static TreeConfiguration.TreeConfigurationBuilder createTofuTree() {
        return ModTreeFeatures.createStraightBlobTree((Block)TofuBlocks.ISHITOFU.get(), (Block)TofuBlocks.LEAVES_TOFU.get(), 4, 2).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)TofuBlocks.TOFU_TERRAIN.get())));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createTofuTreeBig() {
        return ModTreeFeatures.createBigTree((Block)TofuBlocks.ISHITOFU.get(), (Block)TofuBlocks.LEAVES_TOFU.get(), 6, 2).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)TofuBlocks.TOFU_TERRAIN.get())));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createZunda() {
        return ModTreeFeatures.createMushroom((Block)TofuBlocks.TOFU_STEM.get(), (Block)TofuBlocks.ZUNDA_MUSHROOM_BLOCK.get(), 3, 2).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)TofuBlocks.TOFU_TERRAIN.get())));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createZundaBig() {
        return ModTreeFeatures.createBigTrunkMushroom((Block)TofuBlocks.TOFU_STEM.get(), (Block)TofuBlocks.ZUNDA_MUSHROOM_BLOCK.get(), 8, 2).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)((Block)TofuBlocks.TOFU_TERRAIN.get())));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(Block trunk, Block leaves, int trunkSize, int foliageSize) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)trunk), (TrunkPlacer)new StraightTrunkPlacer(trunkSize, 2, 0), (BlockStateProvider)BlockStateProvider.simple((Block)leaves), (FoliagePlacer)new TofuFoliagePlacer((IntProvider)ConstantInt.of((int)foliageSize), (IntProvider)ConstantInt.of((int)0), foliageSize + 1), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createBigTrunkMushroom(Block trunk, Block leaves, int trunkSize, int foliageSize) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)trunk), (TrunkPlacer)new FancyTrunkPlacer(trunkSize, 4, 0), (BlockStateProvider)BlockStateProvider.simple((Block)leaves), (FoliagePlacer)new MushroomFoliagePlacer((IntProvider)ConstantInt.of((int)foliageSize), (IntProvider)ConstantInt.of((int)1), foliageSize + 1), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createMushroom(Block trunk, Block leaves, int trunkSize, int foliageSize) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)trunk), (TrunkPlacer)new StraightTrunkPlacer(trunkSize, 2, 0), (BlockStateProvider)BlockStateProvider.simple((Block)leaves), (FoliagePlacer)new MushroomFoliagePlacer((IntProvider)ConstantInt.of((int)foliageSize), (IntProvider)ConstantInt.of((int)0), foliageSize + 1), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createBigTree(Block trunk, Block leaves, int trunkSize, int foliageSize) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)trunk), (TrunkPlacer)new FancyTrunkPlacer(trunkSize, 8, 0), (BlockStateProvider)BlockStateProvider.simple((Block)leaves), (FoliagePlacer)new TofuFoliagePlacer((IntProvider)ConstantInt.of((int)foliageSize), (IntProvider)ConstantInt.of((int)2), foliageSize + 1), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createApricotTree() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LOG), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 1), (BlockStateProvider)BlockStateProvider.simple((Block)((Block)TofuBlocks.LEAVES_APRICOT.get())), (FoliagePlacer)new TofuFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (Identifier)TofuCraftReload.prefix(name));
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        FeatureUtils.register(context, TOFU_TREE, (Feature)Feature.TREE, (FeatureConfiguration)ModTreeFeatures.createTofuTree().build());
        FeatureUtils.register(context, TOFU_TREE_BIG, (Feature)Feature.TREE, (FeatureConfiguration)ModTreeFeatures.createTofuTreeBig().build());
        FeatureUtils.register(context, APRICOT_TREE, (Feature)Feature.TREE, (FeatureConfiguration)ModTreeFeatures.createApricotTree().build());
        FeatureUtils.register(context, ZUNDA_MUSHROOM, (Feature)Feature.TREE, (FeatureConfiguration)ModTreeFeatures.createZunda().build());
        FeatureUtils.register(context, ZUNDA_MUSHROOM_BIG, (Feature)Feature.TREE, (FeatureConfiguration)ModTreeFeatures.createZundaBig().build());
    }
}

