/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block.tfenergy;

import baguchan.tofucraft.blockentity.tfenergy.TFCrafterBlockEntity;
import baguchan.tofucraft.registry.TofuBlockEntitys;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TFCrafterBlock
extends BaseEntityBlock {
    public static final MapCodec<TFCrafterBlock> CODEC = TFCrafterBlock.simpleCodec(TFCrafterBlock::new);
    public static final BooleanProperty CRAFTING = BlockStateProperties.CRAFTING;
    private static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.ORIENTATION;

    public TFCrafterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(ORIENTATION, (Comparable)FrontAndTop.NORTH_UP)).setValue((Property)CRAFTING, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockState rotate(BlockState p_307240_, Rotation p_307431_) {
        return (BlockState)p_307240_.setValue(ORIENTATION, (Comparable)p_307431_.rotation().rotate((FrontAndTop)p_307240_.getValue(ORIENTATION)));
    }

    public BlockState mirror(BlockState p_307514_, Mirror p_307198_) {
        return (BlockState)p_307514_.setValue(ORIENTATION, (Comparable)p_307198_.rotation().rotate((FrontAndTop)p_307514_.getValue(ORIENTATION)));
    }

    protected InteractionResult useWithoutItem(BlockState p_307454_, Level p_307255_, BlockPos p_307303_, Player p_307670_, BlockHitResult p_307546_) {
        if (p_307255_.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = p_307255_.getBlockEntity(p_307303_);
        if (blockentity instanceof TFCrafterBlockEntity) {
            p_307670_.openMenu((MenuProvider)((TFCrafterBlockEntity)blockentity));
        }
        return InteractionResult.CONSUME;
    }

    public void onRemove(BlockState p_48713_, Level p_48714_, BlockPos p_48715_, BlockState p_48716_, boolean p_48717_) {
        if (!p_48713_.is(p_48716_.getBlock())) {
            BlockEntity blockentity = p_48714_.getBlockEntity(p_48715_);
            if (blockentity instanceof TFCrafterBlockEntity) {
                if (p_48714_ instanceof ServerLevel) {
                    Containers.dropContents((Level)p_48714_, (BlockPos)p_48715_, (Container)((TFCrafterBlockEntity)blockentity));
                }
                p_48714_.updateNeighbourForOutputSignal(p_48715_, (Block)this);
            }
            super.onRemove(p_48713_, p_48714_, p_48715_, p_48716_, p_48717_);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState p_307445_) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState p_307633_, Level p_307264_, BlockPos p_307557_) {
        int n;
        BlockEntity blockentity = p_307264_.getBlockEntity(p_307557_);
        if (blockentity instanceof TFCrafterBlockEntity) {
            TFCrafterBlockEntity crafterblockentity = (TFCrafterBlockEntity)blockentity;
            n = crafterblockentity.getRedstoneSignal();
        } else {
            n = 0;
        }
        return n;
    }

    public RenderShape getRenderShape(BlockState p_48727_) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_307200_) {
        p_307200_.add(new Property[]{ORIENTATION, CRAFTING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_307251_) {
        Direction direction = p_307251_.getNearestLookingDirection().getOpposite();
        Direction direction1 = switch (direction) {
            case Direction.DOWN -> p_307251_.getHorizontalDirection().getOpposite();
            case Direction.UP -> p_307251_.getHorizontalDirection();
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> Direction.UP;
            default -> throw new IncompatibleClassChangeError();
        };
        return (BlockState)this.defaultBlockState().setValue(ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)direction, (Direction)direction1));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return new TFCrafterBlockEntity(p_153215_, p_153216_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_152382_, BlockState p_152383_, BlockEntityType<T> p_152384_) {
        return TFCrafterBlock.createTicker(p_152382_, p_152384_, TofuBlockEntitys.TF_CRAFTER.get());
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level p_151988_, BlockEntityType<T> p_151989_, BlockEntityType<? extends TFCrafterBlockEntity> p_151990_) {
        return TFCrafterBlock.createTickerHelper(p_151989_, p_151990_, TFCrafterBlockEntity::tick);
    }
}

