/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.blockentity;

import baguchan.tofucraft.blockentity.SyncedBlockEntity;
import baguchan.tofucraft.registry.TofuBlockEntitys;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class FoodPlateBlockEntity
extends SyncedBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private boolean fire;

    public FoodPlateBlockEntity(BlockPos pos, BlockState state) {
        super(TofuBlockEntitys.FOODPLATE.get(), pos, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider p_338445_) {
        super.loadAdditional(compound, p_338445_);
        this.inventory.deserializeNBT(p_338445_, compound.getCompound("Inventory"));
        this.fire = compound.getBoolean("Fire");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider p_338445_) {
        super.saveAdditional(compound, p_338445_);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(p_338445_));
        compound.putBoolean("Fire", this.fire);
    }

    public boolean addItem(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.isEmpty()) {
            this.inventory.setStackInSlot(0, itemStack.split(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public boolean addAllItem(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.isEmpty()) {
            this.inventory.setStackInSlot(0, itemStack.split(64));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            ItemStack item = this.getStoredItem().split(1);
            this.inventoryChanged();
            if (this.isFire()) {
                this.setFire(false);
            }
            return item;
        }
        return ItemStack.EMPTY;
    }

    public void setFire(boolean fire) {
        this.fire = fire;
        this.inventoryChanged();
    }

    public boolean isFire() {
        return this.fire;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).isEmpty();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            public int getSlotLimit(int slot) {
                return 64;
            }

            protected void onContentsChanged(int slot) {
                FoodPlateBlockEntity.this.inventoryChanged();
            }
        };
    }
}

