/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.compat.jei;

import baguchan.tofucraft.compat.jei.JEIPlugin;
import baguchan.tofucraft.recipe.TFCraftingRecipe;
import baguchan.tofucraft.recipe.TFShapedRecipe;
import baguchan.tofucraft.registry.TofuBlocks;
import java.util.Iterator;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class TFRecipeCategory
implements IRecipeCategory<TFCraftingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tf_craft");
    protected final IDrawableAnimated arrow;
    private final Component title = Component.translatable((String)"tofucraft.jei.tf_craft");
    private final IDrawable background;
    private final IDrawable icon;

    public TFRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"textures/gui/tf_crafting_table.png");
        this.background = helper.createDrawable(backgroundImage, 10, 12, 141, 63);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)TofuBlocks.TF_CRAFTING_TABLE.get()));
        this.arrow = helper.drawableBuilder(backgroundImage, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getRegistryName(TFCraftingRecipe recipe) {
        return UID;
    }

    public RecipeType<TFCraftingRecipe> getRecipeType() {
        return JEIPlugin.TF_RECIPE_JEI_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TFCraftingRecipe recipe, IFocusGroup focuses) {
        NonNullList recipeIngredients = recipe.getIngredients();
        int startX = 8;
        int startY = 18;
        int inputStartX = 20;
        int inputStartY = 5;
        int borderSlotSize = 18;
        int sizeWidth = 3;
        int sizeHeight = 3;
        if (recipe instanceof TFShapedRecipe) {
            TFShapedRecipe shapedRecipe = (TFShapedRecipe)recipe;
            sizeWidth = shapedRecipe.getWidth();
            sizeHeight = shapedRecipe.getHeight();
        }
        Iterator ingredients = recipeIngredients.iterator();
        for (int row = 0; row < sizeHeight; ++row) {
            for (int column = 0; column < sizeWidth && ingredients.hasNext(); ++column) {
                builder.addSlot(RecipeIngredientRole.INPUT, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize).addIngredients((Ingredient)ingredients.next());
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 113, 22).addItemStack(recipe.getResult().copy());
    }

    public void draw(TFCraftingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.arrow.draw(stack, 79, 22);
    }
}

