/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity;

import bagu_chan.bagus_lib.client.camera.CameraCore;
import bagu_chan.bagus_lib.client.camera.holder.CameraHolder;
import bagu_chan.bagus_lib.client.camera.holder.EntityCameraHolder;
import bagu_chan.bagus_lib.entity.ISmartJump;
import bagu_chan.bagus_lib.util.GlobalVec3;
import baguchan.tofucraft.entity.AbstractTofunian;
import baguchan.tofucraft.entity.ShuDofuSpiderPart;
import baguchan.tofucraft.entity.TofuSpider;
import baguchan.tofucraft.entity.effect.NattoCobWebEntity;
import baguchan.tofucraft.entity.projectile.FukumameEntity;
import baguchan.tofucraft.entity.projectile.NattoBallEntity;
import baguchan.tofucraft.entity.projectile.NattoStringEntity;
import baguchan.tofucraft.network.BossInfoPacket;
import baguchan.tofucraft.registry.TofuDamageSource;
import baguchan.tofucraft.registry.TofuEffects;
import baguchan.tofucraft.registry.TofuParticleTypes;
import baguchan.tofucraft.registry.TofuSounds;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;

public class ShuDofuSpider
extends Monster
implements ISmartJump {
    private static final EntityDataAccessor<Boolean> DATA_ID_JUMP = SynchedEntityData.defineId(ShuDofuSpider.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ATTACK_ANIMATION = SynchedEntityData.defineId(ShuDofuSpider.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> JUMP_ANIMATION = SynchedEntityData.defineId(ShuDofuSpider.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_ID_RANGED = SynchedEntityData.defineId(ShuDofuSpider.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> GRASP_ANIMATION = SynchedEntityData.defineId(ShuDofuSpider.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.defineId(ShuDofuSpider.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final AttributeModifier ATTACK_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"attack_boost"), 0.15, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier ARMOR_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"armor_boost"), -0.2, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private final ShuDofuSpiderPart[] subEntities;
    public final ShuDofuSpiderPart body;
    private final ShuDofuSpiderPart leg1;
    private final ShuDofuSpiderPart leg2;
    private final ShuDofuSpiderPart leg3;
    private final ShuDofuSpiderPart leg4;
    private final ShuDofuSpiderPart leg5;
    private final ShuDofuSpiderPart leg6;
    private int attackTime;
    private int jumpTime;
    private int impactTime;
    private int stinkTime;
    private int rangedTime;
    private int graspTime;
    private int angerTime;
    private float leftLegAnimation;
    private float leftLegAnimationOld;
    private float rightLegAnimation;
    private float rightLegAnimationOld;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState deathAnimationState = new AnimationState();
    public final AnimationState jumpAnimationState = new AnimationState();
    public final AnimationState graspAnimationState = new AnimationState();
    public final AnimationState graspPreAnimationState = new AnimationState();
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    private float graspDamageReceived;
    private float rangedDamageReceived;

    public ShuDofuSpider(EntityType<? extends ShuDofuSpider> p_27508_, Level p_27509_) {
        super(p_27508_, p_27509_);
        this.xpReward = 200;
        this.body = new ShuDofuSpiderPart(this, "body", 2.0f, 3.0f);
        this.leg1 = new ShuDofuSpiderPart(this, "leg", 0.75f, 2.0f);
        this.leg2 = new ShuDofuSpiderPart(this, "leg", 0.75f, 2.0f);
        this.leg3 = new ShuDofuSpiderPart(this, "leg", 0.75f, 2.0f);
        this.leg4 = new ShuDofuSpiderPart(this, "leg", 0.75f, 2.0f);
        this.leg5 = new ShuDofuSpiderPart(this, "leg", 0.75f, 2.0f);
        this.leg6 = new ShuDofuSpiderPart(this, "leg", 0.75f, 2.0f);
        this.subEntities = new ShuDofuSpiderPart[]{this.body, this.leg1, this.leg2, this.leg3, this.leg4, this.leg5, this.leg6};
        this.setId(ENTITY_COUNTER.getAndAdd(this.subEntities.length + 1) + 1);
    }

    public void setId(int id) {
        super.setId(id);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].setId(id + i + 1);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ATTACK_ANIMATION, (Object)false);
        builder.define(JUMP_ANIMATION, (Object)false);
        builder.define(DATA_ID_JUMP, (Object)false);
        builder.define(DATA_ID_RANGED, (Object)false);
        builder.define(GRASP_ANIMATION, (Object)false);
        builder.define(ANGRY, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 6.0f));
        this.goalSelector.addGoal(4, (Goal)new AttackGoal(this));
        this.goalSelector.addGoal(4, (Goal)new JumpAttackGoal());
        this.goalSelector.addGoal(3, (Goal)new graspAttackGoal(this));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, true, null));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractTofunian.class, 10, true, true, null));
    }

    private boolean isMovingOnLand() {
        return this.onGround() && this.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6 && !this.isInWaterOrBubble();
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean removeWhenFarAway(double p_21542_) {
        return false;
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.6f;
    }

    protected SoundEvent getAmbientSound() {
        return TofuSounds.TOFUSPIDER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_33814_) {
        return TofuSounds.TOFUSPIDER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return TofuSounds.TOFUSPIDER_DEATH.get();
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction p_19958_) {
        if (this.isGraspAnim()) {
            if (!this.getPassengers().isEmpty()) {
                Vec3 riderPos = this.getRiderPosition(passenger);
                p_19958_.accept(passenger, riderPos.x(), riderPos.y(), riderPos.z());
            }
        } else {
            super.positionRider(passenger, p_19958_);
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    private Vec3 getRiderPosition(Entity entity) {
        if (!this.getPassengers().isEmpty() && this.isGraspAnim()) {
            float distance = 3.0f;
            double dx = Math.cos((double)(this.getYRot() + 90.0f) * Math.PI / 180.0) * (double)distance;
            double dz = Math.sin((double)(this.getYRot() + 90.0f) * Math.PI / 180.0) * (double)distance;
            return new Vec3(this.getX() + dx, this.getY() + (double)this.getDimensions(this.getPose()).height() * 0.15 + ((Entity)this.getPassengers().get((int)0)).getVehicleAttachmentPoint((Entity)this).y, this.getZ() + dz);
        }
        Vec3 vec3 = this.getPassengerRidingPosition(entity);
        Vec3 vec31 = entity.getVehicleAttachmentPoint((Entity)this);
        return new Vec3(vec3.x - vec31.x, vec3.y - vec31.y, vec3.z - vec31.z);
    }

    public void tick() {
        ++this.stinkTime;
        if (this.stinkTime == 120) {
            this.level().addParticle((ParticleOptions)TofuParticleTypes.STINK.get(), this.getX(), this.getY() + 1.0, this.getZ(), 0.0, 0.0, 0.0);
            this.stinkTime = this.random.nextInt(0, 20);
        }
        if (this.isAlive() && !this.isMovingOnLand()) {
            this.idleAnimationState.startIfStopped(this.tickCount);
        } else {
            this.idleAnimationState.stop();
        }
        if (this.isAlive() && this.isGraspAnim()) {
            this.graspAnimationState.startIfStopped(this.tickCount);
        } else {
            this.graspAnimationState.stop();
        }
        if (!this.level().isClientSide()) {
            if (this.isAlive() && this.rangedDamageReceived > 0.0f && this.tickCount % 80 == 0) {
                this.rangedDamageReceived = Mth.clamp((float)(this.rangedDamageReceived - 4.0f), (float)0.0f, (float)60.0f);
            }
            if (this.isAlive() && !this.isGraspAnim() && this.isAttackAnim() && this.getTarget() != null) {
                ++this.attackTime;
                if (this.attackTime == 10) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)100);
                }
                if (this.attackTime == 14) {
                    float radius = 2.0f;
                    float swipePosX = (float)(this.getX() + (double)radius * Math.cos(Math.toRadians(this.getYHeadRot() + 90.0f)));
                    float swipePosZ = (float)(this.getZ() + (double)radius * Math.sin(Math.toRadians(this.getYHeadRot() + 90.0f)));
                    AABB hitBox = new AABB(BlockPos.containing((double)swipePosX, (double)(this.getY() - 0.5), (double)swipePosZ)).inflate(1.55, 1.55, 1.55);
                    List entitiesHit = this.level().getEntitiesOfClass(LivingEntity.class, hitBox);
                    for (Object entity : entitiesHit) {
                        if (entity == this || !this.canAttack((LivingEntity)entity) || this.isAlliedTo((Entity)entity) || !this.isWithinMeleeAttackRange((LivingEntity)entity)) continue;
                        this.doHurtTarget((Entity)entity);
                    }
                    this.rangedDamageReceived = 0.0f;
                    this.attackTime = 0;
                    this.setAttackAnimation(false);
                }
            }
            if (this.isAlive() && this.angerTime > 0 && this.getTarget() != null) {
                --this.angerTime;
                if (this.angerTime == 218) {
                    this.playSound(TofuSounds.TOFUSPIDER_AMBIENT.get(), 2.0f, (float)((double)0.45f + this.random.nextDouble() * (double)0.2f));
                }
                if (this.angerTime == 180 && this.distanceTo((Entity)this.getTarget()) < 16.0f) {
                    this.setJump(true);
                    this.angerTime = 0;
                }
                if (this.angerTime <= 180 && this.angerTime % 10 == 0) {
                    if (this.random.nextInt(3) == 0) {
                        this.performBreathAttack(this.getTarget());
                        this.playSound(SoundEvents.ENDER_DRAGON_SHOOT, 2.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
                    } else {
                        this.performRangedAttack(this.getTarget());
                        this.playSound(TofuSounds.TOFUSPIDER_SPIT.get(), 2.0f, (float)((double)0.6f + this.random.nextDouble() * (double)0.2f));
                    }
                }
                if (this.angerTime == 50) {
                    this.angerTime = 0;
                    this.setRanged(false);
                }
            } else if (this.isAlive() && this.isRanged() && this.getTarget() != null) {
                ++this.rangedTime;
                if (this.rangedTime == 1) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)103);
                }
                if (this.rangedTime == 30) {
                    if (this.random.nextInt(2) == 1) {
                        this.performRangedAttack(this.getTarget());
                        this.playSound(TofuSounds.TOFUSPIDER_SPIT.get(), 2.0f, (float)((double)0.6f + this.random.nextDouble() * (double)0.2f));
                    } else {
                        this.performBreathAttack(this.getTarget());
                        this.playSound(SoundEvents.ENDER_DRAGON_SHOOT, 2.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
                    }
                }
                if (this.rangedTime == 50) {
                    this.rangedTime = 0;
                    this.setRanged(false);
                }
            }
            if (this.isAlive() && this.isGraspAnim() && this.getTarget() != null) {
                LivingEntity target = this.getTarget();
                ++this.graspTime;
                if (this.graspTime == 1) {
                    this.getLookControl().setLookAt((Entity)target, 60.0f, 60.0f);
                    Vec3 vec3 = new Vec3(target.getX() - this.getX(), target.getY() - this.getY(), target.getZ() - this.getZ()).normalize();
                    this.setDeltaMovement(this.getDeltaMovement().add(vec3.x * 1.25, 0.325, vec3.z * 1.25));
                }
                if (this.graspTime > 1) {
                    Vec3 movement = this.getDeltaMovement();
                    this.checkGraspAttack(this.getBoundingBox(), this.getBoundingBox().expandTowards(movement.x, movement.y, movement.z).inflate(1.0));
                }
                if (this.graspTime == 100) {
                    this.graspTime = 0;
                    this.setGraspAnimation(false);
                    this.graspDamageReceived = 0.0f;
                    this.rangedDamageReceived = 0.0f;
                    this.rangedTime = -80;
                    this.attackTime = -120;
                    this.ejectPassengers();
                }
            } else if (this.isGraspAnim()) {
                this.setGraspAnimation(false);
            }
            if (this.isAlive() && this.isJumpAnim()) {
                ++this.jumpTime;
                if (this.jumpTime == 1) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)102);
                }
                if (this.jumpTime == 2) {
                    Vec3 movement = this.getDeltaMovement();
                    this.checkJumpAttack(this.getBoundingBox(), this.getBoundingBox().expandTowards(movement.x, movement.y, movement.z));
                }
                if (this.jumpTime == 30 && this.onGround()) {
                    this.impactTime = this.jumpTime + 40;
                }
                if (this.jumpTime >= this.impactTime && this.onGround()) {
                    ServerLevel world = (ServerLevel)this.level();
                    int count = 36;
                    float distance = 4.0f;
                    for (int i = 1; i <= count; ++i) {
                        double yaw = (float)i * 360.0f / (float)count;
                        world.sendParticles((ParticleOptions)TofuParticleTypes.STINK.get(), this.getX() + Math.cos(Math.toRadians(yaw)) * (double)distance, this.getY(), this.getZ() + Math.sin(Math.toRadians(yaw)) * (double)distance, 0, 0.0, 0.0, 0.0, 0.0);
                    }
                    float radius = 5.0f;
                    AABB hitBox = new AABB(this.getX() - (double)radius, this.getY() - 1.0, this.getZ() - (double)radius, this.getX() + (double)radius, this.getY() + 2.0, this.getZ() + (double)radius);
                    List entitiesHit = this.level().getEntitiesOfClass(LivingEntity.class, hitBox);
                    for (LivingEntity entity : entitiesHit) {
                        if (entity == this || this.isAlliedTo((Entity)entity)) continue;
                        double d12 = Math.sqrt(entity.distanceToSqr((Entity)entity)) / (double)radius * 2.0;
                        double d14 = Explosion.getSeenPercent((Vec3)new Vec3(this.getX(), this.getY(), this.getZ()), (Entity)entity);
                        double d10 = (1.0 - d12) * d14;
                        entity.addEffect(new MobEffectInstance(TofuEffects.COUGH, (int)(400.0 * d10), 0));
                        entity.hurt(this.damageSources().source(TofuDamageSource.SOY_SPORE, (Entity)this), (float)(d10 * d10 / 2.0 * 26.0));
                    }
                    this.playSound(SoundEvents.WITHER_BREAK_BLOCK, 2.0f, 1.0f);
                    this.impactTime = 0;
                    this.jumpTime = 0;
                    CameraCore.addCameraHolderList((Level)this.level(), (CameraHolder)new EntityCameraHolder(16, 60, 0.4f, GlobalVec3.of((ResourceKey)this.level().dimension(), (Vec3)this.getEyePosition()), (Entity)this));
                    this.setJumpAnimation(false);
                }
            }
            if (this.isJump() && this.isInFluidType()) {
                this.setJumping(false);
                this.setJumpAnimation(false);
            }
        } else {
            this.rightLegAnimationOld = this.rightLegAnimation;
            this.leftLegAnimationOld = this.leftLegAnimation;
            if (!this.isJump() && this.subEntities != null) {
                Direction direction = Direction.fromYRot((double)this.yBodyRot);
                BlockPos pos = this.blockPosition();
                BlockState air = Blocks.AIR.defaultBlockState();
                BlockState rBlock = this.level().getBlockState(this.leg1.blockPosition().below());
                BlockState rBlockF = this.level().getBlockState(this.leg2.blockPosition().below());
                BlockState rBlockB = this.level().getBlockState(this.leg3.blockPosition().below());
                this.rightLegAnimation = rBlock == air && rBlockF == air && rBlockB == air ? Mth.clamp((float)(this.rightLegAnimation + 0.1f), (float)-1.0f, (float)1.0f) : Mth.clamp((float)(this.rightLegAnimation * 0.5f), (float)-1.0f, (float)1.0f);
                boolean lBlock = this.hasEmptyCollisionOnLeg(this.leg4.blockPosition().below());
                boolean lBlockF = this.hasEmptyCollisionOnLeg(this.leg5.blockPosition().below());
                boolean lBlockB = this.hasEmptyCollisionOnLeg(this.leg6.blockPosition().below());
                this.leftLegAnimation = lBlock && lBlockF && lBlockB ? Mth.clamp((float)(this.leftLegAnimation + 0.1f), (float)-1.0f, (float)1.0f) : Mth.clamp((float)(this.leftLegAnimation * 0.5f), (float)-1.0f, (float)1.0f);
            } else {
                this.rightLegAnimation = Mth.clamp((float)(this.rightLegAnimation + 0.1f), (float)-1.0f, (float)1.0f);
                this.leftLegAnimation = Mth.clamp((float)(this.leftLegAnimation + 0.1f), (float)-1.0f, (float)1.0f);
            }
        }
        super.tick();
    }

    public void aiStep() {
        super.aiStep();
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].getX(), this.subEntities[j].getY(), this.subEntities[j].getZ());
        }
        Vec3 vec3 = new Vec3(0.0, 1.0, -2.0).yRot(-this.yBodyRot * ((float)Math.PI / 180));
        Vec3 vec32 = new Vec3(2.0, 0.0, 1.0).yRot(-this.yBodyRot * ((float)Math.PI / 180));
        Vec3 vec33 = new Vec3(2.0, 0.0, 0.0).yRot(-this.yBodyRot * ((float)Math.PI / 180));
        Vec3 vec34 = new Vec3(2.0, 0.0, -1.0).yRot(-this.yBodyRot * ((float)Math.PI / 180));
        Vec3 vec35 = new Vec3(-2.0, 0.0, 1.0).yRot(-this.yBodyRot * ((float)Math.PI / 180));
        Vec3 vec36 = new Vec3(-2.0, 0.0, 0.0).yRot(-this.yBodyRot * ((float)Math.PI / 180));
        Vec3 vec37 = new Vec3(-2.0, 0.0, -1.0).yRot(-this.yBodyRot * ((float)Math.PI / 180));
        this.tickPart(this.body, vec3.x * (double)this.getScale(), vec3.y * (double)this.getScale(), vec3.z * (double)this.getScale());
        this.tickPart(this.leg1, vec32.x * (double)this.getScale(), vec32.y * (double)this.getScale(), vec32.z * (double)this.getScale());
        this.tickPart(this.leg2, vec33.x * (double)this.getScale(), vec33.y * (double)this.getScale(), vec33.z * (double)this.getScale());
        this.tickPart(this.leg3, vec34.x * (double)this.getScale(), vec34.y * (double)this.getScale(), vec34.z * (double)this.getScale());
        this.tickPart(this.leg4, vec35.x * (double)this.getScale(), vec35.y * (double)this.getScale(), vec35.z * (double)this.getScale());
        this.tickPart(this.leg5, vec36.x * (double)this.getScale(), vec36.y * (double)this.getScale(), vec36.z * (double)this.getScale());
        this.tickPart(this.leg6, vec37.x * (double)this.getScale(), vec37.y * (double)this.getScale(), vec37.z * (double)this.getScale());
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].xo = avec3[l].x;
            this.subEntities[l].yo = avec3[l].y;
            this.subEntities[l].zo = avec3[l].z;
            this.subEntities[l].xOld = avec3[l].x;
            this.subEntities[l].yOld = avec3[l].y;
            this.subEntities[l].zOld = avec3[l].z;
        }
    }

    protected float sanitizeScale(float p_320290_) {
        return 1.0f;
    }

    private void tickPart(ShuDofuSpiderPart p_31116_, double p_31117_, double p_31118_, double p_31119_) {
        p_31116_.setPos(this.getX() + p_31117_, this.getY() + p_31118_, this.getZ() + p_31119_);
    }

    public boolean hasEmptyCollisionOnLeg(BlockPos blockPos) {
        boolean rBlock = this.level().getBlockState(blockPos).getCollisionShape((BlockGetter)this.level(), blockPos).isEmpty();
        return rBlock;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRightLegAnimationScale(float p_29570_) {
        return Mth.lerp((float)p_29570_, (float)this.rightLegAnimationOld, (float)this.rightLegAnimation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getLeftLegAnimationScale(float p_29570_) {
        return Mth.lerp((float)p_29570_, (float)this.leftLegAnimationOld, (float)this.leftLegAnimation);
    }

    public boolean canDisableShield() {
        return this.isGraspAnim();
    }

    public void performRangedAttack(LivingEntity p_29912_) {
        if (this.angerTime > 0) {
            NattoStringEntity natto = new NattoStringEntity(this.level(), (LivingEntity)this);
            double d1 = p_29912_.getX() - this.getX();
            double d2 = p_29912_.getY() - this.getEyeY();
            double d3 = p_29912_.getZ() - this.getZ();
            float f = Mth.sqrt((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
            natto.shoot(d1, d2 + (double)f + 0.5, d3, 0.6f + f * 0.1f, 2.0f + (float)this.random.nextInt(20) + 10.0f);
            natto.setSmall(true);
            this.level().addFreshEntity((Entity)natto);
        } else {
            for (int i = 0; i < 3; ++i) {
                NattoStringEntity natto = new NattoStringEntity(this.level(), (LivingEntity)this);
                double d1 = p_29912_.getX() - this.getX();
                double d2 = p_29912_.getY() - this.getEyeY();
                double d3 = p_29912_.getZ() - this.getZ();
                float f = Mth.sqrt((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
                natto.shoot(d1, d2 + (double)f, d3, 1.0f, 2.0f + (float)this.random.nextInt(20) + 10.0f);
                this.level().addFreshEntity((Entity)natto);
            }
        }
    }

    public void performBreathAttack(LivingEntity p_29912_) {
        if (this.angerTime > 0) {
            NattoBallEntity ball = new NattoBallEntity(this.level(), (LivingEntity)this);
            double d1 = p_29912_.getX() - this.getX();
            double d2 = p_29912_.getEyeY() - this.getY();
            double d3 = p_29912_.getZ() - this.getZ();
            float f = Mth.sqrt((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
            ball.setSmall(true);
            ball.shoot(d1, d2 + (double)f + 0.5, d3, 0.6f + f * 0.1f, 2.0f + (float)this.random.nextInt(10) + 10.0f);
            this.level().addFreshEntity((Entity)ball);
        } else {
            NattoBallEntity ball = new NattoBallEntity(this.level(), (LivingEntity)this);
            double d1 = p_29912_.getX() - this.getX();
            double d2 = p_29912_.getEyeY() - this.getY();
            double d3 = p_29912_.getZ() - this.getZ();
            ball.shoot(d1, d2 + 0.5, d3, 1.0f, 0.0f);
            this.level().addFreshEntity((Entity)ball);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte p_70103_1_) {
        if (p_70103_1_ == 100) {
            this.attackAnimationState.start(this.tickCount);
        } else if (p_70103_1_ == 101) {
            this.deathAnimationState.start(this.tickCount);
        } else if (p_70103_1_ == 102) {
            this.jumpAnimationState.start(this.tickCount);
        } else if (p_70103_1_ == 104) {
            this.graspPreAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(p_70103_1_);
        }
    }

    protected void checkJumpAttack(AABB p_21072_, AABB p_21073_) {
        AABB aabb = p_21072_.minmax(p_21073_);
        List list = this.level().getEntities((Entity)this, aabb);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity == this) continue;
                this.jumpAttack(entity);
                break;
            }
        } else if (this.horizontalCollision && this.tickCount % 3 == 0) {
            this.playSound(SoundEvents.PLAYER_ATTACK_KNOCKBACK, 2.0f, 1.0f);
        }
    }

    public void jumpAttack(Entity p_36347_) {
        if (p_36347_.isAttackable() && !this.isAlliedTo(p_36347_)) {
            p_36347_.hurt(this.damageSources().mobAttack((LivingEntity)this), 18.0f);
            float i = (float)this.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
            i += 1.5f;
            if (i > 0.0f) {
                if (p_36347_ instanceof LivingEntity) {
                    ((LivingEntity)p_36347_).knockback((double)i, (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                } else {
                    p_36347_.push((double)(-Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * i), 0.1, (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * i));
                }
                this.setSprinting(false);
            }
        }
    }

    protected void checkGraspAttack(AABB p_21072_, AABB p_21073_) {
        AABB aabb = p_21072_.minmax(p_21073_);
        List list = this.level().getEntities((Entity)this, aabb);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity == this || entity instanceof PartEntity || !entity.isAttackable() || this.isAlliedTo(entity) || entity instanceof NattoCobWebEntity) continue;
                this.graspAttack(entity);
                break;
            }
        }
    }

    public void graspAttack(Entity entity) {
        float f = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        if (entity.hurt(this.damageSources().mobAttack((LivingEntity)this), f * 0.2f)) {
            this.heal(f * 0.2f);
        }
        if (entity instanceof LivingEntity && !entity.getType().is(Tags.EntityTypes.BOSSES) && this.getPassengers().isEmpty()) {
            entity.stopRiding();
            entity.startRiding((Entity)this, true);
        }
        this.setSprinting(false);
    }

    protected void playStepSound(BlockPos p_33804_, BlockState p_33805_) {
        this.playSound(SoundEvents.SPIDER_STEP, 1.0f, 0.6f);
    }

    public void die(DamageSource p_21014_) {
        super.die(p_21014_);
        this.playSound(SoundEvents.SPIDER_DEATH, 1.0f, 0.6f);
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)101);
        }
    }

    public boolean canBeAffected(MobEffectInstance p_479991_) {
        return p_479991_.is(MobEffects.POISON) || p_479991_.is(MobEffects.MOVEMENT_SLOWDOWN) || p_479991_.is(MobEffects.HARM) || p_479991_.is(TofuEffects.COUGH) ? false : super.canBeAffected(p_479991_);
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 38) {
            // empty if block
        }
        if (this.deathTime == 40) {
            // empty if block
        }
        if (this.deathTime == 100 && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)101);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean hurt(DamageSource p_31461_, float p_31462_) {
        if (this.isInvulnerableTo(p_31461_)) {
            return false;
        }
        if (!(p_31461_.is(DamageTypes.SWEET_BERRY_BUSH) || p_31461_.is(DamageTypes.CACTUS) || p_31461_.is(DamageTypes.CRAMMING) || p_31461_.is(DamageTypes.IN_WALL) || p_31461_.is(DamageTypes.STALAGMITE))) {
            boolean flag;
            Entity entity = p_31461_.getDirectEntity();
            float f = this.getHealth();
            if (entity instanceof FukumameEntity) {
                return false;
            }
            if (entity instanceof Projectile && (flag = super.hurt(p_31461_, p_31462_ * 0.3f))) {
                this.hurtCounter(f);
            }
            if (flag = super.hurt(p_31461_, p_31462_)) {
                this.hurtCounter(f);
            }
            return flag;
        }
        return false;
    }

    public boolean hurt(ShuDofuSpiderPart shuDofuSpiderPart, DamageSource damageSource, float damage) {
        float f = this.getHealth();
        this.reallyHurt(damageSource, damage * 0.9f);
        this.hurtCounter(f);
        return true;
    }

    private void hurtCounter(float pastHealth) {
        if (!this.isAngry() && this.getHealth() < this.getMaxHealth() / 2.0f) {
            this.setAngry(true);
            this.playSound(SoundEvents.WITHER_BREAK_BLOCK, 2.0f, 1.0f);
        }
        if (this.isGraspAnim()) {
            this.graspDamageReceived = this.graspDamageReceived + pastHealth - this.getHealth();
            if (this.graspDamageReceived > 0.1f * this.getMaxHealth()) {
                this.graspDamageReceived = 0.0f;
                this.setGraspAnimation(false);
                this.attackTime = -60;
            }
        } else {
            this.rangedDamageReceived = this.rangedDamageReceived + pastHealth - this.getHealth();
            if (this.rangedDamageReceived > 40.0f) {
                this.rangedDamageReceived = 0.0f;
                this.attackTime = -80;
                this.rangedTime = -120;
                this.angerTime = 220;
            }
        }
    }

    public boolean isPushable() {
        return false;
    }

    public boolean causeFallDamage(float p_148989_, float p_148990_, DamageSource p_148991_) {
        return false;
    }

    protected void checkFallDamage(double p_29370_, boolean p_29371_, BlockState p_29372_, BlockPos p_29373_) {
    }

    public void makeStuckInBlock(BlockState p_20006_, Vec3 p_20007_) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 500.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.ATTACK_KNOCKBACK, (double)1.15f).add(Attributes.KNOCKBACK_RESISTANCE, 5.0).add(Attributes.ARMOR, 16.0).add(Attributes.ARMOR_TOUGHNESS, 2.0).add(Attributes.ATTACK_DAMAGE, 16.0);
    }

    public boolean isAlliedTo(Entity p_20355_) {
        if (p_20355_ instanceof ShuDofuSpider || p_20355_ instanceof TofuSpider) {
            return this.getTeam() == null && p_20355_.getTeam() == null;
        }
        if (p_20355_ instanceof NattoCobWebEntity) {
            return false;
        }
        return super.isAlliedTo(p_20355_);
    }

    protected int decreaseAirSupply(int p_28882_) {
        return p_28882_;
    }

    private boolean reallyHurt(DamageSource damageSource, float damage) {
        return super.hurt(damageSource, damage);
    }

    protected float getJumpPower() {
        float f = 0.42f;
        Path path = this.navigation.getPath();
        if (path != null && !path.isDone()) {
            Vec3 vec3 = path.getNextEntityPos((Entity)this);
            if (vec3.y > this.getY() + 0.5) {
                f = 0.5f;
            }
            if (vec3.y > this.getY() + 1.5) {
                f = 0.65f;
            }
        }
        return super.getJumpPower((float)((double)f / this.getAttributeValue(Attributes.JUMP_STRENGTH)));
    }

    public float getSuppportJump() {
        return 2.125f;
    }

    protected void customServerAiStep() {
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public static boolean isPathClear(ShuDofuSpider p_28472_, LivingEntity p_28473_) {
        double d0 = p_28473_.getZ() - p_28472_.getZ();
        double d1 = p_28473_.getX() - p_28472_.getX();
        double d2 = d0 / d1;
        for (int j = 0; j < 6; ++j) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)j / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)j / 6.0f) : d3 / d2;
            for (int k = 1; k < 4; ++k) {
                if (p_28472_.level().getBlockState(BlockPos.containing((double)(p_28472_.getX() + d4), (double)(p_28472_.getY() + (double)k), (double)(p_28472_.getZ() + d3))).canBeReplaced()) continue;
                return false;
            }
        }
        return true;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new BossInfoPacket.Display(this.bossEvent.getId(), this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.bossEvent.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new BossInfoPacket.Remove(this.bossEvent.getId(), this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.bossEvent.removePlayer(player);
    }

    public void addAdditionalSaveData(CompoundTag p_21484_) {
        super.addAdditionalSaveData(p_21484_);
        p_21484_.putBoolean("Angry", this.isAngry());
    }

    public void readAdditionalSaveData(CompoundTag p_31474_) {
        super.readAdditionalSaveData(p_31474_);
        this.setAngry(p_31474_.getBoolean("Angry"));
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
    }

    public void setCustomName(@Nullable Component p_31476_) {
        super.setCustomName(p_31476_);
        this.bossEvent.setName(this.getDisplayName());
    }

    public void setAttackAnimation(boolean attack) {
        this.entityData.set(ATTACK_ANIMATION, (Object)attack);
    }

    public boolean isAttackAnim() {
        return (Boolean)this.entityData.get(ATTACK_ANIMATION);
    }

    public void setGraspAnimation(boolean grasp) {
        this.entityData.set(GRASP_ANIMATION, (Object)grasp);
    }

    public boolean isGraspAnim() {
        return (Boolean)this.entityData.get(GRASP_ANIMATION);
    }

    public void setJumpAnimation(boolean jump) {
        this.entityData.set(JUMP_ANIMATION, (Object)jump);
    }

    public boolean isJumpAnim() {
        return (Boolean)this.entityData.get(JUMP_ANIMATION);
    }

    private void setJump(boolean jump) {
        this.entityData.set(DATA_ID_JUMP, (Object)jump);
    }

    public boolean isJump() {
        return (Boolean)this.entityData.get(DATA_ID_JUMP);
    }

    public void setRanged(boolean ranged) {
        this.entityData.set(DATA_ID_RANGED, (Object)ranged);
    }

    public boolean isRanged() {
        return (Boolean)this.entityData.get(DATA_ID_RANGED);
    }

    public void setAngry(boolean angry) {
        this.entityData.set(ANGRY, (Object)angry);
        if (this.level() != null && !this.level().isClientSide) {
            AttributeInstance attributeinstance = this.getAttribute(Attributes.ATTACK_DAMAGE);
            attributeinstance.removeModifier(ATTACK_MODIFIER.id());
            AttributeInstance attributeinstance2 = this.getAttribute(Attributes.ARMOR);
            attributeinstance2.removeModifier(ARMOR_MODIFIER.id());
            if (angry) {
                attributeinstance.addTransientModifier(ATTACK_MODIFIER);
                attributeinstance2.addTransientModifier(ARMOR_MODIFIER);
            }
        }
    }

    public boolean isAngry() {
        return (Boolean)this.entityData.get(ANGRY);
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    static class AttackGoal
    extends Goal {
        private final ShuDofuSpider spider;
        private int attackTime;
        private int attackStep;
        private int lastSeen;
        private Path path;

        public AttackGoal(ShuDofuSpider p_32247_) {
            this.spider = p_32247_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.spider.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            if (this.spider.isGraspAnim()) {
                return false;
            }
            if (this.spider.isJumpAnim()) {
                return false;
            }
            this.path = this.spider.getNavigation().createPath((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.spider.canAttack(livingentity);
        }

        public void start() {
            this.attackStep = 0;
        }

        public void stop() {
            this.lastSeen = 0;
        }

        protected double getAttackReachSqr(LivingEntity p_29587_) {
            return 4.0f + p_29587_.getBbWidth();
        }

        public void tick() {
            --this.attackTime;
            ShuDofuSpider entity = this.spider;
            LivingEntity entityTarget = entity.getTarget();
            if (entityTarget != null) {
                boolean flag = this.spider.getSensing().hasLineOfSight((Entity)entityTarget);
                double d0 = this.spider.distanceToSqr((Entity)entityTarget);
                if (!this.spider.isRanged() && this.spider.angerTime <= 0) {
                    this.spider.getNavigation().moveTo(this.path, 0.8);
                }
                if (!flag) {
                    return;
                }
                if (entity.isWithinMeleeAttackRange(entityTarget) && this.attackTime <= 10) {
                    entity.setAttackAnimation(true);
                    this.attackTime = 20;
                    this.attackStep = 0;
                }
                if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 20;
                        } else if (this.attackStep <= 2) {
                            this.attackTime = 10;
                        } else {
                            this.attackTime = 20;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1 && !entity.isRanged()) {
                            this.spider.setRanged(true);
                        }
                    }
                    entity.getLookControl().setLookAt((Entity)entityTarget, 10.0f, 10.0f);
                }
            }
            super.tick();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        private double getFollowDistance() {
            return this.spider.getAttributeValue(Attributes.FOLLOW_RANGE);
        }
    }

    public class JumpAttackGoal
    extends JumpGoal {
        private int attackTime;

        public boolean canUse() {
            if (this.attackTime == 0) {
                if (ShuDofuSpider.this.getHealth() <= ShuDofuSpider.this.getMaxHealth() / 1.5f && !ShuDofuSpider.this.isGraspAnim() && ShuDofuSpider.this.angerTime <= 0) {
                    LivingEntity livingentity = ShuDofuSpider.this.getTarget();
                    if (livingentity != null && livingentity.isAlive() && 10.0f >= ShuDofuSpider.this.distanceTo((Entity)livingentity)) {
                        if (ShuDofuSpider.this.random.nextInt(2) == 0) {
                            return false;
                        }
                        if (livingentity.getMotionDirection() != livingentity.getDirection()) {
                            return false;
                        }
                        boolean flag = ShuDofuSpider.isPathClear(ShuDofuSpider.this, livingentity);
                        if (!flag) {
                            ShuDofuSpider.this.getNavigation().createPath((Entity)livingentity, 0);
                        }
                        ShuDofuSpider.this.setJump(true);
                        this.attackTime = 120;
                        return flag;
                    }
                    return false;
                }
                return false;
            }
            --this.attackTime;
            return false;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = ShuDofuSpider.this.getTarget();
            if (livingentity != null && livingentity.isAlive()) {
                double d0 = ShuDofuSpider.this.getDeltaMovement().y;
                return !(d0 * d0 < (double)0.05f) || !(Math.abs(ShuDofuSpider.this.getXRot()) < 15.0f) || !ShuDofuSpider.this.onGround();
            }
            return false;
        }

        public boolean isInterruptable() {
            return false;
        }

        public void start() {
            ShuDofuSpider.this.setJumping(true);
            LivingEntity livingentity = ShuDofuSpider.this.getTarget();
            if (livingentity != null) {
                ShuDofuSpider.this.setJumpAnimation(true);
                ShuDofuSpider.this.getLookControl().setLookAt((Entity)livingentity, 60.0f, 60.0f);
                Vec3 vec3 = new Vec3(livingentity.getX() - ShuDofuSpider.this.getX(), livingentity.getY() - ShuDofuSpider.this.getY(), livingentity.getZ() - ShuDofuSpider.this.getZ()).normalize();
                ShuDofuSpider.this.setDeltaMovement(ShuDofuSpider.this.getDeltaMovement().add(vec3.x * 1.2, 1.2, vec3.z * 1.2));
            }
            ShuDofuSpider.this.getNavigation().stop();
        }

        public void stop() {
            ShuDofuSpider.this.setJump(false);
        }

        public void tick() {
            LivingEntity livingentity = ShuDofuSpider.this.getTarget();
            Vec3 vec3 = ShuDofuSpider.this.getDeltaMovement();
            if (vec3.y * vec3.y < (double)0.03f && ShuDofuSpider.this.getXRot() != 0.0f) {
                ShuDofuSpider.this.setXRot(Mth.rotLerp((float)ShuDofuSpider.this.getXRot(), (float)0.0f, (float)0.2f));
            } else {
                double d0 = vec3.horizontalDistance();
                double d1 = Math.signum(-vec3.y) * Math.acos(d0 / vec3.length()) * 57.2957763671875;
                ShuDofuSpider.this.setXRot((float)d1);
            }
        }
    }

    static class graspAttackGoal
    extends Goal {
        private final ShuDofuSpider spider;
        private int attackTime;
        private int preAttackTime;

        public graspAttackGoal(ShuDofuSpider p_32247_) {
            this.spider = p_32247_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.attackTime == 0) {
                LivingEntity livingentity = this.spider.getTarget();
                if (livingentity != null && this.spider.isAngry() && livingentity.isAlive() && 10.0f >= this.spider.distanceTo((Entity)livingentity)) {
                    if (livingentity.getMotionDirection() != livingentity.getDirection()) {
                        return false;
                    }
                    boolean flag = ShuDofuSpider.isPathClear(this.spider, livingentity);
                    if (!flag) {
                        this.spider.getNavigation().createPath((Entity)livingentity, 0);
                    }
                    this.attackTime = 350;
                    return flag;
                }
                return false;
            }
            --this.attackTime;
            return false;
        }

        public boolean canContinueToUse() {
            return this.preAttackTime < 30;
        }

        public boolean isInterruptable() {
            return false;
        }

        public void start() {
            LivingEntity livingentity = this.spider.getTarget();
            if (livingentity != null) {
                this.spider.level().broadcastEntityEvent((Entity)this.spider, (byte)104);
                this.spider.playAmbientSound();
            }
            this.preAttackTime = 0;
        }

        public void tick() {
            this.spider.getNavigation().stop();
            ++this.preAttackTime;
        }

        public void stop() {
            super.stop();
            LivingEntity livingentity = this.spider.getTarget();
            if (livingentity != null) {
                this.spider.setGraspAnimation(true);
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }
}

