/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity.projectile;

import baguchan.tofucraft.registry.TofuEntityTypes;
import baguchan.tofucraft.registry.TofuParticleTypes;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class NattoBallEntity
extends ThrowableProjectile {
    protected static final EntityDataAccessor<Boolean> DATA_SMALL = SynchedEntityData.defineId(NattoBallEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public NattoBallEntity(EntityType<? extends NattoBallEntity> p_36892_, Level p_36893_) {
        super(p_36892_, p_36893_);
    }

    public NattoBallEntity(Level worldIn, LivingEntity throwerIn) {
        super(TofuEntityTypes.NATTO_BALL.get(), throwerIn, worldIn);
    }

    protected boolean canHitEntity(Entity p_37250_) {
        return false;
    }

    protected void onHit(HitResult p_36913_) {
        super.onHit(p_36913_);
        if (!(p_36913_.getType() == HitResult.Type.ENTITY && this.ownedBy(((EntityHitResult)p_36913_).getEntity()) || this.level().isClientSide)) {
            List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(4.0, 2.0, 4.0));
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            Entity entity = this.getOwner();
            if (entity instanceof LivingEntity) {
                areaeffectcloud.setOwner((LivingEntity)entity);
            }
            areaeffectcloud.setParticle((ParticleOptions)TofuParticleTypes.SIMPLE_STINKE.get());
            areaeffectcloud.setRadius(this.isSmall() ? 1.25f : 3.0f);
            areaeffectcloud.setDuration(this.isSmall() ? 80 : 200);
            areaeffectcloud.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 1));
            if (!list.isEmpty()) {
                for (LivingEntity livingentity : list) {
                    double d0 = this.distanceToSqr((Entity)livingentity);
                    if (!(d0 < 16.0)) continue;
                    areaeffectcloud.setPos(livingentity.getX(), livingentity.getY(), livingentity.getZ());
                    break;
                }
            }
            this.level().addFreshEntity((Entity)areaeffectcloud);
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_SMALL, (Object)false);
    }

    public boolean isSmall() {
        return (Boolean)this.entityData.get(DATA_SMALL);
    }

    public void setSmall(boolean p_149789_) {
        this.entityData.set(DATA_SMALL, (Object)p_149789_);
    }

    public void readAdditionalSaveData(CompoundTag p_33432_) {
        super.readAdditionalSaveData(p_33432_);
        this.setSmall(p_33432_.getBoolean("Small"));
    }

    public void addAdditionalSaveData(CompoundTag p_33443_) {
        super.addAdditionalSaveData(p_33443_);
        p_33443_.putBoolean("Small", this.isSmall());
    }

    public boolean isPickable() {
        return false;
    }
}

