/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.inventory;

import baguchan.tofucraft.blockentity.tfenergy.TFCraftingTableBlockEntity;
import baguchan.tofucraft.inventory.slot.TofuPotResultSlot;
import baguchan.tofucraft.recipe.TFCraftingRecipe;
import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuMenus;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TFCraftingTableMenu
extends RecipeBookMenu<CraftingInput, TFCraftingRecipe> {
    public final TFCraftingTableBlockEntity blockEntity;
    public final Container inventory;
    private final ContainerData data;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    public TFCraftingTableMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, TFCraftingTableMenu.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(4));
    }

    public TFCraftingTableMenu(int windowId, Inventory playerInventory, TFCraftingTableBlockEntity blockEntity, ContainerData cookingPotDataIn) {
        super(TofuMenus.TF_CRAFTING_TABLE.get(), windowId);
        int column;
        this.blockEntity = blockEntity;
        this.inventory = blockEntity;
        this.data = cookingPotDataIn;
        this.level = playerInventory.player.level();
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
        int startX = 8;
        int startY = 18;
        int inputStartX = 30;
        int inputStartY = 17;
        int borderSlotSize = 18;
        for (int row = 0; row < 3; ++row) {
            for (column = 0; column < 3; ++column) {
                this.addSlot(new Slot(this.inventory, row * 3 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.addSlot(new TofuPotResultSlot(this, playerInventory.player, this.inventory, 9, 123, 34){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
        int startPlayerInvY = 84;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.addSlot(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 142));
        }
        this.addDataSlots(cookingPotDataIn);
    }

    private static TFCraftingTableBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof TFCraftingTableBlockEntity) {
            return (TFCraftingTableBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean stillValid(Player playerIn) {
        return TFCraftingTableMenu.stillValid((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)TofuBlocks.TF_CRAFTING_TABLE.get());
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        int indexMealDisplay = 6;
        int indexContainerInput = 7;
        int indexOutput = 8;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack slotStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            slotStackCopy = slotStack.copy();
            if (index != indexOutput ? (index >= startPlayerInv && index < endPlayerInv - 9 ? !this.moveItemStackTo(slotStack, endPlayerInv - 9, endPlayerInv, false) : index >= endPlayerInv - 9 && index < endPlayerInv && !this.moveItemStackTo(slotStack, startPlayerInv, endPlayerInv - 9, false)) : !this.moveItemStackTo(slotStack, startPlayerInv, endPlayerInv, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == slotStackCopy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, slotStack);
        }
        return slotStackCopy;
    }

    public int getCookProgressionScaled() {
        int i = this.data.get(0);
        int j = this.data.get(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTFEnergy() {
        int i = this.data.get(2);
        return i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTFMaxEnergy() {
        int i = this.data.get(3);
        return i;
    }

    public void fillCraftSlotsStackedContents(StackedContents helper) {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            helper.accountSimpleStack(this.inventory.getItem(i));
        }
    }

    public void clearCraftingContent() {
        for (int i = 0; i < 8; ++i) {
            this.inventory.setItem(i, ItemStack.EMPTY);
        }
    }

    public boolean recipeMatches(RecipeHolder<TFCraftingRecipe> recipe) {
        return ((TFCraftingRecipe)recipe.value()).matches((RecipeInput)CraftingInput.of((int)3, (int)3, this.blockEntity.getInventory()), this.level);
    }

    public int getResultSlotIndex() {
        return 9;
    }

    public int getGridWidth() {
        return 3;
    }

    public int getGridHeight() {
        return 3;
    }

    public int getSize() {
        return 9;
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.valueOf((String)"TOFUCRAFT_TF_CRAFT");
    }

    public boolean shouldMoveToInventory(int slot) {
        return slot < this.getGridWidth() * this.getGridHeight();
    }
}

